/*
 * Copyright oVirt Authors
 * SPDX-License-Identifier: Apache-2.0
*/

package org.ovirt.engine.api.v3.adapters;

import static org.ovirt.engine.api.v3.adapters.V3InAdapters.adaptIn;

import org.ovirt.engine.api.model.CustomProperties;
import org.ovirt.engine.api.model.Template;
import org.ovirt.engine.api.model.TemplateStatus;
import org.ovirt.engine.api.model.TimeZone;
import org.ovirt.engine.api.model.VmType;
import org.ovirt.engine.api.v3.V3Adapter;
import org.ovirt.engine.api.v3.types.V3Template;

public class V3TemplateInAdapter implements V3Adapter<V3Template, Template> {
    @Override
    public Template adapt(V3Template from) {
        Template to = new Template();
        if (from.isSetLinks()) {
            to.getLinks().addAll(adaptIn(from.getLinks()));
        }
        if (from.isSetActions()) {
            to.setActions(adaptIn(from.getActions()));
        }
        if (from.isSetBios()) {
            to.setBios(adaptIn(from.getBios()));
        }
        if (from.isSetCluster()) {
            to.setCluster(adaptIn(from.getCluster()));
        }
        if (from.isSetComment()) {
            to.setComment(from.getComment());
        }
        if (from.isSetConsole()) {
            to.setConsole(adaptIn(from.getConsole()));
        }
        if (from.isSetCpu()) {
            to.setCpu(adaptIn(from.getCpu()));
        }
        if (from.isSetCpuProfile()) {
            to.setCpuProfile(adaptIn(from.getCpuProfile()));
        }
        if (from.isSetCpuShares()) {
            to.setCpuShares(from.getCpuShares());
        }
        if (from.isSetCreationTime()) {
            to.setCreationTime(from.getCreationTime());
        }
        if (from.isSetCustomCpuModel()) {
            to.setCustomCpuModel(from.getCustomCpuModel());
        }
        if (from.isSetCustomEmulatedMachine()) {
            to.setCustomEmulatedMachine(from.getCustomEmulatedMachine());
        }
        if (from.isSetCustomProperties()) {
            to.setCustomProperties(new CustomProperties());
            to.getCustomProperties().getCustomProperties().addAll(adaptIn(from.getCustomProperties().getCustomProperty()));
        }
        if (from.isSetDeleteProtected()) {
            to.setDeleteProtected(from.isDeleteProtected());
        }
        if (from.isSetDescription()) {
            to.setDescription(from.getDescription());
        }
        if (from.isSetDisplay()) {
            to.setDisplay(adaptIn(from.getDisplay()));
        }
        if (from.isSetDomain()) {
            to.setDomain(adaptIn(from.getDomain()));
        }
        if (from.isSetHighAvailability()) {
            to.setHighAvailability(adaptIn(from.getHighAvailability()));
        }
        if (from.isSetId()) {
            to.setId(from.getId());
        }
        if (from.isSetIo()) {
            to.setIo(adaptIn(from.getIo()));
        }
        if (from.isSetHref()) {
            to.setHref(from.getHref());
        }
        if (from.isSetLargeIcon()) {
            to.setLargeIcon(adaptIn(from.getLargeIcon()));
        }
        if (from.isSetMemory()) {
            to.setMemory(from.getMemory());
        }
        if (from.isSetMemoryPolicy()) {
            to.setMemoryPolicy(adaptIn(from.getMemoryPolicy()));
        }
        if (from.isSetMigration()) {
            to.setMigration(adaptIn(from.getMigration()));
        }
        if (from.isSetMigrationDowntime()) {
            to.setMigrationDowntime(from.getMigrationDowntime());
        }
        if (from.isSetName()) {
            to.setName(from.getName());
        }
        if (from.isSetOrigin()) {
            to.setOrigin(from.getOrigin());
        }
        if (from.isSetOs()) {
            to.setOs(adaptIn(from.getOs()));
        }
        if (from.isSetRngDevice()) {
            to.setRngDevice(adaptIn(from.getRngDevice()));
        }
        if (from.isSetSerialNumber()) {
            to.setSerialNumber(adaptIn(from.getSerialNumber()));
        }
        if (from.isSetSmallIcon()) {
            to.setSmallIcon(adaptIn(from.getSmallIcon()));
        }
        if (from.isSetSoundcardEnabled()) {
            to.setSoundcardEnabled(from.isSoundcardEnabled());
        }
        if (from.isSetSso()) {
            to.setSso(adaptIn(from.getSso()));
        }
        if (from.isSetStartPaused()) {
            to.setStartPaused(from.isStartPaused());
        }
        if (from.isSetStateless()) {
            to.setStateless(from.isStateless());
        }
        if (from.isSetStatus() && from.getStatus().isSetState()) {
            to.setStatus(TemplateStatus.fromValue(from.getStatus().getState()));
        }
        if (from.isSetStorageDomain()) {
            to.setStorageDomain(adaptIn(from.getStorageDomain()));
        }
        if (from.isSetTimeZone()) {
            to.setTimeZone(adaptIn(from.getTimeZone()));
        }
        if (from.isSetTunnelMigration()) {
            to.setTunnelMigration(from.isTunnelMigration());
        }
        if (from.isSetType()) {
            to.setType(VmType.fromValue(from.getType()));
        }
        if (from.isSetUsb()) {
            to.setUsb(adaptIn(from.getUsb()));
        }
        if (from.isSetVersion()) {
            to.setVersion(adaptIn(from.getVersion()));
        }
        if (from.isSetVirtioScsi()) {
            to.setVirtioScsi(adaptIn(from.getVirtioScsi()));
        }
        if (from.isSetVm()) {
            to.setVm(adaptIn(from.getVm()));
        }

        // V3 of the API supports a "timezone" element containing a single string, but V4 has replaced that with a
        // new structured "time_zone" element containing the name of the time zone and the UTC offset:
        if (from.isSetTimezone() && !to.isSetTimeZone()) {
            TimeZone timeZone = new TimeZone();
            timeZone.setName(from.getTimezone());
            to.setTimeZone(timeZone);
        }

        return to;
    }
}
