/*
 * Copyright oVirt Authors
 * SPDX-License-Identifier: Apache-2.0
*/

package org.ovirt.engine.api.v3.servers;

import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

import org.ovirt.engine.api.resource.JobsResource;
import org.ovirt.engine.api.v3.V3Server;
import org.ovirt.engine.api.v3.types.V3Job;
import org.ovirt.engine.api.v3.types.V3Jobs;

@Produces({"application/xml", "application/json"})
public class V3JobsServer extends V3Server<JobsResource> {
    public V3JobsServer(JobsResource delegate) {
        super(delegate);
    }

    @POST
    @Consumes({"application/xml", "application/json"})
    public Response add(V3Job job) {
        return adaptAdd(getDelegate()::add, job);
    }

    @GET
    public V3Jobs list() {
        return adaptList(getDelegate()::list);
    }

    @Path("{id}")
    public V3JobServer getJobResource(@PathParam("id") String id) {
        return new V3JobServer(getDelegate().getJobResource(id));
    }
}
