/*
 * Copyright oVirt Authors
 * SPDX-License-Identifier: Apache-2.0
*/

package org.ovirt.engine.api.v3.servers;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;

import org.ovirt.engine.api.resource.VmSessionsResource;
import org.ovirt.engine.api.v3.V3Server;
import org.ovirt.engine.api.v3.types.V3Sessions;

@Produces({"application/xml", "application/json"})
public class V3VmSessionsServer extends V3Server<VmSessionsResource> {
    public V3VmSessionsServer(VmSessionsResource delegate) {
        super(delegate);
    }

    @GET
    public V3Sessions list() {
        return adaptList(getDelegate()::list);
    }

    @Path("{id}")
    public V3VmSessionServer getSessionResource(@PathParam("id") String id) {
        return new V3VmSessionServer(getDelegate().getSessionResource(id));
    }
}
