# coding: utf-8

import sys

from resources.lib.untangle import *


# noinspection PyBroadException
def main():
    # try:
    movies_folder = xbmc.translatePath(get_setting('movies_folder'))
    shows_folder = xbmc.translatePath(get_setting('shows_folder'))

    query = xbmc.getInfoLabel("ListItem.OriginalTitle")
    if len(query) == 0:
        query = sys.listitem.getLabel()

    tv_show_title = xbmc.getInfoLabel("ListItem.TVShowTitle")
    season = xbmc.getInfoLabel("ListItem.Season")
    episode = xbmc.getInfoLabel("ListItem.Episode")
    # checking if it is tv show
    if len(tv_show_title) > 0 and len(season) > 0 and len(episode) > 0:
        query = "%s S%02dE%02d" % (tv_show_title, int(season), int(episode))

    elif len(tv_show_title) > 0 and len(season) > 0:
        query = "%s S%02d" % (tv_show_title, int(season))
    # send the information to magnetic
    if len(query) > 0:
        link = 'plugin://script.module.magnetic?mode=search&query=%s' % query.replace(' ', '%20')
        is_movie = xbmc.getCondVisibility("Container.Content(movies)")
        folder = movies_folder if is_movie else shows_folder
        create_strm(folder, query, link, xbmc.getInfoLabel("ListItem.DBID"))
        if not xbmc.getCondVisibility('Library.IsScanningVideo'):
            xbmc.executebuiltin('XBMC.UpdateLibrary(video)')  # update the library with the new information
            # except:
            #     pass


if __name__ == '__main__':
    main()
