# -*- coding: utf-8 -*-

import re
import urllib2,urllib
import base64
import time
import cookielib,os

UA='Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/50.0.2661.102 Safari/537.36'

# rtmp://app.itivi.pl/live/<playpath>TVP1HD <swfUrl>http://itivi.pl/js/jwplayer-7.0.3/jwplayer.flash.swf <pageUrl>http://itivi.pl/program-telewizyjny/TVP_1_HD
# rtmp://app.itivi.pl/live/<playpath>TVP2HD <swfUrl>http://itivi.pl/js/jwplayer-7.0.3/jwplayer.flash.swf <pageUrl>http://itivi.pl/program-telewizyjny/TVP_2
# rtmp://app.itivi.pl/live/<playpath>NATGEOHD <swfUrl>http://itivi.pl/js/jwplayer-7.0.3/jwplayer.flash.swf <pageUrl>http://itivi.pl/program-telewizyjny/NATGEO_PL
# rtmp://app.itivi.pl/live/<playpath>SPORTHD <swfUrl>http://itivi.pl/js/jwplayer-7.0.3/jwplayer.flash.swf <pageUrl>http://itivi.pl/program-telewizyjny/CANAL_SPORT
# rtmp://app.itivi.pl/live/<playpath>AXNHD <swfUrl>http://itivi.pl/js/jwplayer-7.0.3/jwplayer.flash.swf <pageUrl>http://itivi.pl/program-telewizyjny/Axn_HD
# rtmp://app.itivi.pl/live/<playpath>DISCOVERYHD <swfUrl>http://itivi.pl/js/jwplayer-7.0.3/jwplayer.flash.swf <pageUrl>http://itivi.pl/program-telewizyjny/Discovery_Channel
BASEURL = 'http://itivi.pl/'

def fixForEPG(one):
    return one

def ReadJsonFile(jfilename):
    content = '[]'
    if os.path.exists(jfilename):    # local content
        with open(jfilename,'r') as f:
            content = f.read()
            if not content:
                content ='[]'
    data=json.loads(html_entity_decode(content))
    return data
    
def pPath(url):
    m=url.split('/')[-1]
    d={
    'TVP_1_HD':'TVP1HD',
    'TVP_2':'TVP2HD',
    'NATGEO_PL':'NATGEOHD',
    'CANAL_SPORT':'SPORTHD',
    'Axn_HD':'AXNHD',
    'Discovery_Channel':'DISCOVERYHD',}
    return d.get(m,'')
    
def getUrl(url,data=None,header={},cookies={}):
    if not header:
        header = {'User-Agent':UA}
    req = urllib2.Request(url,data,headers=header)
    try:
        response = urllib2.urlopen(req, timeout=10)
        header['Cookie']=response.info()['Set-Cookie']
        link = response.read()
        response.close()
    except:
        req = urllib2.Request(url,data,headers=header)
        response = urllib2.urlopen(req, timeout=10)
        link = response.read()
        response.close()
    return link


COOKIEFILE=r'D:\itiv.cookie'

 
# def _getUrl(url,data=None,cookies=None):
#     req = urllib2.Request(url,data)
#     req.add_header('User-Agent', UA)
#     if cookies:
#         req.add_header("Cookie", cookies)
#     try:
#         response = urllib2.urlopen(req,timeout=TIMEOUT)
#         link = response.read()
#         response.close()
#     except:
#         link=''
#     return link
# 
# def getUrl(url,data=None):
#     cookies=cookieString(COOKIEFILE)
#     content=_getUrl(url,data,cookies)
#     if not content:
#         cookies=cf_setCookies(url,COOKIEFILE)
#         content=_getUrl(url,data,cookies)
#     return content
# 
# def cookieString(COOKIEFILE):
#     sc=''
#     if os.path.isfile(COOKIEFILE):
#         cj = cookielib.LWPCookieJar()
#         cj.load(COOKIEFILE)
#         sc=' '.join(['%s=%s;'%(c.name, c.value) for c in cj])
#     return sc
# 
# def cf_setCookies(link,cfile):
#     cj = cookielib.LWPCookieJar()
#     cookie=''
#     opener = urllib2.build_opener(urllib2.HTTPCookieProcessor(cj),urllib2.HTTPHandler())
#     req = urllib2.Request(BASEURL,headers={'User-Agent':UA})
#     response = opener.open(req,timeout=5)
#     response.close()
#     dataPath=os.path.dirname(cfile)
#     if not os.path.exists(dataPath):
#         os.makedirs(dataPath)
#     if cj:
#         cookie=' '.join(['%s=%s;'%(c.name, c.value) for c in cj])
#         cj.save(cfile, ignore_discard = True) 
#     return cookie
    

# def getUrl(url, cj=None,post=None, headers=None,timeout=10):
#     if cj:
#         cookie_handler = urllib2.HTTPCookieProcessor(cj)
#         opener = urllib2.build_opener(cookie_handler, urllib2.HTTPBasicAuthHandler(), urllib2.HTTPHandler())
#     else:
#         opener = urllib2.build_opener(urllib2.HTTPBasicAuthHandler(), urllib2.HTTPHandler())
#     if not headers:
#         headers = {'User-Agent':UA}
#         req = urllib2.Request(url,headers=headers)
#     try:
#         response = opener.open(req,post,timeout=5)
#         link=response.read()
#         response.close()
#     except:
#         link=''
#         if cj:
#             cookie = ' '.join(['%s=%s;'%(c.name, c.value) for c in cj])
#             req = urllib2.Request(url)
#             req.add_header('User-Agent','Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/33.0.1750.154 Safari/537.36')
#             req.add_header('Cookie',cookie)
#             response = opener.open(req,post,timeout=timeout)
#             link=response.read()
#             response.close()
#     return link;   

def get_root(addheader=False):
    # cj = cookielib.LWPCookieJar()
    url='http://itivi.pl/'
    content = getUrl(url)
    # if not content:
    #     content = getUrl(url,cj=cj)
        #cookie = ' '.join(['%s=%s;'%(c.name, c.value) for c in cj])

    match=re.compile('<a href="(.*?)"><img alt="(.*?)" src="(.*?)" style').findall(content)
   
    out=[]
    if addheader and match:
        t='[COLOR yellow]Updated: %s (itivi)[/COLOR]' %time.strftime("%d/%m/%Y: %H:%M:%S")
        out.append({'title':t,'tvid':'','img':'','url':'http://itivi.pl/','group':'','urlepg':''})
    #m=match[0]
    for m in match:
        h = m[0]
        t = m[1].replace('Telewizja online - ','').replace('_',' ').strip()
        i = m[2]
        out.append(fixForEPG({'title':t,'tvid':t,'img':i,'url':h,'group':'','urlepg':''}))
    return out

# def get_root_old(addheader=False):
#     return m3u2list()

def m3u2list():
    url = 'https://drive.google.com/uc?export=download&id=0B0PmlVIxygktN2FXaXYwWnNzcGc'
    
    response = getUrl(url)
    out = []
    matches=re.compile('^#EXTINF:-?[0-9]*(.*?),(.*?)\n(.*?)$',re.I+re.M+re.U+re.S).findall(response)
    
    renTags={'tvg-id':'tvid',
             'audio-track':'audio-track',
             'group-title':'group',
             'tvg-logo':'img'}
                 
    for params, title, url in matches:
        one  = {"title": title, "url": url}
        match_params =re.compile(' (.+?)="(.*?)"',re.I+re.M+re.U+re.S).findall(params)
        for field, value in match_params:
            one[renTags.get(field.strip().lower(),'bad')] = value.strip()
        if not one.get('tvid'):
            one['tvid']=title
       
        one['urlepg']=''
        one['url']=one['url'].strip()
        one['title']=one['title'].strip()
        one = fixForEPG(one)
        out.append(one)
  
    return out
       
#url='http://itivi.pl/program-telewizyjny/Discovery_Channel'    
# def decode_url(url):
#     vido_urls=''
#     data = ReadJsonFile('itivi.json')
    
    
def decode_url_old(url):
    vido_urls=''
    swfUrl='http://itivi.pl/js/jwplayer-7.0.3/jwplayer.flash.swf'
    #rtmp://app.itivi.pl/live/<playpath>DISCOVERYHD <swfUrl>http://itivi.pl/js/jwplayer-7.0.3/jwplayer.flash.swf <pageUrl>http://itivi.pl/program-telewizyjny/Discovery_Channel
    if 'itivi.pl' in url: 
        playpath = pPath(url)
        if playpath:
            vido_urls = 'rtmp://app.itivi.pl/live/ playpath='+ playpath + ' swfUrl='+swfUrl + ' swfVfy=1 live=1 timeout=13 pageUrl='+url
        # content = getUrl(url)
        # swfUrl='http://itivi.pl/js/jwplayer-7.0.3/jwplayer.flash.swf'
        # link = re.compile('{file: \'(.*?)\'').findall(content)    #link=['rtmp://app.itivi.pl/live/ playpath=TVP1HD']
        # if link:
        #     vido_urls = link[0] + ' swfUrl='+swfUrl + ' swfVfy=1 live=1 timeout=13 pageUrl='+url
    return vido_urls

# url='http://itivi.pl/program-telewizyjny/TVP1_HD'
# url='http://itivi.pl/program-telewizyjny/Fenix'
#url='http://itivi.pl/program-telewizyjny/POLSAT_2HD'
def decode_url(url):
    vido_urls=''
    #cj=cookielib.LWPCookieJar()
    #rtmp://app.itivi.pl/live/<playpath>DISCOVERYHD <swfUrl>http://itivi.pl/js/jwplayer-7.0.3/jwplayer.flash.swf <pageUrl>http://itivi.pl/program-telewizyjny/Discovery_Channel
    if 'itivi.pl' in url: 
        content = getUrl(url)
        #swfUrl='http://itivi.pl/js/jwplayer-7.0.3/jwplayer.flash.swf'
        #link = re.compile('{file: \'(.*?)\'').findall(content)    #link=['rtmp://app.itivi.pl/live/ playpath=TVP1HD']
        link=re.compile('playM3U8byGrindPlayer\("(.*?)"\)').findall(content)
        if link:
            if link[0].startswith('http'):
                vido_urls = link[0]
            else:
                vido_urls = link[0].replace('flv:','') + ' swfUrl='+swfUrl + ' swfVfy=1 live=1 timeout=10 pageUrl='+url
    print '###itivi.pl',vido_urls
    return vido_urls 
    
def decode_all_urls(out,):
    out_hrefs=[]   
    out_d = {} 
    one=out[0]
    for one in out:
        #print one.get('title')
        print one.get('url','')
        m=one.get('url','').split('/')[-1]
        vido_url = decode_url(one.get('url',''))
        if vido_url:
            print'\t',vido_url
            one['url']=vido_url
            p =vido_url.split(' ')[0].split('/')[-1]
            out_d[m]=p
            out_hrefs.append(one) 
    
    return out_hrefs     
    
def build_m3u(out,fname=r'C:\Users\ramic\Google Drive\lptv\itivi.m3u'):    
    entry='#EXTINF:-1 tvg-id="{tvid}" tvg-logo="{img}" url-epg="{urlepg}" group-title="{group}",{title}\n{url}\n\n'
    OUTxmu='#EXTM3U\n'
    #OUTxmu=OUTxmu+'\n#EXTINF:-1, [COLOR yellow]Update: %s [/COLOR]\nhttp://www.youtube.com/\n\n' %(time.strftime("%d/%m/%Y: %H:%M:%S"))
    for one in out:
        one['title']=one['title'].strip()
        if not one.has_key('img'):
            one['img']=''
        if not one.has_key('group'):
            one['group']=''
        OUTxmu=OUTxmu+entry.format(**one)
    myfile = open(fname,'w')
    myfile.write(OUTxmu)
    myfile.close()

    
##
# out=get_root()    
# out2=decode_all_urls(out)

# for h in out_hrefs:
#     l= h.get('url').split(' ')[0]
#     if 'itivi' in l:
#         print l
#         
#         
# for o in out:
#     print o.get('img')
#     if o.get('url').startswith('http'):
#         o['url']=o.get('url').split(' ')[0]
# import json
# 
# with open(r'D:\itivi.json', 'w') as outfile:
#     json.dump(out, outfile, indent=2, sort_keys=True)
