# -*- coding: utf-8 -*-

import sys,re,os
import urllib,urllib2
import urlparse

import xbmc,xbmcgui,xbmcaddon
import xbmcplugin


base_url        = sys.argv[0]
addon_handle    = int(sys.argv[1])
args            = urlparse.parse_qs(sys.argv[2][1:])
my_addon        = xbmcaddon.Addon()
addonName       = my_addon.getAddonInfo('name')

PATH            = my_addon.getAddonInfo('path')
DATAPATH        = xbmc.translatePath(my_addon.getAddonInfo('profile')).decode('utf-8')
RESOURCES       = PATH+'/resources/'

sys.path.append( os.path.join( RESOURCES, "lib" ) )

FANART=PATH+'/fanart.jpg'

## COMMON Functions

def addLinkItem(name, url, mode, params=1, iconimage='DefaultFolder.png', infoLabels=False, IsPlayable=True,fanart=FANART,itemcount=1,contextmenu=None):
    u = build_url({'mode': mode, 'foldername': name, 'ex_link' : url, 'params':params})
    
    liz = xbmcgui.ListItem(name)
    
    art_keys=['thumb','poster','banner','fanart','clearart','clearlogo','landscape','icon']
    art = dict(zip(art_keys,[iconimage for x in art_keys]))
    art['landscape'] = fanart if fanart else art['landscape'] 
    art['fanart'] = fanart if fanart else art['landscape'] 
    liz.setArt(art)
    
    if not infoLabels:
        infoLabels={"title": name}
    liz.setInfo(type="video", infoLabels=infoLabels)
    if IsPlayable:
        liz.setProperty('IsPlayable', 'true')

    if contextmenu:
        contextMenuItems=contextmenu
        li.addContextMenuItems(contextMenuItems, replaceItems=True) 

    ok = xbmcplugin.addDirectoryItem(handle=addon_handle, url=u, listitem=liz,isFolder=False,totalItems=itemcount)
    xbmcplugin.addSortMethod(addon_handle, sortMethod=xbmcplugin.SORT_METHOD_NONE, label2Mask = "%R, %Y, %P")
    return ok

def addDir(name,ex_link=None, params=1, mode='folder',iconImage='DefaultFolder.png', infoLabels=None, fanart=FANART,contextmenu=None):
    url = build_url({'mode': mode, 'foldername': name, 'ex_link' : ex_link, 'params' : params})

    li = xbmcgui.ListItem(name)
    if infoLabels:
        li.setInfo(type="video", infoLabels=infoLabels)
    
    art_keys=['thumb','poster','banner','fanart','clearart','clearlogo','landscape','icon']
    art = dict(zip(art_keys,[iconImage for x in art_keys]))
    art['landscape'] = fanart if fanart else art['landscape'] 
    art['fanart'] = fanart if fanart else art['landscape'] 
    li.setArt(art)


    if contextmenu:
        contextMenuItems=contextmenu
        li.addContextMenuItems(contextMenuItems, replaceItems=True) 

    xbmcplugin.addDirectoryItem(handle=addon_handle, url=url,listitem=li, isFolder=True)
    xbmcplugin.addSortMethod(addon_handle, sortMethod=xbmcplugin.SORT_METHOD_NONE, label2Mask = "%R, %Y, %P")

def encoded_dict(in_dict):
    out_dict = {}
    for k, v in in_dict.iteritems():
        if isinstance(v, unicode):
            v = v.encode('utf8')
        elif isinstance(v, str):
            # Must be encoded in UTF-8
            v.decode('utf8')
        out_dict[k] = v
    return out_dict
    
def build_url(query):
    return base_url + '?' + urllib.urlencode(encoded_dict(query))



## ######################
## MAIN
## ######################
            
    
# Get passed arguments
mode = args.get('mode', None)
fname = args.get('foldername',[''])[0]
ex_link = args.get('ex_link',[''])[0]
params = args.get('params',[{}])[0]

M3USERVICES={'telewizjada':'telewizjadabid',
            'iklub':'iklub',
            'tele-wizja':'telewizja',
            'itivi':'itivi',
            'yoy.tv':'yoytv',
            'looknij.in':'looknijin',
            'wizja.tv':'wizjatv'}


if mode is None:
    addDir('LiveTV: Telewizjada',ex_link='',params={'_service':'telewizjadabid','_act':'ListChannels'}, mode='site',iconImage=RESOURCES+'telewizjadabid.png')
    addDir('LiveTV: TVP Stream',ex_link='http://tvpstream.tvp.pl/',params={'_service':'tvpstream','_act':'ListChannels'}, mode='site',iconImage=RESOURCES+'tvpstream.png')
    addDir('LiveTV: iklub',ex_link='',params={'_service':'iklub','_act':'ListChannels'}, mode='site',iconImage=RESOURCES+'iklub.png')
    addDir('LiveTV: tele-wizja',ex_link='',params={'_service':'telewizja','_act':'ListChannels'}, mode='site',iconImage=RESOURCES+'telewizja.png')
    addDir('LiveTV: itivi',ex_link='',params={'_service':'itivi','_act':'ListChannels'}, mode='site',iconImage=RESOURCES+'itivi.png')
    addDir('LiveTV: yoy.tv',ex_link='',params={'_service':'yoytv','_act':'ListChannels'}, mode='site',iconImage=RESOURCES+'yoytv.png')
    addDir('LiveTV: looknij.in',ex_link='',params={'_service':'looknijin','_act':'ListChannels'}, mode='site',iconImage=RESOURCES+'looknijin.png')
    addDir('LiveTV: wizja.tv',ex_link='',params={'_service':'wizjatv','_act':'ListChannels'}, mode='site',iconImage=RESOURCES+'wizjatv.png')
    addDir('LiveTV: psa-tv',ex_link='',params={'_service':'psatv','_act':'ListChannels'}, mode='site',iconImage=RESOURCES+'psatv.png')
    addDir('LiveTV: polon-tv',ex_link='',params={'_service':'polontv','_act':'ListChannels'}, mode='site',iconImage=RESOURCES+'polontv.png')
    addDir('LiveTV: tvp1-online',ex_link='',params={'_service':'tvp1onlineblogspot','_act':'ListChannels'}, mode='site',iconImage=RESOURCES+'tvp1onlineblogspot.png')
    addDir('LiveTV: sport365',ex_link='',params={'_service':'sport365','_act':'ListChannels'}, mode='site2',iconImage=RESOURCES+'sport365.png')
    addDir('LiveTV: sport.tvp',ex_link='http://sport.tvp.pl/na-antenie',params={'_service':'sporttvp','_act':'ListChannels'}, mode='site',iconImage=RESOURCES+'sporttvp.png')

    li = xbmcgui.ListItem(label = '[COLOR blue]aktywuj PVR Live TV[/COLOR]', iconImage=RESOURCES+'PVR.png')
    xbmcplugin.addDirectoryItem(handle=addon_handle, url=build_url({'mode': 'Opcje'}) ,listitem=li)

elif mode[0] == 'Opcje':
    path =  my_addon.getSetting('path')
    if not path: my_addon.setSetting('path',DATAPATH)
    my_addon.openSettings()  


elif mode[0] == 'UPDATE_IPTV':
    import pvr_m3u as pvr 
    fname = my_addon.getSetting('fname')
    path =  my_addon.getSetting('path')
    epgTimeShift = my_addon.getSetting('epgTimeShift')
    epgUrl = my_addon.getSetting('epgUrl')
    print 'UPDATE_IPTV',fname,path,epgTimeShift,epgUrl
    pvr.update_iptv(fname,path,epgTimeShift,epgUrl)

elif mode[0] == 'BUID_M3U':
    import pvr_m3u as pvr
    fname = my_addon.getSetting('fname')
    path =  my_addon.getSetting('path')
    service = my_addon.getSetting('service')
    error_msg=""
    if not fname:
        error_msg +="Podaj nazwę pliku "
    if not path:
        error_msg +="Podaj katalog docelowy "
    if not service:
         error_msg +="Wybierz jakieś źródła"
        
    if error_msg:
        xbmcgui.Dialog().notification('[COLOR red]ERROR[/COLOR]', error_msg, xbmcgui.NOTIFICATION_ERROR, 1000)
        pvr_path=  xbmc.translatePath(os.path.join('special://userdata/','addon_data','pvr.iptvsimple'))
        #print pvr_path
        if os.path.exists(os.path.join(pvr_path,'settings.xml')):
            print 'settings.xml exists'
    else:
        ret = pvr.build_m3u(fname,path,M3USERVICES.get(service))
    my_addon.openSettings() 

elif mode[0] =='site':
    params = eval(params)
    service = params.get('_service')
    act = params.get('_act')
    mod = __import__(service)
    if act == 'ListChannels':
        params.update({'_act':'play'})
        items = mod.getChannels(ex_link)
        for one in items:
            addLinkItem(one.get('title',''), one['url'], params=params, mode='site', IsPlayable=True,infoLabels=one, iconimage=one.get('img','%s.png'%(RESOURCES+service))) 
    elif act == 'play':
        streams = mod.getChannelVideo(ex_link)
        if isinstance(streams,list):
            print streams
            if len(streams)>1:
                label = [x.get('title') for x in streams]
                s = xbmcgui.Dialog().select('Źródła',label)
                stream_url = streams[s]
            elif streams:
                stream_url = streams[0]
            else: stream_url=''
        else:
            stream_url = streams
                  
        if stream_url:
            link = stream_url.get('url','')
            msg = stream_url.get('msg','')
            if link: xbmcplugin.setResolvedUrl(addon_handle, True,  xbmcgui.ListItem(path=link))
            else: 
                if msg: xbmcgui.Dialog().ok('Problem',msg)
                xbmcplugin.setResolvedUrl(addon_handle, False, xbmcgui.ListItem(path=''))
        else:
             xbmcplugin.setResolvedUrl(addon_handle, False, xbmcgui.ListItem(path=''))   

elif mode[0] =='site2':
    params = eval(params)
    service = params.get('_service')
    act = params.get('_act')
    mod = __import__(service)
    if act == 'ListChannels':
        params.update({'_act':'get_streams_play'})
        items = mod.getChannels(ex_link)
        img_service ='%s.png'%(RESOURCES+service)
        print img_service
        for one in items:
            addLinkItem(one.get('title',''), one['url'], params=params, mode='site2', IsPlayable=True,infoLabels=one, iconimage=one.get('img',img_service)) 
    if act == 'get_streams_play':
        streams = mod.getStreams(ex_link)
        if streams:
            t = [stream.get('title') for stream in streams]
            s = xbmcgui.Dialog().select("Źródła", t)
            if s>-1: stream_url = mod.getChannelVideo(streams[s])
            else: stream_url=''
            if stream_url: xbmcplugin.setResolvedUrl(addon_handle, True, xbmcgui.ListItem(path=stream_url))
            else: xbmcplugin.setResolvedUrl(addon_handle, False, xbmcgui.ListItem(path=stream_url))
        else:
            xbmcgui.Dialog().ok("Problem", 'Źródła nie są dostępne')  
        
        
elif mode[0] == 'folder':
    pass

else:
    xbmcplugin.setResolvedUrl(addon_handle, False, xbmcgui.ListItem(path=''))        


xbmcplugin.endOfDirectory(addon_handle)

