# -*- coding: utf-8 -*-

"""
    Toronto-Channels Add-on
    Author: Twilight0

        This program is free software: you can redistribute it and/or modify
        it under the terms of the GNU General Public License as published by
        the Free Software Foundation, either version 3 of the License, or
        (at your option) any later version.

        This program is distributed in the hope that it will be useful,
        but WITHOUT ANY WARRANTY; without even the implied warranty of
        MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
        GNU General Public License for more details.

        You should have received a copy of the GNU General Public License
        along with this program.  If not, see <http://www.gnu.org/licenses/>.
"""

import os, sys
import urlparse
import xbmc, xbmcaddon
import xbmcgui, xbmcplugin

# Addon variables:
join = os.path.join
addon = xbmcaddon.Addon()
Player = xbmc.Player().play
language = addon.getLocalizedString
addonname = addon.getAddonInfo("name")
addonid = addon.getAddonInfo("id")
addonpath = addon.getAddonInfo("path")
addonfanart = addon.getAddonInfo("fanart")
#addondesc = language(30000).encode("utf-8")
#datapath = xbmc.translatePath(addon.getAddonInfo("profile")).decode("utf-8")

# Misc variables:
addonicon = join(addonpath, 'icon.png')
addonart = join(addonpath, 'resources/media')
NETVToronto_img = join(addonart, 'NETV_Toronto.png')
Cannali_img = join(addonart, 'CANNALI_WEB_MUSIC.png')
Melodia_img = join(addonart, 'RADIO_MELODIA_TORONTO.png')
Settings_img = join(addonart, 'settings.png')

# Links:
NETVToronto_url = 'rtmp://live.netvtoronto.com/NetvToronto/NetvToronto'
Cannali_url = 'rtmp://live.streams.ovh/cannali/cannali'
Melodia_url = 'http://149.202.208.214:9086/live'

# Handlers:
_url_ = sys.argv[0]
_handle_ = int(sys.argv[1])
params = dict(urlparse.parse_qsl(sys.argv[2][1:]))
action = params.get('action', None)


def main_menu():

    if addon.getSetting('auto-view') == 'true':
        xbmc.executebuiltin('Container.SetViewMode(500)')
    elif addon.getSetting('auto-view') == 'false':
        pass

    # NETV Toronto
    if addon.getSetting('netv') == 'true':
        netv_url = '{0}?action=play&url={1}'.format(_url_, NETVToronto_url)
        netv_li = xbmcgui.ListItem(label='NETV Toronto', iconImage=NETVToronto_img)
        netv_li.setArt({'thumb': NETVToronto_img, 'fanart': addonfanart})
        netv_li.setInfo('video', {'title': 'NETV Toronto'})
        netv_li.setProperty('IsPlayable', 'true')
        xbmcplugin.addDirectoryItem(handle=_handle_, url=netv_url, listitem=netv_li, isFolder=False)
    elif addon.getSetting('netv') == 'false':
        pass

    # Cannali Music
    if addon.getSetting('cannali') == 'true':
        cannali_url = '{0}?action=play&url={1}'.format(_url_, Cannali_url)
        cannali_li = xbmcgui.ListItem(label='CANNALI Music', iconImage=Cannali_img)
        cannali_li.setArt({'thumb': Cannali_img, 'fanart': addonfanart})
        cannali_li.setInfo('video', {'title': 'CANNALI Music'})
        cannali_li.setProperty('IsPlayable', 'true')
        xbmcplugin.addDirectoryItem(handle=_handle_, url=cannali_url, listitem=cannali_li, isFolder=False)
    elif addon.getSetting('cannali') == 'false':
        pass

    # Radio Melodia Toronto
    if addon.getSetting('melodia') == 'true':
        melodia_url = '{0}?action=play&url={1}'.format(_url_, Melodia_url)
        melodia_li = xbmcgui.ListItem(label='Radio Melodia Toronto', iconImage=Melodia_img)
        melodia_li.setArt({'thumb': Melodia_img, 'fanart': addonfanart})
        melodia_li.setInfo('audio', {'title': 'Radio Melodia Toronto'})
        melodia_li.setProperty('IsPlayable', 'true')
        xbmcplugin.addDirectoryItem(handle=_handle_, url=melodia_url, listitem=melodia_li, isFolder=False)
    elif addon.getSetting('melodia') == 'false':
        pass

    # Settings
    settings_url = '{0}?action=settings'.format(_url_)
    settings_li = xbmcgui.ListItem(label=language(30001), iconImage=Settings_img)
    settings_li.setArt({'fanart': addonfanart})
    xbmcplugin.addDirectoryItem(handle=_handle_, url=settings_url, listitem=settings_li, isFolder=True)

    xbmcplugin.endOfDirectory(_handle_)


def play_item(url):
    _play_ = xbmcgui.ListItem(path=url)
    xbmcplugin.setResolvedUrl(_handle_, True, listitem=_play_)


if action is None:

    main_menu()

elif action == 'play':

    play_item(params['url'])

elif action == 'settings':

    addon.openSettings()
