# -*- coding: utf-8 -*-

import re, xbmc, urllib
import requests
from resources.lib import common
from resources.lib import jsunpack

timeout = common.get_timeout()

def get_file(hoster_list):
    file = None
    for link in hoster_list:
        if 'vidzi' in link and not file:
            file = vidzi(link)
        if 'vivo' in link and not file or 'shared' in link and not file:
            file = shared(link)
        if 'streamcloud' in link and not file:
            file = streamcloud(link)
        if 'grifthost' in link and not file:
            file = grifthost(link)
        if 'primeshare' in link and not file:
            file = primeshare(link)
        if 'vodlocker' in link and not file:
            file = vodlocker(link)
        if 'promptfile' in link and not file:
            file = promptfile(link)
        if 'flashx' in link and not file:
            file = flashx(link)
        if 'filenuke' in link and not file:
            file = filenuke(link)
        if 'openload' in link and not file:
            file = openload(link)
        if 'nanoids' in link and not file:
            file = nanoids(link)
        if 'stream.moe' in link and not file:
            file = streammoe(link)
        if 'ani-stream' in link and not file:
            file = anistream(link)
        if 'proxer' in link and not file:
            file = proxer(link)
        if 'cloudtime' in link and not file or 'nowvideo' in link and not file or 'novamov' in link and not file:
            file = player_api(link)
        if 'myvideo' in link and not file:
            file = myvideo(link)
        if 'clipfish' in link and not file:
            file = clipfish(link)
        if 'prosiebenmaxx' in link and not file:
            file = prosiebenmaxx(link)
        if 'youtube' in link and not file:
            file = youtube(link)
        if 'crunchyroll' in link and not file:
            file = crunchyroll(link)
        if 'viewster' in link and not file:
            file = viewster(link)
        if 'netzkino' in link and not file:
            file = netzkino(link)
        if 'animesu' in link and not file:
            file = animesu(link)
        if not file: 
            file = check_file_type(link)
    return file

def get_redirected_url(url):
    location = url
    try:
        headers = {'User-Agent': 'Mozilla/5.0 (Windows NT 6.3)'}
        r = requests.head(url, headers=headers, timeout=timeout)
        location = r.headers.get('Location')
    except Exception, e:
        print '[plugin.video.animeanime] resolver get_redirected_url error', e
    return location

def check_file_type(file,headers=None):
    if file:
        try:
            r = requests.head(file, headers=headers, timeout=timeout, allow_redirects=True)
            type = r.headers.get('content-type')
            if type == 'video/mp4' or type == 'video/x-flv' or type == 'application/octet-stream' or type == 'application/x-mpegurl':
                return file
        except Exception, e:
            print '[plugin.video.animeanime] resolver check_file_type error', e
    print '[plugin.video.animeanime] resolver check_file_type: no file found'

def animesu(url):
    return url

def streamcloud(url):
    try:
        s = requests.Session()
        content = s.get(url, timeout=timeout).text
        data = {}
        for i in re.finditer('<input.*?name="(.*?)".*?value="(.*?)"', content):
            data[i.group(1)] = i.group(2).replace('download1','download2')
        content = s.post(url, data=data, timeout=timeout).text
        file = re.findall('file: "(.*?)"', content)[0]
        file = check_file_type(file)
        if file: return file
    except Exception, e:
        print '[plugin.video.animeanime] resolver streamcloud error', e

def grifthost(url):
    try:
        id = re.findall('//.+?/(?:embed-|)([\w]+)', url)[0]
        url = 'http://grifthost.com/vidembed-%s' % id
        file = get_redirected_url(url)
        file = check_file_type(file)
        if file: return file
    except Exception, e:
        print '[plugin.video.animeanime] resolver grifthost error', e
        
#shared and vivo
def shared(url):
    try:
        s = requests.Session()
        content = s.get(url, timeout=timeout).text
        data = {}
        r = re.findall(r'type="hidden" name="(.+?)"\s* value="?(.+?)"', content)
        for name, value in r:
            data[name] = value
        content = s.post(url, data=data, timeout=timeout).text
        file = re.findall('data-url="(.*?)"', content)[0]
        file = check_file_type(file)
        if file: return file
    except Exception, e:
        print '[plugin.video.animeanime] resolver shared error', e

def vidzi(url):
    try:
        content = requests.get(url, timeout=timeout).text
        file = re.findall('file: "(.+?mp4)"', content)[0]
        file = check_file_type(file)
        if file: return file
    except Exception, e:
        print '[plugin.video.animeanime] resolver vidzi error', e
        
def vodlocker(url):
    try:
        if not 'embed' in url: url = url.replace('vodlocker.com/', 'vodlocker.com/embed-')+'.html'
        content = requests.get(url, timeout=timeout).text
        file = re.findall('file: "(.*?)"', content)[0]
        file = check_file_type(file)
        if file: return file
    except Exception, e:
        print '[plugin.video.animeanime] resolver vodlocker error', e

def promptfile(url):
    try:
        s = requests.Session()
        content = s.get(url, timeout=timeout).text
        data = {}
        r = re.findall(r'type="hidden" name="(.+?)"\s* value="?(.+?)"', content)
        for name, value in r:
            data[name] = value
        content = s.post(url, data=data, timeout=timeout).text
        url = re.findall("url: '(.*?)'", content)[0]
        r = s.head(url)
        file = r.headers.get('location')
        file = check_file_type(file)
        if file: return file
    except Exception, e:
        print '[plugin.video.animeanime] resolver promptfile error', e
        
def flashx(url):
    try:
        if not 'embed' in url: url = url.replace('flashx.tv/', 'flashx.tv/embed-')
        if not '.html' in url: url = '%s.html' % url
        headers = {'User-Agent': 'iPhone'}
        content = requests.get(url, headers=headers, timeout=timeout).text
        js = re.findall("<script type='text/javascript'>(.*?)</script>", content, re.DOTALL + re.IGNORECASE)[0]
        unpacked = jsunpack.unpack(js)
        file = re.findall('file\s*:\s*"([^"]+(?:video|mobile)[^"]+)', unpacked)[0]
        file = check_file_type(file)
        if file: return file
    except Exception, e:
        print '[plugin.video.animeanime] resolver flashx error', e

#cloudtime aka divxstage  nowvideo novamov
def player_api(url):
    if 'cloudtime' in url: host = 'www.cloudtime.to'
    if 'nowvideo' in url: host = 'www.nowvideo.ch'
    if 'novamov' in url: host = 'www.novamov.com'
    try:
        headers = {'User-Agent': 'Mozilla/5.0 (Windows NT 6.3)', 'Host': host}
        api_url = 'http://%s/api/player.api.php?key=%s&file=%s'
        content = requests.get(url, timeout=timeout).text
        _file = re.findall('file="(.+?)"', content)[0]
        try: 
            _key = re.findall('filekey="(.+?)"', content)[0]
        except: 
            match = re.findall('filekey=(.+?);', content)[0]
            _key = re.findall(match+'="(.+?)"', content)[0]
        content = requests.get(api_url % (host,_key,_file), headers=headers, timeout=timeout).text
        file = re.findall('url=(.+?)&', content)[0]
        file = check_file_type(file)
        if file: return file
    except Exception, e:
        print '[plugin.video.animeanime] resolver player_api error', e
        
def primeshare(url):
    try:
        s = requests.Session()
        hash = url.split('/')[-1]
        data = {'hash': hash}
        headers = {'Referer': url}
        content = s.get(url, timeout=timeout).text
        if re.search('>File not exist<', content): return
        xbmc.sleep(8000)
        content = s.post(url, data=data, headers=headers).text
        file = re.findall("clip.*?url: '(.+?)'", content, re.DOTALL)[0]
        #file = check_file_type(file)
        if file: return file
    except Exception, e:
        print '[plugin.video.animeanime] resolver primeshare error', e

def filenuke(url):
    try:
        agent = 'iPhone'
        headers = {'User-Agent': agent}
        data = {'method_free':'Free'}
        content = requests.post(url, headers=headers, data=data, timeout=timeout).text
        file = re.findall("var\s+lnk\d+\s*=\s*'(.*?)'", content, re.DOTALL)[0]
        file = check_file_type(file,headers)
        if file:
            file = file+'|User-Agent=%s' % agent
            return file
    except Exception, e:
        print '[plugin.video.animeanime] resolver filenuke error', e
        
def openload(url):
    try:
        file = None
        pattern = 'openload\.\w+/\w+/([0-9a-zA-Z-_]+)'
        r = re.search(pattern, url)
        id = r.group(1)
        try:
            embed = 'https://openload.co/embed/%s/' % id
            data = requests.get(embed, timeout=timeout).text
            file = decodeOpenLoad(data.encode('utf-8'))
        except:
            pass
        if not file:
            dlticket = 'https://api.openload.io/1/file/dlticket?file=%s' % id
            json_data = requests.get(dlticket).json()
            ticket = json_data['result']['ticket']
            wait_time = json_data['result']['wait_time']
            if wait_time < 10:
                xbmc.sleep(wait_time*1000)
            else:
                raise ValueError('[plugin.video.animeanime] resolver openload wait_time too high: '+str(wait_time))
                return
            dlfile = 'https://api.openload.co/1/file/dl?file=%s&ticket=%s' % (id,ticket)
            json_data = requests.get(dlfile).json()
            file = json_data['result']['url']
        content = requests.get(url, timeout=timeout).text
        subtitle = common.get_subtitle()
        subcontent = ''
        suburl = re.findall('<track kind="captions" src="(.*?)"', content, re.DOTALL)
        if suburl:
            suburl = suburl[0]
            if not 'http' in suburl:
                suburl = 'https://openload.io%s' % suburl
            subcontent = requests.get(suburl, timeout=timeout).text
        fh = open(subtitle, 'w')
        fh.write(subcontent.encode('latin-1'))
        fh.close()
        # file = re.findall('<source.*?src.*?(?:"|\')(http.*?)(?:"|\')', content, re.DOTALL)[0]
        # file = file.replace('\\','')
        # _file = get_redirected_url(file)
        # if _file: file = _file
        file = check_file_type(file)
        if file: return file
    except Exception, e:
        print '[plugin.video.animeanime] resolver openload error', e    

def nanoids(url):
    try:
        content = requests.get(url, timeout=timeout).text
        embed_url = re.findall('<iframe.*?src="(.*?)"', content, re.DOTALL)[0]
        content = requests.get(embed_url, timeout=timeout).text
        sources = re.findall('sources: \[(.*?)\]', content, re.DOTALL)
        if sources:
            sources = sources[0].split('},{')
            for source in sources:
                file = re.findall('file.*?(?:\'|")(.*?)(?:\'|")', source, re.DOTALL)[0]
                label = re.findall('label.*?(?:\'|")(.*?)(?:\'|")', source, re.DOTALL)[0]
                if label == 'HD' or label == 'hd':
                    break
        else:
            file = re.findall('file.*?(?:\'|")(.*?)(?:\'|")', content, re.DOTALL)[0]
        file = check_file_type(file)
        if file: return file
    except Exception, e:
        print '[plugin.video.animeanime] resolver nanoids error', e
        
def streammoe(url):
    try:
        content = requests.get(url, timeout=timeout).text
        file = re.findall('clip:.+?url:\s*"(.*?)"', content, re.DOTALL)[0]
        file = file.replace('\\','')
        file = check_file_type(file)
        if file: return file
    except Exception, e:
        print '[plugin.video.animeanime] resolver streammoe error', e
        
def anistream(url):
    try:
        content = requests.get(url, timeout=timeout).text
        file = re.findall("file: '(.+?)'", content)[0]
        headers = {'User-Agent':'stagefright'}
        file = check_file_type(file,headers)
        if file:
            file = '%s|User-Agent=iPad' % file
            return file
    except Exception, e:
        print '[plugin.video.animeanime] resolver anistream error', e

def proxer(url):
    try:
        content = requests.get(url, timeout=timeout).text
        js = re.findall("<script type='text/javascript'>(.*?)</script>", content, re.DOTALL + re.IGNORECASE)
        if js:
            unpacked = jsunpack.unpack(js[0])
            file = re.findall('file:"(.*?)"', unpacked)[0]
            file = file.replace(' ','%20')
        else:
            file = re.findall('<source type="video/mp4" src="(.*?)"', content)[0]
        file = check_file_type(file)
        if file: return file
    except Exception, e:
        print '[plugin.video.animeanime] resolver proxer error', e

def myvideo(url):
    try:
        file = None
        try: vid = re.findall(r'/(\d+)', url)[-1]
        except: vid = re.findall(r'\d+', url)[-1]
        # thx to bromix for headers and api url
        headers = {'Accept-Language': 'en_US',
                    'X-PAPI-AUTH': '39927b3f31d7c423ad6f862e63d8436d954aecd0',
                    'Host': 'papi.myvideo.de',
                    'Connection': 'Keep-Alive',
                    'User-Agent': 'Not set yet'}
        api_url = 'https://papi.myvideo.de/myvideo-app/v1/vas/video.json?clipid=%s&method=4' % vid
        json_data = requests.get(api_url, headers=headers, timeout=timeout).json()
        video_url = json_data['VideoURL']
        file_name = re.findall('(movie.+?/.+?/\d+)', video_url)
        if file_name:
            file = 'http://is.myvideo.de/%s.mp4_hd.mp4' % file_name[0]
            file = check_file_type(file)
        if not file: file = video_url
        return file
    except Exception, e:
        print '[plugin.video.animeanime] resolver myvideo error', e
    
def clipfish(url):
    try:
        vid = re.findall(r'/(\d+)/', url)
        if not vid: vid = re.findall(r'/(\d+)', url)
        api_url = 'http://www.clipfish.de/devapi/id/%s?format=json&apikey=hbbtv' % vid[0]
        json_data = requests.get(api_url, timeout=timeout).json()
        file = json_data['items'][0]['media_videourl']
        file = check_file_type(file)
        return file
    except Exception, e:
        print '[plugin.video.animeanime] resolver clipfish error', e
        
def prosiebenmaxx(url):
    try:
        file = None
        content = requests.get(url, timeout=timeout).content
        clip_id = re.findall('(?:"|\')clip_id(?:"|\')\s*:\s*(?:"|\')(\d+)(?:"|\')', content)[0]
        video = 'http://vas.sim-technik.de/video/video.json'
        params = {'clipid': clip_id, 'method': '6'}
        json_data = requests.get(video, timeout=timeout, params=params).json()
        video_url = json_data['VideoURL']
        q_s = ['tp12', 'tp11', 'tp10', 'tp09', 'tp08', 'tp07']
        c_q = re.findall('(tp\d+)', video_url)
        if c_q:
            for q in q_s:
                file = re.sub(c_q[0], q, video_url)
                file = check_file_type(file)
                if file: break
        if not file: file = check_file_type(video_url)
        return file
    except Exception, e:
        print '[plugin.video.animeanime] resolver pro7maxx error', e
        
def youtube(url):
    try:
        vid = re.findall(r'v=([^&]+)', url)[0]
        return 'plugin://plugin.video.youtube/play/?video_id=' + vid
    except Exception, e:
        print '[plugin.video.animeanime] resolver youtube error', e
        
def viewster(url):
    try:
        headers = {'User-Agent': 'Mozilla/5.0 (iPad; CPU OS 7_0_4 like Mac OS X)'}
        r = requests.post('http://www.viewster.com/api/token/', headers=headers, timeout=timeout)
        cookies = r.headers['set-cookie']
        token = re.findall('api_token=(.*?);', cookies)[0]
        token = urllib.unquote_plus(token)
        headers.update({'Auth-token': token})
        episode = re.findall('/(\d+-\d+-\d+)/', url)[0]
        json_data = requests.get('https://public-api.viewster.com/search/%s' % episode, headers=headers, timeout=timeout).json()
        id = json_data['Id']
        params = {'mediaType':'video/mp4', 'subtitle':'de'}
        json_data = requests.get('https://public-api.viewster.com/movies/%s/video' % id, headers=headers, params=params, timeout=timeout).json()
        file = json_data['Uri']
        file = check_file_type(file)
        return file
    except Exception, e:
        print '[plugin.video.animeanime] resolver viewster error', e
        
def netzkino(url):
    try:
        slug = url.split('/')[-1]
        url = 'http://api.netzkino.de.simplecache.net/capi-2.0a/movies/%s.json' % str(slug)
        json_data = requests.get(url).json()
        id = json_data['custom_fields']['Streaming'][0]
        file = 'http://netzkino_and-vh.akamaihd.net/i/%s.mp4/master.m3u8' % str(id)
        return file
    except Exception, e:
        print '[plugin.video.animeanime] resolver netzkino error', e
        
def crunchyroll(url):
    #try:
        if 'redirect' in url:
            media_id = re.findall('media-(\d+)', url)[0]
            url = 'http://www.crunchyroll.com/media-%s' % media_id
        else:
            url = url.split('?')[0]
            media_id = url[-6:]
        if common.get_installedversion() < 14:
            url = 'http://www.crunchyroll.com/android_rpc/?req=RpcApiAndroid_GetVideoWithAcl&media_id=%s' % media_id
            headers = {'Host':'www.crunchyroll.com',
                    'X-Device-Uniqueidentifier':'ffffffff-931d-1f73-ffff-ffffaf02fc5f',
                    'X-Device-Manufacturer':'HTC',
                    'X-Device-Model':'HTC Desire',
                    'X-Application-Name':'com.crunchyroll.crunchyroid',
                    'X-Device-Product':'htc_bravo',
                    'X-Device-Is-GoogleTV':'0'}
            content = requests.get(url, headers=headers).content
            file = re.findall('"video_url":"(.+?)"', content.replace('\\',''))[0]
            return file
        else:
            from resources.lib.decoder import CrunchyDecoder
            subtitle = common.get_subtitle()
            xml_url = 'http://www.crunchyroll.com/xml/'
            s = requests.Session()
            content = s.get(url).text
            player_revision = re.findall(r'flash\\/(.+)\\/StandardVideoPlayer.swf', content)
            if not player_revision:
                swf = re.findall(r'<link rel="video_src" href="(.*?)"', content)[0]
            else:
                swf = 'http://static.ak.crunchyroll.com/flash/' + player_revision[0] + '/StandardVideoPlayer.swf'
            headers = {'Referer':swf, 'Host':'www.crunchyroll.com', 'Content-type':'application/x-www-form-urlencoded', 'User-Agent':'Mozilla/5.0 (Windows NT 6.1; rv:30.0) Gecko/20100101 Firefox/30.0'}
            data = {'req': 'RpcApiVideoPlayer_GetStandardConfig', 'media_id': media_id,
                    'video_format': '106', 'video_quality': '61', 'auto_play': '1',
                    'show_pop_out_controls': '1', 'current_page': 'http://www.crunchyroll.com/'}
            content = s.post(xml_url, headers=headers, data=data).text
            host = re.findall('<host>(.+?)</host>', content)[0]
            token = re.findall('<token>(.+?)</token>', content)[0]
            file = re.findall('<file>(.+?)</file>', content)[0]
            subtitle_id = None
            formattedSubs = ''
            subtitles = re.findall("<subtitle id='(.+?)'.*?user='(.+?)'", content)
            for subtitle_id, user in subtitles:
                if user == 'cr_de': subtitle_id = subtitle_id
            rtmp_url = host.replace('&amp;','&') + " swfurl=" +swf + " swfvfy=1 token=" +token+ " playpath=" +file.replace('&amp;','&')+ " pageurl=" +url
            if subtitle_id:
                data = {'req': 'RpcApiSubtitle_GetXml', 'subtitle_script_id': subtitle_id}
                content = s.post(xml_url, headers=headers, data=data).text
                formattedSubs = CrunchyDecoder().return_subs(content)
            fh = open(subtitle, 'w')
            fh.write(formattedSubs.encode('UTF-8'))
            fh.close()
            return rtmp_url
    #except Exception, e:
    #    print '[plugin.video.animeanime] resolver crunchyroll error', e
        

def decodeOpenLoad(html):

    aastring = re.search(r"<video(?:.|\s)*?<script\s[^>]*?>((?:.|\s)*?)</script", html, re.DOTALL | re.IGNORECASE).group(1)
    
    aastring = aastring.replace("((ﾟｰﾟ) + (ﾟｰﾟ) + (ﾟΘﾟ))", "9")
    aastring = aastring.replace("((ﾟｰﾟ) + (ﾟｰﾟ))","8")
    aastring = aastring.replace("((ﾟｰﾟ) + (o^_^o))","7")
    aastring = aastring.replace("((o^_^o) +(o^_^o))","6")
    aastring = aastring.replace("((ﾟｰﾟ) + (ﾟΘﾟ))","5")
    aastring = aastring.replace("(ﾟｰﾟ)","4")
    aastring = aastring.replace("((o^_^o) - (ﾟΘﾟ))","2")
    aastring = aastring.replace("(o^_^o)","3")
    aastring = aastring.replace("(ﾟΘﾟ)","1")
    aastring = aastring.replace("(c^_^o)","0")
    aastring = aastring.replace("(ﾟДﾟ)[ﾟεﾟ]","\\")
    aastring = aastring.replace("(3 +3 +0)","6")
    aastring = aastring.replace("(3 - 1 +0)","2")
    aastring = aastring.replace("(1 -0)","1")
    aastring = aastring.replace("(4 -0)","4")

    decodestring = re.search(r"\\\+([^(]+)", aastring, re.DOTALL | re.IGNORECASE).group(1)
    decodestring = "\\+"+ decodestring
    decodestring = decodestring.replace("+","")
    decodestring = decodestring.replace(" ","")
    
    decodestring = decode(decodestring)
    decodestring = decodestring.replace("\\/","/")
    
    videourl = re.search(r'vr="([^"]+)', decodestring, re.DOTALL | re.IGNORECASE).group(1)
    return videourl

def decode(encoded):
    for octc in (c for c in re.findall(r'\\(\d{2,3})', encoded)):
        encoded = encoded.replace(r'\%s' % octc, chr(int(octc, 8)))
    return encoded.decode('utf8')