# -*- coding: utf-8 -*-

import xbmc,os,re
import json
import random
from resources.lib import simple_requests as requests
from resources.lib import json_handle
from resources.lib import common

site = 'amvnews'
base_url = 'http://amvnews.ru'
abc_url = base_url+'/index.php?go=Anime&letter=%s&lang=en'
amv_tv_url = base_url+'/index.php?go=Files&in=newfiles&per=4&lang=en'
amv_quality = common.get_amv_quality()
amv_url = base_url+'/index.php?go=Files&file=down&id=%s'
if amv_quality == 'Low': amv_url = amv_url+'&alt=4'
timeout = common.get_timeout()
cat_url = base_url+'/index.php?go=Files&in=cat&id=%s&st=%s&page=%s&lang=en'

sort_method = 1

amv_categories = (  
                    {'name':'Action', 'id': '1'}, {'name':'Character Profile', 'id': '3'},
                    {'name':'Comedy (Fun)', 'id': '4'}, {'name':'Cross-Over', 'id': '42'},
                    {'name':'Dance', 'id': '5'}, {'name':'Drama', 'id': '6'},
                    {'name':'Ecchi', 'id': '12'}, {'name':'GMV', 'id': '19'},
                    {'name':'Horror', 'id': '8'}, {'name':'Instrumental', 'id': '9'}, 
                    {'name':'MAD', 'id': '16'}, {'name':'MEP', 'id': '17'},
                    {'name':'Manga (MMV)', 'id': '34'}, {'name':'Original Animation', 'id': '11'},
                    {'name':'Psychedelic', 'id': '21'}, {'name':'Romance', 'id': '10'},
                    {'name':'Sentimental', 'id': '14'}, {'name':'Story', 'id': '13'},
                    {'name':'Trailer', 'id': '2'}, {'name':'Exam', 'id': '15'}
                    )

def get_playlist(playlist,id):
    amv_list = get_cat_amv_list(id)
    for amv in amv_list:
        playlist.add(amv)
    return playlist

def select_category():
    categories = []
    id = None
    for category in amv_categories:
        name = category['name']
        categories.append(name)
    dialog = common.get_dialog()
    ret = dialog.select('AMV Channels', categories)
    if ret >= 0:
        id = amv_categories[ret]['id']
    return id

def get_cat_amv_list(id):
    amv_list = []
    start_page = 0
    last_page = 5*15
    for page in range(start_page,last_page,15):
        content = get_content(cat_url % (id,sort_method,str(page)))
        file_ids = re.findall('<a class=newstitle href=.+?id=(\d+)>', content)
        for file_id in file_ids:
            if not file_id: break
            amv = amv_url % str(file_id)
            amv_list.append(amv)
    random.shuffle(amv_list)
    return amv_list

def get_amv(name):
    amv = ''
    try:
        anime_list = get_abc_series(name)
        match = common.find_anime(name, anime_list, clean_burning=True)
        if not match:
            import anisearch
            alt_list = anisearch.get_alt_list(name)
            for alt_name in alt_list:
                name = alt_name['alt_name']
                anime_list = get_abc_series(name)
                match = common.find_anime(name, anime_list, clean_burning=True)
                if match: break
        id = match[0]['id']
        content = get_content(base_url+id)
        amvs = re.findall('<tbody>(.*?)</tbody>', content, re.DOTALL)[0]
        amv = re.findall('<tr class="ratesrow.*?<a href="(.*?)"><span>(.*?)</span>', amvs, re.DOTALL)
        r = random.randint(0,len(amv))-1
        name = amv[r][1]
        amv = amv[r][0].replace("in=view","file=down")
        if amv_quality == 'Low': amv = amv+'&alt=4'
        amv = {'name': name, 'url': base_url+amv}
    except Exception, e:
        print '[plugin.video.animeanime] %s get_amv error' % site, e
    return amv

def get_abc_series(name):
    abc = name[0]
    if not abc.isalpha(): abc = '0..9'
    else: abc.upper()
    url = abc_url % abc
    anime_list = get_anime_list(url)
    return anime_list
    
def get_anime_list(url):
    anime_list = []
    content = get_content(url)
    anime_table = re.findall('<table class="anime_table"(.*?)</table>', content, re.DOTALL)[0]
    items = re.findall('<tr class="anime_tablerow(.*?)</tr>', anime_table, re.DOTALL)
    for item in items:
        name = re.findall('<a href=".*?">(.+?)</a>', item)[0]
        try: name = name.encode('utf-8')
        except: pass
        name = name.replace('(TV)','').replace('(Movie)','').replace('(OVA)','')
        url = re.findall('<a href="(.*?)">', item)[0]
        anime = ({'name': name, 'id': url})
        anime_list.append(anime)
    return anime_list
    
def get_content(url):
    content = ''
    try:
        headers = {'User-Agent': 'Mozilla/5.0 (Windows NT 5.1; rv:27.0) Gecko/20100101 Firefox/27.0'}
        content = requests.get(url, headers=headers, timeout=timeout).text
        content = content.decode('windows-1251').encode('utf-8', 'ignore')
        content = content.replace("&amp;","&").replace("&ndash;","-").replace("<BR>","").replace("</B>","</b>").replace(' title="Socks5 proxy 50"','')
    except Exception, e:
        print '[plugin.video.animeanime] %s get_content error' % site, e
    return content
