# -*- coding: utf-8 -*-

import xbmc,os,re,time
import json
from resources.lib import simple_requests as requests
from resources.lib import json_handle
from resources.lib import common

site = 'burning'
type = 'tv'
api_url = 'http://bs.to/api/'
genre_url = api_url+'series:genre/'
series_url = api_url+'series/'
cover_url = 'http://s.bs.to/img/cover/%s.jpg|encoding=gzip'
headers = {'User-Agent': 'Mozilla/5.0 (Linux; Android 4.1.1; Nexus 7 Build/JRO03D)'}
timeout = common.get_timeout()

def get_mirror(type,anime,episode,cache_time=False):
    mirror = []
    return mirror

def get_burning_seasons(name,cache_time=False):
    burning_seasons = []
    anime_list = get_complete_anime_list(cache_time)
    alt_list = common.get_ani_alt_list(name,cache_only=True)
    alt_list.insert(0, {'alt_name': name})
    for alt_name in alt_list:
        name = alt_name['alt_name']
        match = common.find_anime(name, anime_list, clean_burning=True)
        if match: break
    for series in match:
        b_id = series['id']
        b_name = series['name']
        cover = cover_url % b_id
        seasons = get_seasons(b_id)
        for i in range(int(seasons)):
            name = b_name+' Staffel: %s' % str(i+1)
            id = '%s/%s/' % (str(b_id), str(i+1))
            burning_seasons.append({'name': name, 'id':id, 'cover': cover})
    return burning_seasons
    
def get_abc_list(type,abc,cache_time=False):
    abc_list = []
    if abc == 'num': abc = ('.','0', '1', '2', '3', '4', '5', '6', '7', '8', '9')
    elif abc == 'all': abc = ''
    else: abc = abc.lower()
    if type == 'tv': anime_list = get_complete_anime_list(cache_time)
    else: anime_list = []
    if abc:
        for anime in anime_list:
            if anime['name'].lower().startswith(abc):
                abc_list.append(anime)
    else:
        abc_list = anime_list
    return abc_list

def get_new_series(cache_time=False):
    return []

def get_anime_info(type,id,cache_time=False):
    anime = []
    try:
        json_data = get_anime_json(id,cache_time)
        name = json_data['series']['series'].encode('UTF-8')
        id = json_data['series']['id']
        try: plot = json_data['series']['description']
        except: plot = ''
        cover = cover_url % id
        try: genres = json_data['series']['data']['genre']
        except: genres = []
        try: year = json_data['series']['start']
        except: year = ''
        anime = ({'site': site, 'type': type, 'name': name, 'id': id, 'plot': plot, 'cover': cover,
                    'genre': genres, 'episodes': '', 'episodes_aired': '', 'year': year})
    except Exception, e:
        print '[plugin.video.animeanime] %s get_anime_info error' % site, e
    return anime
    
def get_complete_anime_list(cache_time=False):
    cache_url = common.cleanfilename(genre_url)
    anime_list = json_handle.load_json(site, cache_url, cache_time)
    if anime_list:
        return anime_list
    else:
        anime_list = []
        genre = 'Anime'
        try:
            json_data = requests.get(genre_url, timeout=timeout, headers=headers).json()
            series = json_data[genre]['series']
            for serie in series:
                name = serie['name'].encode('UTF-8')
                id = serie['id']
                cover = cover_url % id
                anime_list.append({'site': site, 'type': type, 'name': name, 'id': id, 'plot': '', 'cover': cover,
                                    'genre': '', 'episodes': '', 'episodes_aired': '', 'year': ''})
            json_handle.save_json(site, cache_url, anime_list)
        except Exception, e:
            print '[plugin.video.animeanime] %s get_complete_anime_list error' % site, e
        return anime_list

def get_anime_list(bids):
    anime_list = []
    for id in bids:
        anime = get_anime_info(id)
        anime_list.append(anime)
    return anime_list
    
def get_anime_json(id,cache_time=False):
    json_data = None
    json_data = json_handle.load_json(site,id,cache_time)
    if json_data:
        return json_data
    else:
        try:
            url = series_url+str(id)+'/1/'
            json_data = requests.get(url, timeout=timeout, headers=headers).json()
            json_handle.save_json(site, id, json_data)
        except Exception, e:
            print '[plugin.video.animeanime] %s get_anime_json error' % site, e
        return json_data
    
def get_seasons(id):
    seasons = '0'
    try:
        json_data = get_anime_json(id)
        seasons = json_data['series']['seasons']
    except Exception, e:
        print '[plugin.video.animeanime] %s get_seasons error' % site, e
    return seasons

def get_episode_list(type,anime,cache_time=False):
    return []

def get_episodes(id,cache_time=False):
    cache_url = common.cleanfilename(id)
    episodes = json_handle.load_json(site, cache_url+'episodes', cache_time)
    if episodes:
        return episodes
    else:
        episodes = []
        try:
            url = series_url+id
            json_data = requests.get(url, timeout=timeout, headers=headers).json()
            epis = json_data['epi']
            for episode in epis:
                epi = episode['epi']
                titlede = episode['german']
                titleen = episode['english']
                if titlede:
                    name = 'Folge ' + epi + ': ' + titlede
                elif titleen:
                    name = 'Folge ' + epi + ': ' + titleen
                else:
                    name = 'Folge ' + epi
                name = name.encode('UTF-8')
                url = '%s%s/' % (id, str(epi))
                episodes.append({'name': name, 'url': url})
            if episodes: json_handle.save_json(site, cache_url+'episodes', episodes)
        except Exception, e:
            print '[plugin.video.animeanime] %s get_episodes error' % site, e
        return episodes
    
def get_final_hoster_list(id):
    links = []
    hoster_list = get_hoster(id)
    for hoster in hoster_list:
        id = hoster['id']
        link = get_stream_link(id)
        links.append(link)
    return links

def get_hoster(id):
    hoster = []
    try:
        url = series_url+id
        json_data = requests.get(url, timeout=timeout, headers=headers).json()
        hoster = json_data['links']
    except Exception, e:
        print '[plugin.video.animeanime] %s get_hoster error' % site, e
    return hoster
    
def get_stream_link(id):
    link = []
    try:
        watch_url = api_url+'watch/%s' % id
        json_data = requests.get(watch_url, headers=headers).json()
        link = json_data['fullurl']
    except Exception, e:
        print '[plugin.video.animeanime] %s get_stream_link error' % site, e
    return link