# -*- coding: utf-8 -*-

import xbmc,os,re,time
import json
from resources.lib import simple_requests as requests
from resources.lib import json_handle
from resources.lib import common

site = 'flow'
type = 'tv'
base_url = 'http://anime-flow.org'
tv_url = base_url+'/media/serie'
movie_url = base_url+'/media/movie'
ova_url = base_url+'/media/ovas'
timeout = common.get_timeout()
headers = {'User-Agent': 'Mozilla/5.0 (Windows NT 5.1; rv:27.0) Gecko/20100101 Firefox/27.0'}

def get_mirror(type,anime,episode,cache_time=False):
    mirror = []
    try:
        id = get_anime_id(type,anime,cache_time)
        if id:
            episodes = get_episodes(type,id,cache_time)
            for epi in episodes:
                if epi['episode'] == episode:
                    mirror = epi['url']
                    break
        if mirror:
            mirror_list = get_mirror_list(mirror)
            if mirror_list:
                return mirror_list
    except Exception, e:
        print '[plugin.video.animeanime] %s get_mirror error' % site, e
    return mirror

def get_mirror_list(mirror):
    mirror_list = []
    try:
        content = requests.get(mirror, headers=headers, timeout=timeout).text
        match = re.findall('<div class="vidbox">(.*?)</div>', content, re.DOTALL)[0]
        link = re.findall('="(http.*?)"', match, re.DOTALL)[0]
        link = re.sub(r'(?<=[a-z])[\r\n]+','', link)
        mirror_list.append(link)
    except Exception, e:
        print '[plugin.video.animeanime] %s get_mirror_list error' % site, e
    return mirror_list

def get_anime_list(type,url,cache_time=False):
    cache_url = common.cleanfilename(url)
    anime_list = json_handle.load_json(site, cache_url, cache_time)
    if anime_list:
        return anime_list
    else:
        anime_list = []
        try:
            content = requests.get(url, headers=headers, timeout=timeout).text
            match = re.findall('<table>(.*?)</table>', content, re.DOTALL)
            items = re.findall('<tr(.*?)</tr>', match[0], re.DOTALL)
            for item in items:
                url = re.findall("location = '(.*?)'", item, re.DOTALL)[0]
                url = base_url+url
                name = re.findall('img src.*?<td>(.*?)</td>', item, re.DOTALL)[0]
                try: 
                    cover = re.findall('img src="(.*?)"', item, re.DOTALL)[0]
                    cover = base_url+cover
                except: 
                    cover = ''
                try: genre = re.findall('<center>(.*?)</center>', item, re.DOTALL)[-1]
                except: genre = ''
                anime_list.append({'site': site, 'type': type, 'name': name, 'id': url, 'plot': '', 'cover': cover,
                                    'genre': [genre], 'episodes': '', 'episodes_aired': '', 'year': ''})
            if anime_list: json_handle.save_json(site, cache_url, anime_list)
        except Exception, e:
            print '[plugin.video.animeanime] %s get_anime_list error' % site, e
        return anime_list
    
def get_abc_list(type,abc,cache_time=False):
    abc_list = []
    if abc == 'num': abc = ('.','0', '1', '2', '3', '4', '5', '6', '7', '8', '9')
    elif abc == 'all': abc = ''
    else: abc = abc.lower()
    if type == 'tv': anime_list = get_anime_list(type, tv_url, cache_time)
    elif type == 'movie': anime_list = get_anime_list(type, movie_url, cache_time)
    elif type == 'ova': anime_list = get_anime_list(type, ova_url, cache_time)
    else: anime_list = []
    for anime in anime_list:
        if anime['name'].lower().startswith(abc):
            abc_list.append(anime)
    return abc_list

def get_episode_list(type,name,cache_time=False):
    episodes = []
    id = get_anime_id(type,name)
    if id:
        episodes = get_episodes(type,id,cache_time)
    return episodes
    
def get_new_series(cache_time=False):
    return []

def get_anime_info(type,id,cache_time=False):
    cache_url = common.cleanfilename(id)
    anime = json_handle.load_json(site, cache_url, cache_time)
    if anime:
        return anime
    else:
        anime = []
        try:
            content = requests.get(id, headers=headers, timeout=timeout).text
            match = re.findall('<a name="info">(.*?)<div class="box">', content, re.DOTALL)[0]
            name = re.findall('<div class="ptitle2">(.*?)</div>', match, re.DOTALL)[0]
            name = name.replace(' (Anime Serie)', '')
            cover = re.findall('<div class="cover"><img src="(.*?)"></div>', content, re.DOTALL)[0]
            cover = base_url+cover
            try: plot = re.findall('Kurzbeschreibung</div>(.*?)<', match, re.DOTALL)[0]
            except: plot = ''
            plot = re.sub(r'[\r\n]+','', plot)
            try: 
                genre = re.findall('Genre</div>(.*?)<br/>', match, re.DOTALL)[0]
                genre = re.sub(r'[\r\n]+','', genre)
                genre = genre.split(',')
            except: 
                genre = []
            anime = ({'site': site, 'type': type, 'name': name, 'id': id, 'plot': plot, 'cover': cover,
                        'genre': genre, 'episodes': '', 'episodes_aired': '', 'year': ''})
            if anime: json_handle.save_json(site, cache_url, anime)
        except Exception, e:
            print '[plugin.video.animeanime] %s get_anime_info error' % site, e
        return anime
    
def get_episodes(type,id,cache_time=False):
    cache_url = common.cleanfilename(id)
    episodes = json_handle.load_json(site, cache_url+'episodes', cache_time=cache_time)
    if episodes:
        return episodes
    else:
        episodes = []
        try:
            content = requests.get(id, headers=headers, timeout=timeout).text
            match = re.findall('<a href="(/watch/.*?/.*?/.*?)"', content, re.DOTALL)
            for url in match:
                episode = url.split('/')[-2]
                url = base_url+url
                title = 'Episode %s' % episode
                episodes.append({'name': title, 'url': url, 'episode': episode})
            if episodes: json_handle.save_json(site, cache_url+'episodes', episodes)
        except Exception, e:
            print '[plugin.video.animeanime] %s get_episodes error' % site, e
        return episodes
        
def get_anime_id(type,anime,cache_time=False):
    id = None
    try:
        alt_list = common.get_ani_alt_list(anime)
        alt_list.insert(0, {'alt_name': anime})
        for alt_name in alt_list:
            name = alt_name['alt_name']
            abc = name[0]
            if not abc.isalpha(): abc = 'num'
            anime_list = get_abc_list(type,abc,cache_time*4)
            match = common.find_anime(name, anime_list)
            if match: 
                break
        id = match[0]['id']
    except Exception, e:
        print '[plugin.video.animeanime] %s get_anime_id' % site, e
    return id