# -*- coding: utf-8 -*-

import xbmc,os,re,time
import json
from resources.lib import simple_requests as requests
from resources.lib import json_handle
from resources.lib import common

site = 'genx'
base_url = 'http://www.genx-anime.org/'
cover_url = base_url+'upload/cover/180px/%s.png'
all_url = 'index.php?do=display'
tv_url = 'index.php?do=display&type=tv'
movie_url = 'index.php?do=display&type=movie'
ova_url = 'index.php?do=display&type=OVA+%26+Specials'
search_url = base_url+'index.php?do=display&q='
ajax_url = base_url+'ajax/'
airing_url = ajax_url+'calendar_show.inc.php'
genre_url = 'index.php?do=display&genre=%s'
top100_url = 'index.php?do=toplist'
details_url = ajax_url+'calendar_details.inc.php'
type = 'tv'
headers = {'User-Agent': 'Mozilla/5.0 (Windows NT 5.1; rv:27.0) Gecko/20100101 Firefox/27.0', 'Host':'www.genx-anime.org'}
timeout = common.get_timeout()

def get_mirror(type,anime,episode,cache_time=False):
    mirror = []
    try:
        id = get_anime_id(type,anime,cache_time)
        if id:
            episodes = get_episodes(type,id,cache_time)
            for epi in episodes:
                if epi['episode'] == episode:
                    mirror = epi['url']
                    break
        if mirror:
            mirror_list = get_mirror_list(type,mirror,episode)
            if mirror_list:
                return mirror_list
    except Exception, e:
        print '[plugin.video.animeanime] %s get_mirror error' % site, e
    return mirror

def get_abc_list(type,abc,cache_time=False):
    if type == 'tv': url = tv_url
    elif type == 'movie': url = movie_url
    elif type == 'ova': url = ova_url
    url = url+'&char='+abc.lower()
    anime_list = get_anime_list_html(url,type,cache_time)
    return anime_list
    
def get_new_series(cache_time=False):
    url = 'index.php'
    type = 'new'
    anime_list = get_anime_list_html(url,type,cache_time)
    return anime_list

def get_genre_anime_list(genre):
    url = genre_url % genre
    anime_list = get_anime_list_html(url,type)
    return anime_list
    
def get_top100_anime_list():
    anime_list = get_anime_list_html(top100_url,type)
    return anime_list

def get_airing_anime_list():
    url = airing_url
    anime_list = json_handle.load_json(site, 'airing', cache_time=1)
    if anime_list:
        return anime_list
    else:
        anime_list = []
        data = {'offset': '0', 'limit': '100', 'status': '0'}
        try:
            content = requests.post(url, headers=headers, data=data, timeout=timeout).text
            serie = re.findall('data-aid="(.*?)" class="calendar_name">(.*?)</a>', content)
            for aid, name in serie:
                if not aid == '0':
                    cover = cover_url % str(aid)
                    anime_list.append({ 'site': site, 'type': type, 'name': name, 'id': aid, 'plot': '', 'cover': cover,
                                        'genre': '', 'episodes': '', 'episodes_aired': '', 'year': '' })
            if anime_list: json_handle.save_json(site, 'airing', anime_list)
        except Exception, e:
            print '[plugin.video.animeanime] %s get_airing_anime_list error' % site, e
        return anime_list
    return anime_list

def get_anime_list(aids):
    anime_list = []
    for aid in aids:
        anime = get_anime_info(type,aid)
        anime_list.append(anime)
    return anime_list
        
def get_search_aids(search_entered=False):
    if not search_entered:
        kb = xbmc.Keyboard('', 'Suche', False)
        kb.doModal()
        search_entered = kb.getText().replace(' ','+')
    final_url = search_url+search_entered
    aids = []
    try:
        content = requests.get(final_url, headers=headers, timeout=timeout).text
        re_aid = re.findall('upload/cover/.*?/(\d+).png', content)
        for aid in re_aid:
            if not aid == '0':
                aids.append({ 'aid': aid })
            if len(aids) > 19:
                break
    except Exception, e:
        print '[plugin.video.animeanime] %s get_search_aids error' % site, e
    return aids
    
def get_anime_list_html(url,type,cache_time=False):
    cache_url = common.cleanfilename(url)
    anime_list = json_handle.load_json(site, cache_url, cache_time=cache_time)
    if anime_list:
        return anime_list
    else:
        anime_list = []
        try:
            content = requests.get(base_url+url, headers=headers, timeout=timeout).text
            re_pages = re.findall('<dt style=.*?</dt>', content, re.DOTALL)[0]
            re_pages = re.findall('href="(.*?)"', re_pages)
        except:
            re_pages = [url]
        try:
            for url in re_pages:
                content = requests.get(base_url+url, headers=headers, timeout=timeout).text
                items = re.findall('<li class="item">.*?</li>', content, re.DOTALL)
                for item in items:
                    url = re.findall('href="(.+?)"', item)[0]
                    id = url.split('id=')[-1]
                    id = id.split()[0]
                    cover = cover_url % str(id)
                    name = re.findall('</span>">(.+?)</span>', item)[0]
                    try:
                        title = re.findall('title="(.*?)\|', item)[0]
                        if '(Movie)' in title: _type = 'movie'
                        elif '(OVA & Specials)' in title: _type = 'ova'
                        elif '(TV)' in title: _type = 'tv' 
                    except:
                        pass
                    try:
                        genres = re.findall('Genre</strong>: (.*?)<br/>', item)[0]
                        try: genre = genres.split(',')
                        except: genre = [genres]
                    except: genre = []
                    plot = re.findall('<br/><br/>(.*?)</span>', item, re.DOTALL)[0]
                    plot = plot.replace("&quot;","'")
                    year = re.findall('<dt class="ayear">.*?([0-9]{4}).*?</dt>', item, re.DOTALL)[0]
                    episodes = re.findall('<dt class="aepisode">.*?\/.*?(\d+).*?</dt>', item, re.DOTALL)[0]
                    episodes_aired = re.findall('<dt class="aepisode">.*?(\d+).*?\/', item, re.DOTALL)[0]
                    if not '(Hentai)' in item:
                        anime_list.append({ 'site': site, 'type': _type, 'name': name, 'id': id, 'plot': plot, 'cover': cover,
                                            'genre': genre, 'episodes': episodes, 'episodes_aired': episodes_aired, 'year': year })
                    if type == 'new' and len(anime_list) == 8:
                        break
            if anime_list: json_handle.save_json(site, cache_url, anime_list)
        except Exception, e:
            print '[plugin.video.animeanime] %s get_anime_list_html error' % site, e
        return anime_list

def get_episode_list(type,name,cache_time=False):
    episodes = []
    id = get_anime_id(type,name)
    if id:
        episodes = get_episodes(type,id,cache_time)
    return episodes

def get_episodes(type,aid,cache_time=False):
    folgen = get_folgen(type,aid,cache_time)
    episodes = []
    for episode in folgen:
        try: name = episodes[episode]['name'].encode('utf-8')
        except: name = ''
        name = 'Folge %s: %s' % (str(episode), name)
        episodes.append({'name': name, 'url': aid, 'episode': str(episode)})
    return episodes

def get_anime_id(type,anime,cache_time=False):
    id = None
    try:
        alt_list = common.get_ani_alt_list(anime)
        alt_list.insert(0, {'alt_name': anime})
        for alt_name in alt_list:
            name = alt_name['alt_name']
            abc = name[0]
            if not abc.isalpha(): abc = 'num'
            anime_list = get_abc_list(type,abc,cache_time)
            match = common.find_anime(name, anime_list)
            if match: break
        id = match[0]['id']
    except Exception, e:
        print '[plugin.video.animeanime] %s get_anime_id' % site, e
    return id

def get_folgen(type,aid,cache_time=False):
    json_data = get_anime_json(type,aid,cache_time)
    try: 
        folgen = json_data['folgen']
    except Exception, e:
        folgen = ''
        print '[plugin.video.animeanime] %s get_folgen error' % site, e
    return folgen

def get_mirror_list(type, aid, episode):
    hoster_list = get_hoster_list(type, aid, episode)
    links = []
    for hoster in hoster_list:
        try:
            link = hoster['link']
            dub = hoster['dub']
            sub = hoster['sub']
            if 'de' in dub or 'de' in sub:
                links.append(link)
        except Exception, e:
            print '[plugin.video.animeanime] %s get_final_hoster_list error' % site, e
    return links

def get_hoster_list(type, aid, episode):
    episodes = get_folgen(type, aid)
    try: 
        hoster_list = episodes[episode]['Stream']
    except Exception, e:
        hoster_list = ''
        print '[plugin.video.animeanime] %s get_hoster_list error' % site, e
    return hoster_list

def get_anime_info(type,aid,cache_time=False):
    anime = None
    empty = '{"length": 0}'
    json_data = get_anime_json(type,aid,cache_time)
    if json_data:
        try:
            name = json_data['original']
            id = json_data['id']
            try: plot = json_data['beschreibung']
            except: plot = ''
            cover = cover_url % str(id)
            try: genre = json_data['genre']
            except: genre = None
            if not genre: genre = ''
            try: episodes = json_data['folgenzahl']
            except: episodes = 0
            try: episodes_aired = json_data['length']
            except: episodes_aired = 0
            try: year = json_data['year']
            except: year = '1900'
            _type = json_data['typ']
            if 'OVA' in _type: type = 'ova'
            elif 'Movie' in _type: type = 'movie'
            anime = {'site': site, 'type': type, 'name': name, 'id': id, 'plot': plot, 'cover': cover,
                    'genre': genre, 'episodes': episodes, 'episodes_aired': episodes_aired, 'year': year}
        except Exception, e:
            print '[plugin.video.animeanime] %s get_anime_info error' % site, e
    return anime
    
def get_anime_json(type,aid,cache_time=False):
    try: aid = aid['aid']
    except: pass
    data = {'aid': str(aid)}
    json_data = None
    json_data = json_handle.load_json(site, aid, cache_time)
    if json_data:
        return json_data
    else:
        try: 
            json_data = requests.post(details_url, headers=headers, data=data, timeout=timeout).json()
            if json_data: json_handle.save_json(site, aid, json_data)
        except Exception, e:
            print '[plugin.video.animeanime] %s get_anime_json error' % site, e
        return json_data