# -*- coding: utf-8 -*-

import xbmc,os,re,time
import json
from resources.lib import simple_requests as requests
from resources.lib import json_handle
from resources.lib import common

site = 'randaris'
type = 'tv'
base_url = 'http://randaris-anime.net'
list_url = base_url+'/serie/german'
headers = {'User-Agent': 'Mozilla/5.0 (iPhone; CPU iPhone OS 5_0 like Mac OS X) AppleWebKit/534.46 (KHTML, like Gecko) Version/5.1 Mobile/9A334 Safari/7534.48.3'}
timeout = common.get_timeout()

def get_mirror(type,anime,episode,cache_time=False):
    mirror = []
    try:
        id = get_anime_id(type,anime,cache_time)
        if id:
            episodes = get_episodes(type,id,cache_time)
            for epi in episodes:
                if epi['episode'] == episode:
                    mirror = epi['url']
                    break
        if mirror:
            mirror_list = get_mirror_list(mirror)
            if mirror_list:
                return mirror_list
    except Exception, e:
        print '[plugin.video.animeanime] %s get_mirror error' % site, e
    return mirror
    
def get_mirror_list(mirror):
    mirror_list = []
    try:
        content = requests.get(mirror, headers=headers, timeout=timeout).text
        links = re.findall('<a id=.*?(.*?)</a>', content, re.DOTALL)
        for link in links:
            if 'nanoids' or 'openload' in link:
                url = re.findall('href="(.*?)"', link, re.DOTALL)[0]
                lang = re.findall("<span class='(.*?)'>", link)[0]
                if 'de' in lang:
                    hoster_url = get_hoster_url(url)
                    if hoster_url: mirror_list.append(hoster_url)
    except Exception, e:
        print '[plugin.video.animeanime] %s get_mirror_list error' % site, e
    return mirror_list

def get_hoster_url(url):
    hoster_url = None
    try:
        content = requests.get(url, headers=headers, timeout=timeout).text
        hoster_url = re.findall('<div class="video-player">.*?src="(.*?)"', content, re.DOTALL)[0]
    except Exception, e:
        print '[plugin.video.animeanime] %s get_hoster_url error' % site, e
    return hoster_url

def get_anime_list(type,cache_time=False):
    cache_url = common.cleanfilename(list_url+type)
    anime_list = json_handle.load_json(site, cache_url, cache_time)
    if anime_list:
        return anime_list
    else:
        anime_list = []
        try:
            content = requests.get(list_url, headers=headers, timeout=timeout).text
            items = re.findall('<tr class="imgTt clickable(.*?)</tr>', content, re.DOTALL)
            for item in items:
                cover = re.findall('src="(.*?)"', item, re.DOTALL)[0]
                cover = cover.replace('thumbs/','')
                url = re.findall('<a href="(.*?)"', item, re.DOTALL)[0]
                name = re.findall('<a href=".*?>(.*?)</a>', item, re.DOTALL)[0]
                match = re.findall('<td class="hidden-xs">(.*?)</td>', item, re.DOTALL)
                episodes = match[0]
                year = match[1]
                typ = match[2]
                if typ == 'TV Serie': typ = 'tv'
                elif typ == 'Film': typ = 'movie'
                elif typ == 'OVA': typ = 'ova'
                else: typ = 'tv'
                if typ == type:
                    anime_list.append({'site': site, 'type': type, 'name': name, 'id': url, 'plot': '', 'cover': cover,
                                        'genre': '', 'episodes': episodes, 'episodes_aired': '', 'year': year})
            if anime_list: json_handle.save_json(site, cache_url, anime_list)
        except Exception, e:
            print '[plugin.video.animeanime] %s get_anime_list' % site, e
        return anime_list
    
def get_abc_list(type,abc,cache_time=False):
    abc_list = []
    if abc == 'num': abc = ('.','0', '1', '2', '3', '4', '5', '6', '7', '8', '9')
    elif abc == 'all': abc = ''
    else: abc = abc.lower()
    anime_list = get_anime_list(type,cache_time)
    if abc:
        for anime in anime_list:
            if anime['name'].lower().startswith(abc):
                abc_list.append(anime)
    else:
        abc_list = anime_list
    return abc_list

def get_episode_list(type,name,cache_time=False):
    episodes = []
    id = get_anime_id(type,name,cache_time)
    if id:
        episodes = get_episodes(type,id,cache_time)
    return episodes
    
def get_new_series(cache_time=False):
    cache_url = common.cleanfilename(base_url)
    anime_list = json_handle.load_json(site, cache_url, cache_time)
    if anime_list:
        return anime_list
    else:
        new_list = []
        try:
            content = requests.get(base_url, headers=headers, timeout=timeout).text
            new = re.findall('table-anime-updates.*?Ongoing(.*?)</table>', content, re.DOTALL)[0]
            items = re.findall('<tr(.*?)</tr>', new, re.DOTALL)
            for item in items:
                url = re.findall('data-href="(.*?)"', item, re.DOTALL)[0]
                url = episode_to_anime(url)
                cover = re.findall('<div class="thumbnail">.*?data-src="(.+?)"', item, re.DOTALL)[0]
                cover = cover.replace('thumbs/','')
                name = re.findall('<div class="thumbnail">.*?alt="(.*?)"', item, re.DOTALL)[0]
                episode = re.findall('Episode: <b>(.*?)</b>', item, re.DOTALL)
                if episode: plot = name + ' Episode: ' + episode[0]
                lang = re.findall('<img class="flag" alt="(.*?)"', item, re.DOTALL)[0]
                if lang == 'ger' and url and episode:
                    new_list.append({'site': site, 'type': type, 'name': name, 'id': url, 'plot': plot, 'cover': cover,
                                    'genre': '', 'episodes': '', 'episodes_aired': '', 'year': ''})
                if len(new_list) == 8:
                    break
            if new_list: json_handle.save_json(site, cache_url, new_list)
        except Exception, e:
            print '[plugin.video.animeanime] %s get_new_series error' % site, e
        return new_list

def get_anime_info(type,id,cache_time=False):
    cache_url = common.cleanfilename(id)
    anime = json_handle.load_json(site, cache_url, cache_time)
    if anime:
        return anime
    else:
        anime = []
        try:
            content = requests.get(id, headers=headers, timeout=timeout).text
            name = re.findall('<span itemprop="name">(.+?)</span>', content)[0]
            plot = re.findall('<div itemprop="description">(.*?)</div>', content, re.DOTALL)[0]
            _genres = re.findall('itemprop="genre">(.*?)</div>', content, re.DOTALL)[0]
            genres = re.findall('title=.*?>(.*?)<', _genres)
            year = re.findall('>Jahr:.*?<div class=.*?>(.*?)<', content, re.DOTALL)[0]
            cover = re.findall('<meta itemprop="image" content="(.*?)"', content, re.DOTALL)[0]
            episodes = re.findall('itemprop="numberOfEpisodes">(.*?)<', content, re.DOTALL)
            anime = ({'site': site, 'type': type, 'name': name, 'id': id, 'plot': plot, 'cover': cover,
                      'genre': genres, 'episodes': episodes, 'episodes_aired': '', 'year': year})
            if anime: json_handle.save_json(site, cache_url, anime)
        except Exception, e:
            print '[plugin.video.animeanime] %s get_anime_info error' % site, e
        return anime

def get_episodes(type,id,cache_time=False):
    cache_url = common.cleanfilename(id)
    episodes = json_handle.load_json(site, cache_url+'episodes', cache_time)
    if episodes:
        return episodes
    else:
        episodes = []
        try:
            content = requests.get(id, headers=headers, timeout=timeout).text
            match = re.findall('ger\.png.*?<ul class="episode-list">(.*?)</ul>', content, re.DOTALL)[0]
            items = re.findall('<li temprop="episode"(.*?)</li>', match, re.DOTALL)
            for item in items:
                title = re.findall('title=.*?>(.*?)<', item, re.DOTALL)[0]
                url = re.findall('href="(.*?)"', item, re.DOTALL)[0]
                episode = re.findall('<span itemprop="episodeNumber">(.*?)</span>', item, re.DOTALL)
                if episode:
                    episode = episode[0]
                    title = title+episode
                else:
                    episode = '1'
                episodes.append({'name': title, 'url': url, 'episode': episode})
            if episodes: json_handle.save_json(site, cache_url+'episodes', episodes)
        except Exception, e:
            print '[plugin.video.animeanime] %s get_episodes error' % site, e
        return episodes

def get_anime_id(type,anime,cache_time=False):
    id = None
    try:
        alt_list = common.get_ani_alt_list(anime)
        alt_list.insert(0, {'alt_name': anime})
        for alt_name in alt_list:
            name = alt_name['alt_name']
            abc = name[0]
            if abc.isalpha(): abc = abc.upper()
            else: abc = 'num'
            anime_list = get_abc_list(type,abc,cache_time)
            match = common.find_anime(name, anime_list)
            if match: break
        id = match[0]['id']
    except Exception, e:
        print '[plugin.video.animeanime] %s get_anime_id' % site, e
    return id
    
def episode_to_anime(url):
    anime_url = None
    try:
        splitted = url.split('/')
        name = splitted[5].replace('-episode','')
        id = splitted[7]
        anime_url = '%s/serie/detail/%s/%s' % (base_url,id,name)
    except:
        pass
    return anime_url