# -*- coding: utf-8 -*-

import xbmc,os,re,time
import json
from resources.lib import simple_requests as requests
from resources.lib import json_handle
from resources.lib import common

site = 'tavernakoma'
type = 'tv'
base_url = 'http://www.taverna.tv'
cover_url = base_url+'/images/player/%s.jpg'
video_url = base_url+'/video.php?anime=%s'
list_url = base_url+'/anime.php'
timeout = common.get_timeout()

def get_mirror(type,anime,episode,cache_time=False):
    mirror = []
    try:
        id = get_anime_id(type,anime,cache_time)
        if id:
            episodes = get_episodes(type,id,cache_time)
            for epi in episodes:
                if epi['episode'] == episode:
                    mirror.append(epi['url'])
                    break
    except Exception, e:
        print '[plugin.video.animeanime] %s get_mirror' % site, e
    return mirror

def get_complete_anime_list(cache_time=False):
    cache_url = common.cleanfilename(list_url)
    anime_list = json_handle.load_json(site, cache_url, cache_time)
    if anime_list:
        return anime_list
    else:
        anime_list = []
        try:
            content = requests.get(list_url, timeout=timeout).text
            animetable = re.findall('<ul class="anime-table"(.*?)</td>', content, re.DOTALL)[0]
            liste = re.findall('<a href="(.*?)"><li>(.+?)</li></a>', animetable, re.DOTALL)
            for url, name in liste:
                c = url.split('series=')[-1]
                cover = cover_url % c
                anime_list.append({'site': site, 'type': type, 'name': name, 'id': url, 'plot': '', 'cover': cover,
                                    'genre': '', 'episodes': '', 'episodes_aired': '', 'year': ''})
            if anime_list: json_handle.save_json(site, cache_url, anime_list)
        except Exception, e:
            print '[plugin.video.animeanime] %s get_complete_anime_list' % site, e
        return anime_list
    
def get_anime_list(ids):
    anime_list = []
    for id in ids:
        anime = get_anime_info(id)
        anime_list.append(anime)
    return anime_list

def get_abc_list(type,abc,cache_time=False):
    abc_list = []
    if abc == 'num': abc = ('.','0', '1', '2', '3', '4', '5', '6', '7', '8', '9')
    elif abc == 'all': abc = ''
    else: abc = abc.lower()
    if type == 'tv': anime_list = get_complete_anime_list(cache_time)
    else: anime_list = []
    if abc:
        for anime in anime_list:
            if anime['name'].lower().startswith(abc):
                abc_list.append(anime)
    else:
        abc_list = anime_list
    return abc_list

def get_episode_list(type,name,cache_time=False):
    episodes = []
    id = get_anime_id(type,name)
    if id:
        episodes = get_episodes(type,id,cache_time)
    return episodes

def get_new_series(cache_time=False):
    return []

def get_anime_info(type,id,cache_time=False):
    cache_url = common.cleanfilename(id)
    anime = json_handle.load_json(site, cache_url, cache_time)
    if anime:
        return anime
    else:
        anime = []
        try:
            content = requests.get(base_url+id, timeout=timeout).text
            c = id.split('series=')[-1]
            name = re.findall('<div class="pageTitle">(.*?)</div>', content, re.DOTALL)[0]
            name = re.sub('\s+',' ', name)
            cover = cover_url % c
            try: plot = re.findall('<div class="article_content">(.*?)</div>', content, re.DOTALL)[0]
            except: plot = ''
            plot = plot.strip(' \n\t')
            try:
                genres = []
                genrelist = re.findall('<ul id="genrelist">(.*?)</ul>', content, re.DOTALL)[0]
                match = re.findall('<li>(.*?)</li>', genrelist, re.DOTALL)
                for genre in match:
                    genres.append(genre)
            except: genres = []
            anime = ({'site': site, 'type': type, 'name': name, 'id': id, 'plot': plot, 'cover': cover,
                      'genre': genres, 'episodes': '', 'episodes_aired': '', 'year': ''})
            if anime: json_handle.save_json(site, cache_url, anime)
        except Exception, e:
            print '[plugin.video.animeanime] %s get_anime_info' % site, e
        return anime

def get_episodes(type,id,cache_time=False):
    cache_url = common.cleanfilename(id)
    episodes = json_handle.load_json(site, cache_url+'episodes', cache_time)
    if episodes:
        return episodes
    else:
        episodes = []
        try:
            active = id.split('series=')[-1]
            url = video_url % active
            content = requests.get(url, timeout=timeout).text
            items = re.findall('<item>(.*?)</item>', content, re.DOTALL)
            for item in items:
                title = re.findall('<title>(.*?)</title>', item, re.DOTALL)[0]
                title = title.strip(' \r\n')
                episode = re.findall(r'\d+', title, re.DOTALL)[0]
                while episode.startswith('0'):
                    episode = episode[1:]
                link = re.findall('file="(.*?)"', item)[0]
                episodes.append({'name': title, 'url': link, 'episode': str(episode)})
            if episodes: json_handle.save_json(site, cache_url+'episodes', episodes)
        except Exception, e:
            print '[plugin.video.animeanime] %s get_episodes' % site, e
        return episodes

def get_anime_id(type,anime,cache_time=False):
    id = None
    try:
        alt_list = common.get_ani_alt_list(anime)
        alt_list.insert(0, {'alt_name': anime})
        for alt_name in alt_list:
            name = alt_name['alt_name']
            abc = name[0]
            if abc.isalpha(): abc = abc.upper()
            else: abc = 'num'
            anime_list = get_abc_list(type,abc,cache_time)
            match = common.find_anime(name, anime_list)
            if match: break
        id = match[0]['id']
    except Exception, e:
        print '[plugin.video.animeanime] %s get_anime_id' % site, e
    return id