# -*- coding: utf-8 -*-

import xbmc,os,re,time
import json
from resources.lib import simple_requests as requests
from resources.lib import json_handle
from resources.lib import common

site = 'tube'
type = 'tv'
base_url = 'http://www.anime-tube.tv'
tv_url = base_url+'/animeliste-1'
movie_url = base_url+'/animeliste-2'
ova_url = base_url+'animeliste-3'
specials_url = base_url+'/animeliste-4'
timeout = common.get_timeout()

def get_mirror(type,anime,episode,cache_time=False):
    mirror = []
    try:
        id = get_anime_id(type,anime,episode,cache_time)
        if id:
            episodes = get_episodes(type,id,cache_time)
            if len(episodes) == 1:
                episodes[0]['episode'] = '1'
            for epi in episodes:
                if epi['episode'] == episode:
                    mirror.append(epi['url'])
                    break
        if mirror:
            mirror_list = get_mirror_list(mirror[0])
            if mirror_list:
                return mirror_list
    except Exception, e:
        print '[plugin.video.animeanime] %s get_mirror error' % site, e
    return mirror

def get_mirror_list(u):
    mirror_list = []
    try:
        headers = {'User-Agent': 'iPhone'}
        content = requests.get(u, headers=headers, timeout=timeout).text
        match = re.findall('ani-stream.*?<iframe.*?src\s*=\s*(?:\'|")(.*?)(?:\'|")', content, re.DOTALL + re.IGNORECASE)
        if match:
            url = match[0]
            if not url.startswith('http'):
                if url.startswith('//'):
                    url = 'http:%s' % url
                else:
                    url = 'http://%s' % url
            if 'skystream' in url:
                headers.update({'Referer':u, 'Host':'player.skystream.tv'})
                content = requests.get(url, headers=headers).text.replace('\\','')
                match = re.findall('"redirect_url":"(.*?)"', content)
                if match:
                    url = match[0]
        else:
            url = re.findall('(http://.*?ani-stream.com/.*?.html)', content)[0]
        mirror_list.append(url)
    except Exception, e:
        print '[plugin.video.animeanime] %s get_mirror_list error' % site, e
    return mirror_list

def get_anime_list(type,url,cache_time=False):
    cache_url = common.cleanfilename(url)
    anime_list = json_handle.load_json(site, cache_url, cache_time)
    if anime_list:
        return anime_list
    else:
        anime_list = []
        abc_url = url
        try:
            content = requests.get(url, timeout=timeout).text
            re_pages = re.findall('/><div><center>.*?</center></div><br></div></div>', content)[0]
            re_pages = re.findall('<a href=".*?">(.*?)</a>', re_pages)[-1]
        except:
            re_pages = 1
        try:
            for i in range(0, int(re_pages)):
                url = abc_url.replace('.html','-'+str(i+1)+'.html')
                content = requests.get(url, timeout=timeout).text
                items = re.findall('<div class="group">(.*?<div class="title">.*?<div class="meta_r".*?</div>)', content, re.DOTALL)
                for item in items:
                    url = re.findall('<a href=".(/anime.*?html)"', item)[0]
                    name = re.findall('title="(.+?)"', item)[0]
                    cover = re.findall('src="(.*?)"', item)[0]
                    try: cover = cover.replace(' ','%20')
                    except: pass
                    try:
                        plot = re.findall('<div class="meta_r".*?>(.+)</div>', item, re.DOTALL)[0]
                        plot = plot.decode('utf-8')
                        plot = plot.replace('&hellip;', '...')
                    except:
                        plot = ''
                    try: year = re.findall('Jahr</b>: ([0-9]{4})', item)[0]
                    except: year = ''
                    anime_list.append({'site': site, 'type': type, 'name': name, 'id': url, 'plot': plot, 'cover': cover,
                                        'genre': '', 'episodes': '', 'episodes_aired': '', 'year': year})
            if anime_list: json_handle.save_json(site, cache_url, anime_list)
        except Exception, e:
            print '[plugin.video.animeanime] %s get_anime_list error' % site, e
        return anime_list
    
def get_abc_list(type,abc,cache_time=False):
    abc_list = []
    if abc == 'num': abc = '1'
    elif abc == 'all': pass
    else: abc = abc.upper()
    if type == 'tv': url = tv_url+'-'+abc+'.html'
    elif type == 'movie': url = movie_url+'-'+abc+'.html'
    elif type == 'ova': url = ova_url+'-'+abc+'.html'
    abc_list = get_anime_list(type,url,cache_time)
    return abc_list

def get_episode_list(type,name,cache_time=False):
    episodes = []
    id = get_anime_id(type,name)
    if id:
        episodes = get_episodes(type,id,cache_time)
    return episodes
    
def get_new_series(cache_time=False):
    cache_url = common.cleanfilename(base_url)
    anime_list = json_handle.load_json(site, cache_url, cache_time)
    if anime_list:
        return anime_list
    else:
        new_list = []
        try:
            content = requests.get(base_url, timeout=timeout).text
            new = re.findall('Die letzten Anime Uploads(.*?)</ul>', content, re.DOTALL)[0]
            items = re.findall('<li style(.*?)</li>', new, re.DOTALL)
            for item in items:
                cover = re.findall('<div style="background-image: url\(.(.+?)\)', item, re.DOTALL)[0]
                cover = base_url+cover
                id = cover.split('=')[-1]
                url = '/anime-%s.html' % id
                name = re.findall('<div style="text-decoration.*?>(.+?): Folge', item, re.DOTALL)
                if name:
                    new_list.insert(0, {'site': site, 'type': type, 'name': name[0], 'id': url, 'plot': '', 'cover': cover,
                                        'genre': '', 'episodes': '', 'episodes_aired': '', 'year': ''})
                if len(new_list) == 8:
                    break
            if new_list: json_handle.save_json(site, cache_url, new_list)
        except Exception, e:
            print '[plugin.video.animeanime] %s get_new_series error' % site, e
        return new_list

def get_anime_info(type,id,cache_time=False):
    cache_url = common.cleanfilename(id)
    anime = json_handle.load_json(site, cache_url, cache_time)
    if anime:
        return anime
    else:
        anime = []
        try:
            content = requests.get(base_url+id, timeout=timeout).text
            name = re.findall('<li><b>Titel</b>: (.+?)</li>', content)[0]
            plot = re.findall('<li><b>Beschreibung</b>: (.*?)</li>', content, re.DOTALL)[0]
            genres = re.findall('<li><b>Genre</b>: (.*?)</li>', content)[0]
            try: genre = genres.split(',')
            except: genre = [genres]
            year = re.findall('<li><b>Jahr</b>: (.*?)</li>', content)[0]
            cover = re.findall('<div class="thumbnail".*?<img src="(.*?)"', content, re.DOTALL)[0]
            anime = ({'site': site, 'type': type, 'name': name, 'id': id, 'plot': plot, 'cover': cover,
                      'genre': genre, 'episodes': '', 'episodes_aired': '', 'year': year})
            if anime: json_handle.save_json(site, cache_url, anime)
        except Exception, e:
            print '[plugin.video.animeanime] %s get_anime_info error' % site, e
        return anime

def get_episodes(type,id,cache_time=False):
    cache_url = common.cleanfilename(id)
    episodes = json_handle.load_json(site, cache_url+'episodes', cache_time)
    if episodes:
        return episodes
    else:
        episodes = []
        try:
            content = requests.get(base_url+id, timeout=timeout).text
            re_pages = re.findall("(/anime-.*?-.*?.html)'>", content)
            for page in re_pages:
                url = base_url+page
                content = requests.get(url, timeout=timeout).text
                items = re.findall('<div class="element">(.*?)<div class="meta_r">', content, re.DOTALL)
                for item in items:
                    url = re.findall('href=".(.*?)"', item)[0]
                    title = re.findall('title="(.*?)"', item)[0]
                    episode = re.findall(r'\d+', title)[0]
                    episodes.append({'name': title, 'url': base_url+url, 'episode': episode})
            if episodes: json_handle.save_json(site, cache_url+'episodes', episodes)
        except Exception, e:
            print '[plugin.video.animeanime] %s get_episodes error' % site, e
        return episodes

def get_anime_id(type,anime,episode=0,cache_time=False):
    id = None
    try:
        alt_list = common.get_ani_alt_list(anime)
        alt_list.insert(0, {'alt_name': anime})
        for alt_name in alt_list:
            name = alt_name['alt_name']
            abc = name[0]
            if not abc.isalpha(): abc = 'num'
            anime_list = get_abc_list(type,abc,cache_time)
            match = common.find_anime(name, anime_list)
            if match:
                if 'One Piece' in anime and episode > 401: 
                    try: match = match[1]
                    except: match = match[0]
                else: 
                    match = match[0]
                break
        id = match['id']
    except Exception, e:
        print '[plugin.video.animeanime] %s get_anime_id' % site, e
    return id