# -*- coding: utf-8 -*-

import xbmc,os,re,time
import json
from resources.lib import simple_requests as requests
from resources.lib import json_handle
from resources.lib import common

site = 'world24'
type = 'tv'
base_url = 'http://anime-world24.net/'
list_url = base_url+'animeliste'
timeout = common.get_timeout()

def get_mirror(type,anime,episode,cache_time=False):
    mirror = []
    try:
        id = get_anime_id(type,anime,cache_time)
        if id:
            episodes = get_episodes(type,id,cache_time)
            for epi in episodes:
                if epi['episode'] == episode:
                    mirror.append(epi['url'])
                    break
    except Exception, e:
        print '[plugin.video.animeanime] %s get_mirror error' % site, e
    return mirror
    
def get_anime_list(url,cache_time=False):
    cache_url = common.cleanfilename(url)
    anime_list = json_handle.load_json(site, cache_url, cache_time)
    if anime_list:
        return anime_list
    else:
        anime_list = []
        try:
            content = requests.get(url, timeout=timeout).text
            tbody = re.findall('<tbody>(.*?)</tbody>', content, re.DOTALL)[0]
            liste = re.findall('<tr>(.*?)</tr>', tbody, re.DOTALL)
            for anime in liste:
                url = re.findall('href="(.*?)"', anime, re.DOTALL)[0]
                name = re.findall('alt="(.+?)"', anime, re.DOTALL)[0]
                try:
                    cover = re.findall('src="(.+?)&', anime, re.DOTALL)[0]
                    if not cover.startswith('http'):
                        cover = base_url+cover
                    cover = cover+'&sizex=250&sizey=250&mode=1&type=image'
                except:
                    cover = ''
                try: genre = re.findall('<div class="genres">.*?default">(.+?)<', anime, re.DOTALL)
                except: genre = ''
                match = re.findall('<td class="text-center">(\d+)</td>', anime, re.DOTALL)
                try: episodes = match[0]
                except: episodes = ''
                try: year = match[1]
                except: year = ''
                anime_list.append({'site': site, 'type': type, 'name': name, 'id': url, 'plot': '', 'cover': cover,
                                    'genre': genre, 'episodes': episodes, 'episodes_aired': '', 'year': year})
            if anime_list: json_handle.save_json(site, cache_url, anime_list)
        except Exception, e:
            print '[plugin.video.animeanime] %s get_complete_anime_list error' % site, e
        return anime_list

def get_abc_list(type,abc,cache_time=False):
    abc_list = []
    if abc == 'num': abc = '0-9'
    elif abc == 'all': abc = ''
    else: abc = abc.upper()
    if type == 'tv':
        url = '%s/letter/%s' % (list_url,abc)
        abc_list = get_anime_list(url,cache_time)
    else: 
        abc_list = []
    return abc_list

def get_episode_list(type,name,cache_time=False):
    episodes = []
    id = get_anime_id(type,name)
    if id:
        episodes = get_episodes(type,id,cache_time)
    return episodes

def get_new_series(cache_time=False):
    return []

def get_anime_info(type,id,cache_time=False):
    cache_url = common.cleanfilename(id)
    anime = json_handle.load_json(site, cache_url, cache_time)
    if anime:
        return anime
    else:
        anime = []
        try:
            content = requests.get(id, timeout=timeout).text
            name = re.findall('<h1 class=".*?">.*?-\s*(.+?)</h1>', content, re.DOTALL)[0]
            cover = re.findall('<div class="anime-view".*?src="(.*?)"', content, re.DOTALL)[0]
            if not cover.startswith('http'): cover = '%s%s' % (base_url,cover)
            try: plot = re.findall('<div class="description">(.*?)</div>', content, re.DOTALL)[0]
            except: plot = ''
            try: genres = re.findall('<span class="label label-default">(.*?)</span>', content, re.DOTALL)
            except : genres = []
            try: episodes = re.findall('Episoden</td>.*?<td class.*?>(\d+)<', content, re.DOTALL)[0]
            except: episodes = ''
            try: 
                year = re.findall('Jahr</td>.*?<td class.*?>(.*?)<', content, re.DOTALL)[0]
                year = year.split('.')[-1]
            except: year = ''
            anime = ({'site': site, 'type': type, 'name': name, 'id': id, 'plot': plot, 'cover': cover,
                        'genre': genres, 'episodes': episodes, 'episodes_aired': '', 'year': year})
            if anime: json_handle.save_json(site, cache_url, anime)
        except Exception, e:
            print '[plugin.video.animeanime] %s get_anime_info error' % site, e
        return anime

def get_episodes(type,id,cache_time=False):
    cache_url = common.cleanfilename(id)
    episodes = json_handle.load_json(site, cache_url+'episodes', cache_time)
    if episodes:
        return episodes
    else:
        episodes = []
        try:
            content = requests.get(id, timeout=timeout).text
            url = re.findall('<table\s*class="table"\s*id="anime-list">.*?<tbody>.*?href="(.*?)"', content, re.DOTALL)[0]
            content = requests.get(base_url+url, timeout=timeout).text
            item = re.findall('file: "(.+?)".*?title: "(.+?)".*?description: "(.+?)"', content, re.DOTALL)
            for file, title, description in item:
                name = title+' - '+description
                episode = re.findall(r'\d+', title)[0]
                while episode.startswith('0'):
                    episode = episode[1:]
                episodes.append({'name': name, 'url': file, 'episode': episode})
            if episodes: json_handle.save_json(site, cache_url+'episodes', episodes)
        except Exception, e:
            print '[plugin.video.animeanime] %s get_episodes error' % site, e
        return episodes

def get_anime_id(type,anime,cache_time=False):
    id = None
    try:
        alt_list = common.get_ani_alt_list(anime)
        alt_list.insert(0, {'alt_name': anime})
        for alt_name in alt_list:
            name = alt_name['alt_name']
            abc = name[0]
            if abc.isalpha(): abc = abc.upper()
            else: abc = 'num'
            anime_list = get_abc_list(type,abc,cache_time)
            match = common.find_anime(name, anime_list)
            if match: break
        id = match[0]['id']
    except Exception, e:
        print '[plugin.video.animeanime] %s get_anime_id' % site, e
    return id