#!/usr/bin/python
# -*- coding: utf-8 -*-

# *  Copyright (C) 2018 TDW
import os, time, sys
import xbmc, xbmcgui, xbmcplugin, xbmcaddon, xbmcvfs
import filmpotok


if sys.version_info.major > 2:  # Python 3 or later
	import urllib.request
	from urllib.parse import quote
	from urllib.parse import unquote
	import urllib.request as urllib2
else:  # Python 2
	import urllib, urlparse
	from urllib import quote
	from urllib import unquote_plus as unquote
	import urllib2


PLUGIN_NAME   = 'Filmpotok'
handle = int(sys.argv[1])
addon = xbmcaddon.Addon(id='plugin.video.filmpotok')
__settings__ = xbmcaddon.Addon(id='plugin.video.filmpotok')
icon  = os.path.join( addon.getAddonInfo('path'), 'icon.png')
xbmcplugin.setContent(int(sys.argv[1]), 'movies')

from ftsrc import*

years_list=[
	"--"
	]

for y in range (1930, time.gmtime()[0]+1):
	years_list.append(str(y))

years_list.reverse()
#======================== стандартные функции ==========================

def is_libreelec():
	try:
		if os.path.isfile('/etc/os-release'):
			f = open('/etc/os-release', 'r')
			str = f.read()
			f.close()
			if "LibreELEC" in str and "Generic" in str: return True
	except: pass
	return False


def b2s(s):
	if err_torrent(s)==False: return s
	if sys.version_info.major > 2:
		try:s=s.decode('utf-8')
		except: pass
		if not is_libreelec():
			try:s=s.decode('windows-1251')
			except: pass
		try:s=s.decode('cp437')
		except: pass
		return s
	else:
		return s

def err_torrent(t):
	torrent_data = repr(t)
	if 'd8:' not in torrent_data and 'd7:' not in torrent_data and ':announc' not in torrent_data: True
	else: return False




def fs_dec(path):
	sys_enc = sys.getfilesystemencoding() if sys.getfilesystemencoding() else 'utf-8'
	return path.decode(sys_enc).encode('utf-8')

def fs(s):return s.decode('windows-1251').encode('utf-8')
def win(s):return s.decode('utf-8').encode('windows-1251')
def ru(x):return unicode(x,'utf8', 'ignore')
def xt(x):
	try: r = xbmc.translatePath(x)
	except: r = xbmcvfs.translatePath(x)
	return r

def fs_enc(path):
	path=xt(path)
	sys_enc = sys.getfilesystemencoding() if sys.getfilesystemencoding() else 'utf-8'
	try:path2=path.decode('utf-8')
	except: pass
	try:path2=path2.encode(sys_enc)
	except: 
		try: path2=path2.encode(sys_enc)
		except: path2=path
	return path2

def rt(x):#('&#39;','’'), ('&#145;','‘')
	L=[('&amp;',"&"),('&#133;','…'),('&#38;','&'),('&#34;','"'), ('&#39;','"'), ('&#145;','"'), ('&#146;','"'), ('&#147;','“'), ('&#148;','”'), ('&#149;','•'), ('&#150;','–'), ('&#151;','—'), ('&#152;','?'), ('&#153;','™'), ('&#154;','s'), ('&#155;','›'), ('&#156;','?'), ('&#157;',''), ('&#158;','z'), ('&#159;','Y'), ('&#160;',''), ('&#161;','?'), ('&#162;','?'), ('&#163;','?'), ('&#164;','¤'), ('&#165;','?'), ('&#166;','¦'), ('&#167;','§'), ('&#168;','?'), ('&#169;','©'), ('&#170;','?'), ('&#171;','«'), ('&#172;','¬'), ('&#173;',''), ('&#174;','®'), ('&#175;','?'), ('&#176;','°'), ('&#177;','±'), ('&#178;','?'), ('&#179;','?'), ('&#180;','?'), ('&#181;','µ'), ('&#182;','¶'), ('&#183;','·'), ('&#184;','?'), ('&#185;','?'), ('&#186;','?'), ('&#187;','»'), ('&#188;','?'), ('&#189;','?'), ('&#190;','?'), ('&#191;','?'), ('&#192;','A'), ('&#193;','A'), ('&#194;','A'), ('&#195;','A'), ('&#196;','A'), ('&#197;','A'), ('&#198;','?'), ('&#199;','C'), ('&#200;','E'), ('&#201;','E'), ('&#202;','E'), ('&#203;','E'), ('&#204;','I'), ('&#205;','I'), ('&#206;','I'), ('&#207;','I'), ('&#208;','?'), ('&#209;','N'), ('&#210;','O'), ('&#211;','O'), ('&#212;','O'), ('&#213;','O'), ('&#214;','O'), ('&#215;','?'), ('&#216;','O'), ('&#217;','U'), ('&#218;','U'), ('&#219;','U'), ('&#220;','U'), ('&#221;','Y'), ('&#222;','?'), ('&#223;','?'), ('&#224;','a'), ('&#225;','a'), ('&#226;','a'), ('&#227;','a'), ('&#228;','a'), ('&#229;','a'), ('&#230;','?'), ('&#231;','c'), ('&#232;','e'), ('&#233;','e'), ('&#234;','e'), ('&#235;','e'), ('&#236;','i'), ('&#237;','i'), ('&#238;','i'), ('&#239;','i'), ('&#240;','?'), ('&#241;','n'), ('&#242;','o'), ('&#243;','o'), ('&#244;','o'), ('&#245;','o'), ('&#246;','o'), ('&#247;','?'), ('&#248;','o'), ('&#249;','u'), ('&#250;','u'), ('&#251;','u'), ('&#252;','u'), ('&#253;','y'), ('&#254;','?'), ('&#255;','y'), ('&laquo;','"'), ('&raquo;','"'), ('&nbsp;',' ')]
	for i in L:
		x=x.replace(i[0], i[1])
	return x

def lower(s):
	if sys.version_info.major > 2: return s.lower()
	try:s=s.decode('utf-8')
	except: pass
	if not is_libreelec():
		try:s=s.decode('windows-1251')
		except: pass	
	s=s.lower().encode('utf-8')
	return s

def mid(s, n):
	try:s=s.decode('utf-8')
	except: pass
	if not is_libreelec():
		try:s=s.decode('windows-1251')
		except: pass
	s=s.center(n)
	try:s=s.encode('utf-8')
	except: pass
	return s

def mids(s, n):
	l="                                              "
	s=l[:n-len(s)]+s+l[:n-len(s)]
	return s

def FC(s, color="FFFFFF00"):
	s="[COLOR "+color+"]"+s+"[/COLOR]"
	return s

def mfindal(http, ss, es):
	L=[]
	while http.find(es)>0:
		s=http.find(ss)
		e=http.find(es)
		i=http[s:e]
		L.append(i)
		http=http[e+2:]
	return L

def mfind(t,s,e):
	r=t[t.find(s)+len(s):]
	r2=r[:r.find(e)]
	return r2

def debug(s):
	fl = open(ru(os.path.join( addon.getAddonInfo('path'),"test.txt")), "wb")
	fl.write(s)
	fl.close()

def deb_print(s):
	if __settings__.getSetting("DebMod")=='true': print (s)

def inputbox():
	skbd = xbmc.Keyboard()
	skbd.setHeading('Поиск:')
	skbd.doModal()
	if skbd.isConfirmed():
		SearchStr = skbd.getText()
		return SearchStr
	else:
		return ""

def showMessage(heading, message, times = 3000):
	xbmc.executebuiltin('XBMC.Notification("%s", "%s", %s, "%s")'%(heading, message, times, icon))

def get_params():
	param=[]
	paramstring=sys.argv[2]
	if len(paramstring)>=2:
		params=sys.argv[2]
		cleanedparams=params.replace('?','')
		if (params[len(params)-1]=='/'):
			params=params[0:len(params)-2]
		pairsofparams=cleanedparams.split('&')
		param={}
		for i in range(len(pairsofparams)):
			splitparams={}
			splitparams=pairsofparams[i].split('=')
			if (len(splitparams))==2:
				param[splitparams[0]]=splitparams[1]
	return param

#====================== подготовка данных для интерфейса ================



#============================== основная часть ============================


def getList(id):
	try:L = eval(__settings__.getSetting(id))
	except:L =[]
	S=""
	for i in L:
		if i[:1]=="[": S=S+", "+i
	return S[1:]


def get_labels(info):
	Linf=['genre', 'year', 'rating', 'cast', 'director', 'plot', 'title', 'originaltitle', 'studio']
	Labels={}
	for inf in Linf:
		try:Labels[inf] = info[inf]
		except: pass
	return Labels


def AddItem(Title = "", mode = "", id='0', info={}, total=100):
			try:    url=info['url']
			except: url=''
			try:    cover = info["cover"]
			except: cover = icon
			try:    fanart = info["fanart"]
			except: fanart = ''
			
			try:listitem = xbmcgui.ListItem(Title, iconImage=cover, thumbnailImage=cover)
			except: listitem = xbmcgui.ListItem(Title)
			if mode!="OpenTorrent": listitem.setInfo(type = "Video", infoLabels = get_labels(info))
			try: listitem.setArt({ 'poster': cover, 'fanart' : fanart, 'thumb': cover, 'icon': cover})
			except: pass
			#listitem.setProperty('fanart_image', fanart)
			
			purl = sys.argv[0] + '?mode='+mode+'&id='+id+'&info='+quote(repr(info))
			if url !="": purl = purl +'&url='+quote(url)
			if mode=="OpenTorrent":
				le=['','ace', 't2http', 'yatp', 'torrenter', 'elementum', 'xbmctorrent', 'ace_proxy', 'quasar', 'torrserver']
				tengine = le[int(__settings__.getSetting("TAMengine"))]
				purl='plugin://plugin.video.tam/?mode=open&url='+quote(url)+ '&info=' + quote(repr(info))+ '&engine='+tengine
				listitem.addContextMenuItems([('[B]Сохранить[/B]', 'Container.Update("plugin://plugin.video.tam/?mode=save&url='+quote(url)+'&purl='+quote('plugin://plugin.video.filmpotok/?mode=Torrents2&url='+id)+ '&info=' + quote(repr(info))+'")'),])
			
			#if mode=="Torrents":
			#	listitem.addContextMenuItems([('[B]В избранное[/B]', 'Container.Update("plugin://plugin.video.filmpotok/?mode=Add2List&url='+quote(url)+'")'),])
			#if mode=="Wish":
			#	listitem.addContextMenuItems([('[B]Удалить[/B]', 'Container.Update("plugin://plugin.video.anilibria.tv/?mode=RemItem&id='+id+'")'),])
			
			xbmcplugin.addDirectoryItem(handle, purl, listitem, True, total)


#==============  Menu  ====================
def Root():
	try:L=eval(__settings__.getSetting("W_list"))
	except: L=[]
	AddItem("[B]Поиск[/B]", "Search")
	AddItem("[B]Навигатор[/B]", "Navigator")
	if __settings__.getSetting("HistoryON")=='true': AddItem("[B]История[/B]", "History")
	if __settings__.getSetting("mov_en")  == 'true': AddItem("Фильмы иностранные",       "List",  "mov_en")
	if __settings__.getSetting("mov_ru")  == 'true': AddItem("Фильмы русские ",          "List",  "mov_ru")
	if __settings__.getSetting("sr_en")   == 'true': AddItem("Сериалы иностранные",      "List",  "sr_en")
	if __settings__.getSetting("sr_ru")   == 'true': AddItem("Сериалы русские",          "List",  "sr_ru")
	if __settings__.getSetting("mult_en") == 'true': AddItem("Мультфильмы иностранные ", "List",  "mult_en")
	if __settings__.getSetting("mult_ru") == 'true': AddItem("Мультфильмы русские ",     "List",  "mult_ru")
	if __settings__.getSetting("mult_su") == 'true': AddItem("Мультфильмы советские ",   "List",  "mult_su")
	if __settings__.getSetting("msr_en")  == 'true': AddItem("Мультсериалы",             "List",  "msr_en")
	if __settings__.getSetting("msr_ru")  == 'true': AddItem("Мультсериалы русские ",    "List",  "msr_ru")
	if __settings__.getSetting("anime")   == 'true': AddItem("Аниме",                    "List",  "anime")
	if __settings__.getSetting("an_sr")   == 'true': AddItem("Аниме сериалы",            "List",  "an_sr")
	if __settings__.getSetting("doc_en")  == 'true': AddItem("Передачи",                 "List",  "doc_en")
	if __settings__.getSetting("doc_ru")  == 'true': AddItem("Передачи русские ",        "List",  "doc_ru")
	if __settings__.getSetting("music")   == 'true': AddItem("Музыкальное видео",        "List",  "music")

	if len(L)>0: AddItem("Избранное", "Wish_list")
	xbmcplugin.setPluginCategory(handle, PLUGIN_NAME)
	xbmcplugin.endOfDirectory(handle)

def Search(s=''):
	if s=="": 
		s=inputbox()
		add_history(s)
	if s!="": 
		L=filmpotok.seach(s)
		for i in L:
			Title = i['title']
			AddItem(Title, 'Torrents', '0', i, 50)
		xbmcplugin.endOfDirectory(int(sys.argv[1]))
	else:
		xbmcplugin.endOfDirectory(int(sys.argv[1]), False, False)

def Filtr():
	type   =__settings__.getSetting("type") 
	rating =__settings__.getSetting("rating") 
	year   =__settings__.getSetting("year")
	country=__settings__.getSetting("country") 
	genre  =__settings__.getSetting("genre") 
	sort   =__settings__.getSetting("sort")
	
	
	f_type   = type_list[type]
	#f_rating = rating_list['rating']
	#f_year   = year_list['year']
	try:   f_country= countries_list[country]
	except:f_country=''
	try:   f_genre  = genre_list[genre]
	except:f_genre=''
	f_sort   = sort_list[sort]
	
	if year == '--': year = ''
	
	L=filmpotok.filtr(f_type, rating, year, f_country, f_genre, f_sort)
	for i in L:
			Title = i['title']
			AddItem(Title, 'Torrents', '0', i)
	xbmcplugin.endOfDirectory(int(sys.argv[1]))

def List(id):
	if id ==  "mov_en"  : url = filmpotok.get_most_link('film',    'pop', 'en')
	if id ==  "mov_ru"  : url = filmpotok.get_most_link('film',    'pop', 'ru')
	if id ==  "sr_en"   : url = filmpotok.get_most_link('series',  'pop', 'en')
	if id ==  "sr_ru"   : url = filmpotok.get_most_link('series',  'pop', 'ru')
	if id ==  "mult_en" : url = filmpotok.get_most_link('mult',    'pop', 'en')
	if id ==  "mult_ru" : url = filmpotok.get_link('mult',    'pop', 'ru')
	if id ==  "mult_su" : url = filmpotok.get_link('mult',    'pop', 'su')
	if id ==  "msr_en"  : url = filmpotok.get_link('mult_sr', 'pop', 'en')
	if id ==  "msr_ru"  : url = filmpotok.get_link('mult_sr', 'pop', 'ru')
	if id ==  "anime"   : url = filmpotok.get_link('mult',    'pop', 'jp')
	if id ==  "an_sr"   : url = filmpotok.get_most_link('mult_sr', 'pop', 'jp')
	if id ==  "doc_en"  : url = filmpotok.get_link('doc',     'pop', 'en')
	if id ==  "doc_ru"  : url = filmpotok.get_link('doc',     'pop', 'ru')
	if id ==  "music"   : url = filmpotok.get_link('music')
	
	if len(id)>20: url = unquote(id)
	
	L=filmpotok.get_items(filmpotok.GET(url))
	for i in L:
		Title = i['title']
		AddItem(Title, 'Torrents', '0', i, 50)
	AddItem('Далее >', 'List', quote(get_next(url)))
	xbmcplugin.endOfDirectory(int(sys.argv[1]))

def get_next(url):
	if '?' in url: 
		param=url[url.rfind('?'):]
		url=url[:url.rfind('?')]
	else:
		param=''
	
	if '.html' in url: 
		p=int(url[url.rfind('/')+1:url.rfind('.html')])+1
		nu = url[:url.rfind('/')+1]+str(p)+'.html'
	else: 
		nu=url+"/2.html"
	return nu+param

def Navigator():
	type   =__settings__.getSetting("type") 
	rating =__settings__.getSetting("rating") 
	year   =__settings__.getSetting("year")
	country=__settings__.getSetting("country") 
	genre  =__settings__.getSetting("genre") 
	sort   =__settings__.getSetting("sort")
	
	
	AddItem("Категория:     [COLOR FFFFFF00]" +type+   "[/COLOR]",   "SelCat")
	AddItem("Жанр:               [COLOR FFFFFF00]" +genre+  "[/COLOR]",   "SelGenre")
	AddItem("Год:                  [COLOR FFFFFF00]" +year+   "[/COLOR]",   "SelYear")
	AddItem("Страна:            [COLOR FFFFFF00]" +country+"[/COLOR]",   "SelCountry")
	AddItem("Рейтинг:         [COLOR FFFFFF00]" +rating+ "[/COLOR]",   "SelRating")
	AddItem("Порядок по:  [COLOR FFFFFF00]" +sort+   "[/COLOR]",   "SelSort")
	
	AddItem("[B][COLOR FF00FF00][ Искать ][/COLOR][/B]", "Filtr")


def get_label(text):
	text=lower(text)#.lower()
	if 'трейлер'  in text: return FC('[ Трейл.]',    'FF999999')
	if ' кпк'     in text: return FC('[   КПК  ]',   'FFF8888F')
	if 'telesyn'  in text: return FC('[    TS    ]', 'FFFF2222')
	if 'telecin'  in text: return FC('[    TS    ]', 'FFFF2222')
	if 'camrip'   in text: return FC('[    TS    ]', 'FFFF2222')
	if ' ts'      in text: return FC('[    TS    ]', 'FFFF2222')
	if 'dvdscr'   in text: return FC('[    Scr   ]', 'FFFF2222')
	if ' 3d'      in text: return FC('[    3D    ]', 'FC45FF45')
	if '720'      in text: return FC('[  720p  ]',   'FBFFFF55')
	if '1080'     in text: return FC('[ 1080p ]',    'FAFF9535')
	if '2160'     in text: return FC('[ 2160p ]',    'FAF990FF')
	if 'blu-ray'  in text: return FC('[  BRay  ]',   'FF5555FF')
	if 'bdremux'  in text: return FC('[    BD    ]', 'FF5555FF')
	if ' 4k'      in text: return FC('[    4K    ]', 'FF5555FF')
	if 'bdrip'    in text: return FC('[ BDRip ]',    'FE98FF98')
	if 'drip'     in text: return FC('[ BDRip ]',    'FE98FF98')
	if 'hdrip'    in text: return FC('[ HDRip ]',    'FE98FF98')
	if 'webrip'   in text: return FC('[  WEB   ]',   'FEFF88FF')
	if 'WEB'      in text: return FC('[  WEB   ]',   'FEFF88FF')
	if 'web-dl'   in text: return FC('[  WEB   ]',   'FEFF88FF')
	if 'hdtv'     in text: return FC('[ HDTV ]',     'FEFFFF88')
	if 'tvrip'    in text: return FC('[    TV    ]', 'FEFFFF88')
	if 'satrip'   in text: return FC('[    TV    ]', 'FEFFFF88')
	if 'dvb '     in text: return FC('[    TV    ]', 'FEFFFF88')
	if 'dvdrip'   in text: return FC('[DVDRip]',     'FE88FFFF')
	if 'dvd5'     in text: return FC('[  DVD   ]',   'FE88FFFF')
	if 'xdvd'     in text: return FC('[  DVD   ]',   'FE88FFFF')
	if 'dvd-5'    in text: return FC('[  DVD   ]',   'FE88FFFF')
	if 'dvd-9'    in text: return FC('[  DVD   ]',   'FE88FFFF')
	if 'dvd9'     in text: return FC('[  DVD   ]',   'FE88FFFF')
	return FC('[   ????  ]', 'FFFFFFFF')



def Torrents(url, info):
	L=filmpotok.torrents(url)
	for i in L:
		#{'season':sez,'lng1':lng1,'lng2':lng2,'size':sz,'data':dt,'down':dl,'sid':sid,'lich':lich,'url':tor,'quality':qa}
		if i['season']!='': title=xt(mid(i['season'], 20))+" | "+xt(mid(i['size'], 15)) +" | "+ get_label(xt(i['quality'])) +" | "+ xt(mids(i['sid'], 6))+" | "+xt(i['lng2'])+" "+xt(i['lng1'])
		else :              title=                               xt(mid(i['size'], 15)) +" | "+ get_label(xt(i['quality'])) +" | "+ xt(mids(i['sid'], 6))+" | "+xt(i['lng1'])+" "+xt(i['lng2'])
		#title=i['size']+" | "+i['quality']+" | "+xt(i['title'])
		info['url']=i['url']
		AddItem(title, "OpenTorrent", '0', info)
	
	return L


def SetViewMode():
	n = int(__settings__.getSetting("ListView"))
	if n>0:
		xbmc.executebuiltin("Container.SetViewMode(0)")
		for i in range(1,n):
			xbmc.executebuiltin("Container.NextViewMode")

def History():
	try:L=eval(__settings__.getSetting("History"))
	except: L=[]
	for i in L:
		AddItem(i, 'HSearch', '0', {'src':i})
	xbmcplugin.setPluginCategory(handle, PLUGIN_NAME)
	xbmcplugin.endOfDirectory(handle)

def add_history(t):
	try:L=eval(__settings__.getSetting("History"))
	except: L=[]
	if t not in L:
		NL=[]
		NL.append(t)
		NL.extend(L[:15])
		__settings__.setSetting("History", repr(NL))

try:    mode = unquote(get_params()["mode"])
except: mode = None
try:    url = unquote(get_params()["url"])
except: url = None
try:    info = eval(unquote(get_params()["info"]))
except: info = {}
try:    id = str(get_params()["id"])
except: id = '0'
try:    ind = int(get_params()["ind"])
except: ind = 0


if mode == None:
	__settings__.setSetting(id="type",    value="Все")
	__settings__.setSetting(id="rating",  value="6")
	__settings__.setSetting(id="year",    value="--")
	__settings__.setSetting(id="country", value="--")
	__settings__.setSetting(id="genre",   value="--")
	__settings__.setSetting(id="sort",    value="Популярности")
	Root()

if mode == "Search":
	Search()
	xbmcplugin.setPluginCategory(handle, PLUGIN_NAME)
	xbmcplugin.endOfDirectory(handle)

if mode == 'HSearch':
	Search(info['src'])
	xbmcplugin.setPluginCategory(handle, PLUGIN_NAME)
	xbmcplugin.endOfDirectory(handle)

if mode == 'History':
	History()

if mode == "Navigator":
	Navigator()
	xbmcplugin.setPluginCategory(handle, PLUGIN_NAME)
	xbmcplugin.endOfDirectory(handle)

if mode == "Filtr":
	Filtr()
	xbmcplugin.setPluginCategory(handle, PLUGIN_NAME)
	xbmcplugin.endOfDirectory(handle)

if mode == "Genres":
	SrcNavi("Genres")
	xbmcplugin.setPluginCategory(handle, PLUGIN_NAME)
	xbmcplugin.endOfDirectory(handle)

if mode == "Years":
	SrcNavi("Years")
	xbmcplugin.setPluginCategory(handle, PLUGIN_NAME)
	xbmcplugin.endOfDirectory(handle)

if mode == "All":
	SrcNavi("ListAll")
	xbmcplugin.setPluginCategory(handle, PLUGIN_NAME)
	xbmcplugin.addSortMethod(handle, xbmcplugin.SORT_METHOD_LABEL)
	xbmcplugin.endOfDirectory(handle)

if mode == "List":
	List(id)
	xbmcplugin.setPluginCategory(handle, PLUGIN_NAME)
	xbmcplugin.endOfDirectory(handle)

if mode == "Torrents" or mode == "Torrents2":
	Torrents(url, info)
	xbmcplugin.setPluginCategory(handle, PLUGIN_NAME)
	xbmcplugin.addSortMethod(handle, xbmcplugin.SORT_METHOD_LABEL)
	xbmcplugin.endOfDirectory(handle)
	xbmc.sleep(300)
	SetViewMode()

if mode == "Add2List":
	try:L=eval(__settings__.getSetting("W_list"))
	except: L=[]
	if id not in L:
		L.append(id)
		__settings__.setSetting("W_list", repr(L))

if mode == "RemItem":
	try:L=eval(__settings__.getSetting("W_list"))
	except: L=[]
	L.remove(id)
	__settings__.setSetting("W_list", repr(L))
	xbmc.executebuiltin("Container.Refresh()")

if mode == "Wish_list":
	try:L=eval(__settings__.getSetting("W_list"))
	except: L=[]
	for id in L:
		#info=get_info(str(id))
		rus=id#info["title"]
		AddItem(rus, 'Wish', id)
	xbmcplugin.endOfDirectory(handle)

if mode == "Wish":
	Torrents(id)
	xbmcplugin.setPluginCategory(handle, PLUGIN_NAME)
	xbmcplugin.addSortMethod(handle, xbmcplugin.SORT_METHOD_LABEL)
	xbmcplugin.endOfDirectory(handle)
	xbmc.sleep(300)
	SetViewMode()
	#xbmc.executebuiltin("Container.SetViewMode(51)")

if mode == "SelCat":
	sel = xbmcgui.Dialog()
	L=['Все','Фильмы','Сериалы','Мультфильмы','ТВ','Музыка']
	r = sel.select("Тип:", L)
	if r>-1:__settings__.setSetting(id="type", value=L[r])
	
if mode == "SelGenre":
	sel = xbmcgui.Dialog()
	L=[]
	for i in genre_list.keys():
		L.append(i)
	L.sort()
	r = sel.select("Жанр:", L)
	if r>-1:__settings__.setSetting(id="genre", value=L[r])
	
if mode == "SelCountry":
	sel = xbmcgui.Dialog()
	L=[]
	for i in countries_list.keys():
		L.append(i)
	L.sort()
	r = sel.select("Страна:", L)
	if r>-1:__settings__.setSetting(id="country", value=L[r])

if mode == "SelSort":
	sel = xbmcgui.Dialog()
	L=[]
	for i in sort_list.keys():
		L.append(i)
	r = sel.select("Порядок:", L)
	if r>-1:__settings__.setSetting(id="sort", value=L[r])

if mode == "SelYear":
	sel = xbmcgui.Dialog()
	L=years_list
	r = sel.select("Год:", L)
	if r>-1:__settings__.setSetting(id="year", value=years_list[r])

if mode == "SelRating":
	sel = xbmcgui.Dialog()
	L=['1', '2', '3', '4', '5', '6', '7', '8', '9', '10']
	r = sel.select("Рейтинг:", L)
	if r>-1:__settings__.setSetting(id="rating", value=L[r])