#!/usr/bin/python
#IceLibrary2
#With some code borrowed from Icefilms.info v1.0.10 - anarchintosh / daledude / westcoast13 2011-07-02

'''
    Copyright (C) 2013 DudeHere

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
'''

############################
### Imports		 ###
############################	

import urllib2
import urllib
import sys
import os
import re
import random
import copy
import xbmc
import xbmcplugin
import xbmcgui
import xbmcaddon
from urllib import quote_plus
from addon.common.net import Net
from addon.common.addon import Addon
from BeautifulSoup import BeautifulSoup, Tag, NavigableString
net = Net()

ADDON_ID = 'plugin.video.icelibrary2'
ADDON = Addon(ADDON_ID,sys.argv)
ROOT_PATH = ADDON.get_path()
DATA_PATH = ADDON.get_profile()
sys.path.append(os.path.join(ROOT_PATH, 'resources', 'lib'))
from functions import *
import htmlcleaner
vfs = Vfs()

from HTMLParser import HTMLParser
import htmlentitydefs

class HTMLTextExtractor(HTMLParser):
	def __init__(self):
		HTMLParser.__init__(self)
		self.result = [ ]

	def handle_data(self, d):
		self.result.append(d)

	def handle_charref(self, number):
		codepoint = int(number[1:], 16) if number[0] in (u'x', u'X') else int(number)
		self.result.append(unichr(codepoint))

	def handle_entityref(self, name):
		codepoint = htmlentitydefs.name2codepoint[name]
		self.result.append(unichr(codepoint))

	def get_text(self):
		return u''.join(self.result)

def strip_tags(html):
	s = HTMLTextExtractor()
	s.feed(html)
	return s.get_text()

############################
### Enviornment		 ###
############################


BASE_URL = 'http://www.icefilms.info'
USER_AGENT = 'Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/28.0.1500.72 Safari/537.36'
ACCEPT = 'text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8'
ICEFILMS_URL = ADDON.get_setting('icefilms-url')
ICEFILMS_REFERRER = 'http://www.icefilms.info'
ICEFILMS_AJAX = ICEFILMS_URL + '/membersonly/components/com_iceplayer/video.phpAjaxResp.php'
COMPLETE_PERCENT = 90
COOKIE_JAR = vfs.join(DATA_PATH,'icefilms.lwp')
if ADDON.get_setting('movie_custom_directory') == "true":
	MOVIES_PATH = ADDON.get_setting('movie_directory')
else:
	MOVIES_PATH = vfs.join(DATA_PATH, 'movies/')

if ADDON.get_setting('tv_show_custom_directory') == "true":
	TV_SHOWS_PATH = ADDON.get_setting('tv_show_directory')
else:
	TV_SHOWS_PATH = vfs.join(DATA_PATH, 'tvshows/')
net.set_user_agent(USER_AGENT)


############################
### Database		     ###
############################

IGNORE_UNIQUE_ERRORS = True

class DatabaseClass:
	def __init__(self, quiet=False):
		self.quiet=quiet

	def commit(self):
		if self.db_type == 'sqlite':
			print "Commiting to %s" % self.db_file
		else:
			print "Commiting to %s on %s" % (self.dbname, self.host)
		self.DBH.commit()

	def query(self, SQL, data=None, force_double_array=False):
		if data:
			self.DBC.execute(SQL, data)
		else:
			self.DBC.execute(SQL)
		rows = self.DBC.fetchall()
		if(len(rows)==1 and not force_double_array):
			return rows[0]
		else:
			return rows

	def execute(self, SQL, data=[]):
		try:
			if data:
				self.DBC.execute(SQL, data)
			else:
				self.DBC.execute(SQL)
			try:
				self.lastrowid = self.DBC.lastrowid
			except:
				self.lastrowid = None
		except Exception, e:
			if IGNORE_UNIQUE_ERRORS and re.match('column (.)+ is not unique$', str(e)):				
				#return None
				print '****** SQL ERROR: %s' % e

class SQLiteDatabase(DatabaseClass):
	def __init__(self, db_file='', quiet=False):
		self.quiet=quiet
		self.db_type = 'sqlite'
		self.lastrowid = None
		self.db_file = db_file		
		self._connect()
	
	def _initialize(self):
		global ADDON
		self.execute("CREATE TABLE IF NOT EXISTS ice_favorites (id INTEGER PRIMARY KEY, name TEXT UNIQUE, url TEXT UNIQUE, new INTEGER default 0)")
		self.execute('CREATE TABLE IF NOT EXISTS "ice_player_state" (  "playid" INTEGER  PRIMARY KEY AUTOINCREMENT, "url" TEXT, "current" TEXT, "total" TEXT, "percent" TEXT, UNIQUE (url) ON CONFLICT REPLACE)')
		self.commit()
		ADDON.addon.setSetting('database_sqlite_init', 'true')	

	def _connect(self):
		global ADDON
		if not self.quiet:
			print "Connecting to " + self.db_file
		try:
			from sqlite3 import dbapi2 as database
			if not self.quiet:
				print "Icelibrary2 loading sqlite3 as DB engine"
		except:
			from pysqlite2 import dbapi2 as database
			if not self.quiet:
				print "Icelibrary2 loading pysqlite2 as DB engine"
		if not self.quiet:
			print "Connecting to SQLite on: " + self.db_file
		self.DBH = database.connect(self.db_file)
		self.DBC = self.DBH.cursor()
		
		if ADDON.get_setting('database_sqlite_init') != 'true':
			self._initialize()

class MySQLDatabase(DatabaseClass):
	def __init__(self, host, dbname, username, password, port=3306, quiet=False):
		self.quiet=quiet
		self.db_type = 'mysql'
		self.lastrowid = None
		self.host = host
		self.dbname = dbname
		self.username = username
		self.password = password
		self.port = port
		self._connect()

	def _initialize(self):
		global ADDON
		self.execute("CREATE TABLE IF NOT EXISTS `ice_favorites` (`id` int(11) NOT NULL AUTO_INCREMENT, `name` varchar(255) DEFAULT NULL, `url` varchar(125) DEFAULT NULL, `new` tinyint(1) DEFAULT '1', PRIMARY KEY (`id`), UNIQUE KEY `url` (`url`) ) ENGINE=InnoDB")
		self.execute('CREATE  TABLE IF NOT EXISTS `ice_player_state` ( `playid` INT NOT NULL AUTO_INCREMENT , `url` VARCHAR(255) NULL , `current` VARCHAR(45) NULL , `total` VARCHAR(45) NULL , `percent` VARCHAR(45) NULL , PRIMARY KEY (`playid`) , UNIQUE INDEX `unique_url` (`url` ASC) )')
		self.commit()
		ADDON.addon.setSetting('database_mysql_init', 'true')

	def _connect(self):
		global ADDON
		try:	
			import mysql.connector as database
			if not self.quiet:
				print "Icelibrary2 loading mysql.connector as DB engine"
			dsn = {
					"database": self.dbname,
					"host": self.host,
					"port": int(self.port),
					"user": str(self.username),
					"password": str(self.password),
					"buffered": True
			}
			self.DBH = database.connect(**dsn)
		except Exception, e:
			print '******Icelibrary2 SQL ERROR: %s' % e
		self.DBC = self.DBH.cursor()
		if ADDON.get_setting('database_mysql_init') != 'true':
			self._initialize()
	
	def execute(self, SQL, data=[]):					
		try:
			if data:
				SQL = SQL.replace('?', '%s')
				self.DBC.execute(SQL, data)
			else:
				self.DBC.execute(SQL)
			try:
				self.lastrowid = self.DBC.lastrowid
			except:
				self.lastrowid = None
		except Exception, e:
			if IGNORE_UNIQUE_ERRORS and re.match('1062: Duplicate entry', str(e)):				
				print '******SQL ERROR: %s' % e

	def query(self, SQL, data=None, force_double_array=False):
		if data:
			SQL = SQL.replace('?', '%s')
			self.DBC.execute(SQL, data)
		else:
			self.DBC.execute(SQL)
		rows = self.DBC.fetchall()
		if(len(rows)==1 and not force_double_array):
			return rows[0]
		else:
			return rows	
		

if ADDON.get_setting('database_mysql')=='true':
	DB_NAME = ADDON.get_setting('database_mysql_name')
	DB_USER = ADDON.get_setting('database_mysql_user')
	DB_PASS = ADDON.get_setting('database_mysql_pass')
	DB_PORT = ADDON.get_setting('database_mysql_port')
	DB_ADDRESS = ADDON.get_setting('database_mysql_host')
	DB_TYPE = 'mysql'
	DB=MySQLDatabase(DB_ADDRESS, DB_NAME, DB_USER, DB_PASS, DB_PORT)
else:
	DB_TYPE = 'sqlite'
	if not vfs.exists(DATA_PATH):
		vfs.mkdir(DATA_PATH)
	DB_FILE = xbmc.translatePath(ADDON.get_setting('database_sqlite_file'))
	DB=SQLiteDatabase(DB_FILE)

############################
### Main Functions	     ###
############################



def AutoUpdate(service):
	if service=='tv':
		print "auto update tv"
		UpdateFavorites(silent=True)
	elif service=='movies':
		print "auto update movies"
		MovieAddAll(silent=True)

	if ADDON.get_setting('update_library')=='true':
		xbmc.executebuiltin('UpdateLibrary("video")')
		#xbmc.executebuiltin('UpdateLibrary(video,' + MOVIES_PATH + ')')


def TVList(page, subject):
	if page == 'az':
		url = "%s/tv/a-z/%s" % (BASE_URL, subject)
	elif page == 'genres':
		url = "%s/tv/popular/%s" % (BASE_URL, subject.lower())
	elif page == 'popular':
		url = "%s/tv/popular/1" % BASE_URL
	elif page == 'rated':
		url = "%s/tv/rating/1" % BASE_URL
	elif page == 'release':
		url = "%s/tv/release/1" % BASE_URL
	elif page == 'added':
		url = "%s/tv/added/1" % BASE_URL
	html = net.http_GET(url).content
	soup = BeautifulSoup(html)
	favorites = DB.query("SELECT url FROM ice_favorites", force_double_array=True)
	shows = soup.findAll('img', {'class': 'star'})
	for show in shows:
		a = show.findNextSibling('a')
		title = str(a.string)
		title = htmlcleaner.clean(title,strip=True)
		href = a['href']
		is_fav = False
		for test in favorites:
			if test[0]==href:
				is_fav = True
				break
		if is_fav:
			ADDON.add_directory({'mode': 'tv_add_show', 'name': title, 'href': href}, {'title': "[COLOR green]" + title + "[/COLOR]"})
		else:
			ADDON.add_directory({'mode': 'tv_add_show', 'name': title, 'href': href}, {'title': title})
	ADDON.end_of_directory()

def AddTVShow(name, href):
	if DB.query("SELECT 'True' FROM ice_favorites WHERE url=?",[href], force_double_array=False):
		dialog = xbmcgui.Dialog()
		if dialog.yesno("Remove", "Do you want to remove %s?" % name):
			DB.execute("DELETE FROM ice_favorites WHERE url=?", [href])
			DB.commit()
			REFRESH()
			Notify("Favorite deleted", name + " was droped from favorites.")
	else:
		DB.execute("INSERT INTO ice_favorites(name, url) VALUES(?,?)", [name, href])
		DB.commit()
		REFRESH()
		Notify("Favorite added", name + " was added to favorites.")
	

def AddMovie(name, href, quite=False):
	#print "Add movie %s, %s" % (name, href)
	name = CleanFileName(name, remove_year=True)
	moviepath = vfs.join(MOVIES_PATH,name)
	filepath = vfs.join(moviepath, name + '.strm')
	vfs.mkdir(moviepath, recursive=True)
	strm_string = "plugin://" + ADDON_ID
	strm_string += "/?href=" + urllib.quote(href) 
	strm_string += "&mode=launch_strm&name=" + urllib.quote(name) 
	strm_string += "&path="+ urllib.quote(filepath)
	file = vfs.open(filepath,'w')
	file.write(strm_string)
	file.close()
	if not quite:
		Notify("Movie added", name)

def MovieAddAll(silent=False):
	import string
	pDialog = xbmcgui.DialogProgress()
	if not silent:
		dialog = xbmcgui.Dialog()
		msg = 'Add Movies?'
		msg2 = "This will scrape [COLOR=red]ALL[/COLOR] of the movies."
		msg3 = "Do you want to continue?"
		if not dialog.yesno(msg, msg2, msg3): return
		pDialog.create('Getting Moives')
	index = 1
	percent = int((100 * index) / 27)
	GetMoives('1', pDialog, percent, silent)
	for letter in string.ascii_uppercase:
		index = index + 1		
		percent = int((100 * index) / 27)
		if not silent:
			if (pDialog.iscanceled()):
				return
			print "Scraping movies: " + letter
		GetMoives(letter, pDialog, percent, silent)

def GetMoives(letter, pDialog, percent, silent):
	href = '/movies/a-z/%s' % letter
	url = ICEFILMS_URL + href
	html = net.http_GET(url).content
	soup = BeautifulSoup(html)
	movies = soup.findAll('img', {'class': 'star'})
	for movie in movies:
		a = movie.findNextSibling('a')
		title = str(a.string)
		title = htmlcleaner.clean(title,strip=True)
		href = a['href']
		isHD = str(a.findNextSibling()) == '<b>HD</b>'
		if (ADDON.get_setting('filter-movies-hd')=='true' and isHD) or ADDON.get_setting('filter-movies-hd')=='false':
			AddMovie(title, href, quite=True) 
			if not silent:
				pDialog.update(percent, "Scraping Movies", title)

def TVViewFavorites():
	print "View Favorites"
	rows = DB.query("SELECT name,id FROM ice_favorites ORDER BY name ASC", force_double_array=True)
	for row in rows:
		ADDON.add_directory({'mode': 'tv_remove', 'name': row[0], 'id': row[1]}, {'title': row[0]})
	ADDON.end_of_directory()

def TVRemoveFavorite(name, fid):
	print "remove favorite"
	dialog = xbmcgui.Dialog()
	if dialog.yesno("Remove", "Do you want to remove %s?" % name):
		print "Removing favorites"
		DB.execute("DELETE FROM ice_favorites WHERE id=?", [fid])
		DB.commit()
		REFRESH()

def UpdateFavorites(silent=False):
	pDialog = xbmcgui.DialogProgress()
	if not silent:
		pDialog.create('Updating favorites')
	rows = DB.query("SELECT name, url FROM ice_favorites ORDER BY name ASC", force_double_array=True)
	index = 0
	for row in rows:
		name = str(row[0])
		url = str(row[1])
		index = index + 1		
		percent = int((100 * index) / len(rows))
		if not silent:
			if (pDialog.iscanceled()):
				return
			print "Scraping: " + name
			pDialog.update(percent, "Scraping TV show", name)
		GetEpisodes(name, url, silent)

def GetEpisodes(name, href, silent=False):
	showname = removeYear(name)
	url = ICEFILMS_URL + href
	print url
	html = net.http_GET(url).content
	soup = BeautifulSoup(html)
	shows = soup.findAll('img', {'class': 'star'})
	for show in shows:
		a = show.findNextSibling('a')
		isHD = str(a.findNextSibling()) == '<b>HD</b>'
		if (ADDON.get_setting('filter-tvshows-hd')=='true' and isHD) or ADDON.get_setting('filter-tvshows-hd')=='false':
			title = str(a.string)
			title = htmlcleaner.clean(title,strip=True)
			href = a['href']
			temp = re.search('^(\d+?)x(\d+?)', title)
			season = temp.group(1)
			episode = temp.group(2)
			CreateStreamFile(showname,title,href,season,episode)

def CreateStreamFile(showname,title,href,season,episode):
	path = CreateSeasonFolder(showname,season)
	filepath = vfs.join(path,title+'.strm')
	strm_string = "plugin://" + ADDON_ID
	strm_string += "/?href=" + urllib.quote(href) 
	strm_string += "&mode=launch_strm&name=" + urllib.quote(showname + ' - ' + title) 
	strm_string += "&path="+ urllib.quote(filepath)
	file = vfs.open(filepath,'w')
	file.write(strm_string)
	file.close()	
		
def CreateSeasonFolder(showname, season):
	showpath = vfs.join(TV_SHOWS_PATH,showname)
	fullpath = vfs.join(showpath,season)
	vfs.mkdir(fullpath, recursive=True)
	return fullpath

def AddSource(which):
	print "Trying to add IceLibrary source paths..."
	source_path = vfs.join('special://profile/', 'sources.xml')
	if not vfs.exists(source_path):
		soup = BeautifulSoup()
		sources_tag = Tag(soup, "sources")
		soup.insert(0, sources_tag)
	else:
		file = vfs.open(source_path, 'r')
		content=file.read()
		file.close()
		soup = BeautifulSoup(content)


	if soup.find("video") == None:
		sources = soup.find("sources")
		video_tag = Tag(soup, "video")
		sources.insert(0, video_tag)

	video = soup.find("video")

	if which=="movies":
		vfs.mkdir(MOVIES_PATH)
		if len(soup.findAll(text="Movies (Icefilms)")) < 1:
			movie_source_tag = Tag(soup, "source")
			movie_name_tag = Tag(soup, "name")
			movie_name_tag.insert(0, "Movies (Icefilms)")
			MOVIES_PATH_tag = Tag(soup, "path")
			MOVIES_PATH_tag['pathversion'] = 1
			MOVIES_PATH_tag.insert(0, MOVIES_PATH)
			movie_source_tag.insert(0, movie_name_tag)
			movie_source_tag.insert(1, MOVIES_PATH_tag)
			video.insert(2, movie_source_tag)

	if which=="tv":
		vfs.mkdir(TV_SHOWS_PATH)
		if len(soup.findAll(text="TV Shows (Icefilms)")) < 1:	
			tvshow_source_tag = Tag(soup, "source")
			tvshow_name_tag = Tag(soup, "name")
			tvshow_name_tag.insert(0, "TV Shows (Icefilms)")
			tvshow_path_tag = Tag(soup, "path")
			tvshow_path_tag['pathversion'] = 1
			tvshow_path_tag.insert(0, TV_SHOWS_PATH)
			tvshow_source_tag.insert(0, tvshow_name_tag)
			tvshow_source_tag.insert(1, tvshow_path_tag)
			video.insert(2, tvshow_source_tag)

	file = vfs.open(source_path, 'w')
	file.write(str(soup))
	file.close()
	print "Source paths added!"

	dialog = xbmcgui.Dialog()
	dialog.ok("Source folders added", "To complete the setup:", " 1) Restart XBMC.", " 2) Set the content type of added folders.")


def ShowAbout():
	path = vfs.join(ROOT_PATH, 'changelog.txt')
	file = vfs.open(path, 'r')
	changelog=file.read()
	file.close()
	path = vfs.join(ROOT_PATH + '/resources', 'welcome.html')
	file = vfs.open(path, 'r')
	content=file.read()
	content += '\n[COLOR red][B]Changelog[/B][/COLOR]\n\n' + changelog
	TextBox().show('IceLibrary2!', content)
	file.close()

def LaunchStream(args):
	resolved_url = None
	dialog = xbmcgui.Dialog()
	url = ICEFILMS_URL + args['href']
	html = net.http_GET(url).content
	match=re.compile('/membersonly/components/com_iceplayer/(.+?)" width=').findall(html)
	match[0]=re.sub('%29',')',match[0])
	match[0]=re.sub('%28','(',match[0])
	for url in match:
		mirrorpageurl = ICEFILMS_URL + '/membersonly/components/com_iceplayer/' + url
	html = net.http_GET(mirrorpageurl).content
	soup = BeautifulSoup(html)
	sec = re.search("f\.lastChild\.value=\"(.+?)\",a", html).group(1)
	t = re.search('"&t=([^"]+)",', html).group(1)
	_args = {'iqs': '', 'url': '', 'cap': ''}
	_args['sec'] = sec
	_args['t'] = t		
	quality_list = soup.findAll("div", { "class" : "ripdiv" })
	mirror_options = []
	mirror_ids = []
	for quality in quality_list:
			if re.search('HD', quality.b.string):
				definition = '[COLOR red]HD[/COLOR]'
			else:
				definition = '[COLOR blue]SD[/COLOR]'
			mirrors = quality.findAll("p")
			for mirror in mirrors:
				links = mirror.findAll("a")
				for link in links:
					opt = getProvider(link)
					if opt:
						text = "%s %s" % (opt, definition)
						mirror_options.append(text)
						mirror_id = link['onclick'][3:len(link['onclick'])-1]
						mirror_ids.append(mirror_id)
	mirror_select = dialog.select('Select mirror', mirror_options)
	if mirror_select < 0:
		return
	raw_url = GetSource(int(mirror_ids[mirror_select]), _args)
	try:
		import urlresolver
		resolved_url = urlresolver.HostedMediaFile(url=raw_url).resolve()
	except:
		print "Unable to resolve with urlresolver"
	if not resolved_url:
		ADDON.show_error_dialog(['URLResolver Error', 'Unable to resolve url',raw_url])
		return False
		
	print resolved_url
	StreamFile(resolved_url, args['name'], args['href'])

def GetSource(mirror_id, args):
	m = random.randrange(100, 300) * -1
	s = random.randrange(5, 50)
	params = copy.copy(args)
	params['id'] = mirror_id
	params['m'] = m
	params['s'] = s
	paramsenc = urllib.urlencode(params)	
	html = net.http_POST(ICEFILMS_AJAX, params).content
	source = re.search('url=(http[^&]+)', html)
	if source:
		raw_url = urllib.unquote(source.group(1))
	return raw_url
	


def getProvider(link):
	opt = ''
	text = link.next[0:len(link.next)-2]
	s = re.search('Source #(\d+): (.+?)</a>', str(link))
	skey = strip_tags(s.group(2)).lower()
	table = {
			'180upload': 		'180upload.com',
			'hugefiles':		'hugefiles.net',
			'clicknupload':		'clicknupload.com',
			'tusfiles':			'tusfiles.net',
			'xfileload':		'xfileload.com',
			'mightyupload':		'mightyupload.com',
			'movreel':			'movreel.com',
			'donevideo':		'donevideo.com',
			'vidplay':			'vidplay.net',
			'24uploading':		'24uploading.com',
			'xvidstage':		'xvidstage.com',
			'2shared':			'2shared.com'
	}
	if skey in table.keys():
		return text + ': ' + table[skey]
	else: print skey
			
	return opt

def StreamFile(url, title, href):
	listitem = xbmcgui.ListItem(title, iconImage='', thumbnailImage='', path=url)
	listitem.setProperty('IsPlayable', 'true')
	listitem.setPath(url)
	xbmcplugin.setResolvedUrl(int(sys.argv[ 1 ]),True,listitem)
############################
### Menus		 ###
############################

def MainMenu():
	print "main menu"
	ADDON.add_directory({'mode': 'tv_menu'}, {'title': 'TV Shows'})
	ADDON.add_directory({'mode': 'movie_menu'}, {'title': 'Movies'})
	ADDON.add_directory({'mode': 'urlresolver'}, {'title': 'URLResolver Settings'})
	ADDON.add_directory({'mode': 'about'}, {'title': 'About IceLibrary2'})
	ADDON.end_of_directory()


def TVMenu():
	print "tv menu"
	ADDON.add_directory({'mode': 'tv_add'}, {'title': 'Add Favorites'})
	ADDON.add_directory({'mode': 'tv_view_favorites'}, {'title': 'View Favorites'})
	ADDON.add_directory({'mode': 'tv_update_favorites'}, {'title': 'Update Favorites'})
	ADDON.add_directory({'mode': 'add_tv_path'}, {'title': 'Add TV Shows to sources.xml'})
	ADDON.end_of_directory()

def TVAddMenu():
	ADDON.add_directory({'mode': 'tv_az'}, {'title': 'A-Z'})
	ADDON.add_directory({'mode': 'tv_genres'}, {'title': 'Genres'})
	ADDON.add_directory({'mode': 'tv_list', 'name': 'popular', 'subject': 1}, {'title': 'Popular'})
	ADDON.add_directory({'mode': 'tv_list', 'name': 'rated', 'subject': 1}, {'title': 'Highly rated'})
	ADDON.add_directory({'mode': 'tv_list', 'name': 'release', 'subject': 1}, {'title': 'Newly released'})
	ADDON.add_directory({'mode': 'tv_list', 'name': 'added', 'subject': 1}, {'title': 'Newly added'})
	ADDON.end_of_directory()

def TVAZMenu(): 
	import string
	ADDON.add_directory({'mode': 'tv_list', 'name': 'az', 'subject': '1'}, {'title': '#1234'})
	for i in string.ascii_uppercase:
		ADDON.add_directory({'mode': 'tv_list', 'name': 'az', 'subject': i}, {'title': i})
	ADDON.end_of_directory()

def TVGenresMenu():
	genres = ['Action', 'Animation', 'Comedy', 'Documentary', 'Drama',  'Family', 'Horror', 'Romance', 'Sci-Fi', 'Thriller']
	for genre in genres:
		ADDON.add_directory({'mode': 'tv_list', 'name': 'genres', 'subject': genre}, {'title': genre})
	ADDON.end_of_directory()


def MovieMenu():
	ADDON.add_directory({'mode': 'movie_add'}, {'title': 'Add Movies'})
	ADDON.add_directory({'mode': 'movie_add_all'}, {'title': 'Add All Movies'})
	ADDON.add_directory({'mode': 'add_movie_path'}, {'title': 'Add Movies to sources.xml'})
	ADDON.end_of_directory()

def MovieAddMenu():
	ADDON.add_directory({'mode': 'movie_az'}, {'title': 'A-Z'})
	ADDON.add_directory({'mode': 'movie_genres'}, {'title': 'Genres'})
	ADDON.add_directory({'mode': 'movie_list', 'name': 'popular', 'subject': 1}, {'title': 'Popular'})
	ADDON.add_directory({'mode': 'movie_list', 'name': 'rated', 'subject': 1}, {'title': 'Highly rated'})
	ADDON.add_directory({'mode': 'movie_list', 'name': 'release', 'subject': 1}, {'title': 'Newly released'})
	ADDON.add_directory({'mode': 'movie_list', 'name': 'added', 'subject': 1}, {'title': 'Newly added'})
	ADDON.end_of_directory()

def MovieAZMenu(): 
	import string
	ADDON.add_directory({'mode': 'movie_list', 'name': 'az', 'subject': '1'}, {'title': '#1234'})
	for i in string.ascii_uppercase:
		ADDON.add_directory({'mode': 'movie_list', 'name': 'az', 'subject': i}, {'title': i})
	ADDON.end_of_directory()


def MovieList(page, subject):
	if page == 'az':
		url = "%s/movies/a-z/%s" % (BASE_URL, subject)
	elif page == 'genres':

		url = "%s/movies/popular/%s" % (BASE_URL, subject.lower())
	elif page == 'popular':
		url = "%s/movies/popular/1" % BASE_URL

	elif page == 'rated':
		url = "%s/movies/rating/1" % BASE_URL
	elif page == 'release':

		url = "%s/movies/release/1" % BASE_URL
	elif page == 'added':
		url = "%s/movies/added/1" % BASE_URL
		
	html = net.http_GET(url).content

	soup = BeautifulSoup(html)
	movies = soup.findAll('img', {'class': 'star'})
	for movie in movies:
		a = movie.findNextSibling('a')
		title = str(a.string)
		title = htmlcleaner.clean(title,strip=True)
		href = a['href']
		isHD = str(a.findNextSibling()) == '<b>HD</b>'

		if(isHD):

			definition = '[COLOR=red]HD[/COLOR]'
		else:
			definition = '[COLOR=blue]SD[/COLOR]'
		if (ADDON.get_setting('filter-movies-hd')=='true' and isHD) or ADDON.get_setting('filter-movies-hd')=='false':	
			ADDON.add_directory({'mode': 'movie_import', 'name': title, 'href': href}, {'title': title + ' ' + definition})

		
	ADDON.end_of_directory()

############################
### Modes		 	     ###
############################

args = ADDON.parse_query(sys.argv[2])
print args
if args['mode'] == 		'main':
	MainMenu()
elif args['mode'] == 		'tv_menu':
	TVMenu()
elif args['mode'] == 		'tv_add':
	TVAddMenu()
elif args['mode'] == 		'tv_az':
	TVAZMenu()
elif args['mode'] == 		'tv_genres':
	TVGenresMenu()
elif args['mode'] == 		'tv_list':
	TVList(args['name'], args['subject'])
elif args['mode'] == 		'tv_add_show':
	AddTVShow(args['name'], args['href'])

elif args['mode'] == 		'tv_view_favorites':
	TVViewFavorites()
elif args['mode'] == 		'tv_update_favorites':
	UpdateFavorites()
elif args['mode'] == 		'tv_remove':
	TVRemoveFavorite(args['name'], args['id'])

elif args['mode'] == 		'movie_menu':
	MovieMenu()
elif args['mode'] == 		'movie_add':
	MovieAddMenu()
elif args['mode'] == 		'movie_az':
	MovieAZMenu()
elif args['mode'] == 		'movie_genres':
	MovieGenresMenu()
elif args['mode'] == 		'movie_list':
	MovieList(args['name'], args['subject'])
elif args['mode'] == 		'movie_get':
	AddMovie(args['name'], args['href'])
elif args['mode'] == 		'movie_import':
	AddMovie(args['name'], args['href'])
elif args['mode'] == 		'movie_add_all':
	MovieAddAll()

elif args['mode'] == 		'autoupdate_tv':
	AutoUpdate('tv')
elif args['mode'] == 		'autoupdate_movies':
	AutoUpdate('movies')


elif args['mode'] == 		'add_tv_path':
	AddSource('tv')
elif args['mode'] == 		'add_movie_path':
	AddSource('movies')

elif args['mode'] == 		'urlresolver':
	xbmcaddon.Addon(id='script.module.urlresolver').openSettings()
elif args['mode'] == 		'about':
	ShowAbout()
	
elif args['mode'] == 		'launch_strm':
	LaunchStream(args)
