import os
import sys
import re
import xbmc
import xbmcgui
import xbmcvfs
import xbmcplugin
from t0mm0.common.addon import Addon
ADDON_ID = 'plugin.video.icelibrary2'
ADDON = Addon(ADDON_ID,sys.argv)
ADDON_NAME = ADDON.get_name()
VERSION = ADDON.get_version()
def REFRESH():
	xbmc.executebuiltin("Container.Refresh")

def Notify(title, message, image=None):
	if not image:
		vfs = Vfs()
		image = vfs.join(ADDON.get_path(), 'icon.png')
	xbmc.executebuiltin("XBMC.Notification("+title+","+message+",1500,"+image+")")
	#xbmc.executebuiltin("XBMC.Notification("+title+","+message+")")

def removeYear(name):
	if re.search('\\(\\d\\d\\d\\d\\)$', name):
		name=name[0:len(name)-7]
		name = name.strip()
	return name


class Vfs:
	def __init__(self, root='/', debug=False):
		self.debug = debug
		self.root = root
	
	def _resolve_path(self, path):
		return path.replace('/', os.sep)	

	def confirm(self, msg='', msg2='', msg3=''):
		dialog = xbmcgui.Dialog()
		return dialog.yesno(msg, msg2, msg3)

	def open(self, path, mode='r'):
		try:
			return xbmcvfs.File(path, mode)
		except Exception, e:
			xbmc.log('******** VFS error: %s' % e)
			return False

	def touch(self, path):
		try:
			if self.exists(path):
				self.open(path, 'r')
				return True
			else:
				self.open(path, 'w')
				return True
		except Exception, e:
			xbmc.log('******** VFS error: %s' % e)
			return False

	def exists(self, path):
		return xbmcvfs.exists(path)

	def ls(self, path):
		try:
			return xbmcvfs.listdir(path)
		except Exception, e:
			xbmc.log('******** VFS error: %s' % e)
			return False

	def mkdir(self, path, recursive=False):
		if self.exists(path):
			if self.debug:
				xbmc.log('******** VFS mkdir notice: %s exists' % path)
			return False
		if recursive:
			try:
				return xbmcvfs.mkdirs(path)
			except Exception, e:
				xbmc.log('******** VFS error: %s' % e)
				return False
		else:
			try:
				return xbmcvfs.mkdir(path)
			except Exception, e:
				xbmc.log('******** VFS error: %s' % e)
				return False

	def rmdir(self, path, quiet=False):
		if not self.exists(path):
			if self.debug:
				xbmc.log('******** VFS rmdir notice: %s does not exist' % path)
			return False
		if not quiet:
			msg = 'Remove Directory'
			msg2 = 'Please confirm directory removal!'
			if not self.confirm(msg, msg2, path): return False
		try:		
			xbmcvfs.rmdir(path)
		except Exception, e:
			xbmc.log('******** VFS error: %s' % e)

	def rm(self, path, quiet=False, recursive=False):
		if not self.exists(path):
			if self.debug:
				xbmc.log('******** VFS rmdir notice: %s does not exist' % path)
			return False
		if not quiet:
			msg = 'Confirmation'
			msg2 = 'Please confirm directory removal!'
			if not self.confirm(msg, msg2, path): return False

		if not recursive:
			try:
				xbmcvfs.delete(path)
			except Exception, e:
				xbmc.log('******** VFS error: %s' % e)
		else:
			dirs,files = self.ls(path)
			for f in files:
				rm = os.path.join(xbmc.translatePath(path), f)
				try:
					xbmcvfs.delete(rm)
				except Exception, e:
					xbmc.log('******** VFS error: %s' % e)
			for d in dirs:
				subdir = os.path.join(xbmc.translatePath(path), d)
				self.rm(subdir, quiet=True, recursive=True)
			try:			
				xbmcvfs.rmdir(path)
			except Exception, e:
				xbmc.log('******** VFS error: %s' % e)
	def cp(self, src, dest):
		pass

	def mv(self, src, dest):
		pass

	def join(self, path,filename):
		path = path.replace('/', os.sep)
		translatedpath = os.path.join(xbmc.translatePath( path ), ''+filename+'')
		return translatedpath
		

def CleanFileName(s, remove_year, use_encoding = False, use_blanks = True):
	if remove_year:
		s = s[0:len(s)-7]
	s = s.replace(' (Eng subs)', '')
	s = s.replace(' (eng subs)', '')
	s = s.replace(' (English subs)', '')
	s = s.replace(' (english subs)', '')
	s = s.replace(' (Eng Subs)', '')
	s = s.replace(' (English Subs)', '')
	s = s.replace('&#x26;', '&')
	s = s.replace('&#x27;', '\'')
	s = s.replace('&#xC6;', 'AE')
	s = s.replace('&#xC7;', 'C')
	s = s.replace('&#xF4;', 'o')
	s = s.replace('&#xE9;', 'e')
	s = s.replace('&#xEB;', 'e')
	s = s.replace('&#xED;', 'i')
	s = s.replace('&#xEE;', 'i')
	s = s.replace('&#xA2;', 'c')
	s = s.replace('&#xE2;', 'a')
	s = s.replace('&#xEF;', 'i')
	s = s.replace('&#xE1;', 'a')
	s = s.replace('&#xE8;', 'e')
	s = s.replace('%2E', '.')
	if use_encoding:
		s = s.replace('"', '%22')
		s = s.replace('*', '%2A')
		s = s.replace('/', '%2F')
		s = s.replace(':', ',')
		s = s.replace('<', '%3C')
		s = s.replace('>', '%3E')
		s = s.replace('?', '%3F')
		s = s.replace('\\', '%5C')
		s = s.replace('|', '%7C')
		s = s.replace('&frac12;', '%BD')
		s = s.replace('&#xBD;', '%BD') #half character
		s = s.replace('&#xB3;', '%B3')
		s = s.replace('&#xB0;', '%B0') #degree character		
	if use_blanks:
		s = s.replace('"', ' ')
		s = s.replace('*', ' ')
		s = s.replace('/', ' ')
		s = s.replace(':', ' ')
		s = s.replace('<', ' ')
		s = s.replace('>', ' ')
		s = s.replace('?', ' ')
		s = s.replace('\\', ' ')
		s = s.replace('|', ' ')
		s = s.replace('&frac12;', ' ')
		s = s.replace('&#xBD;', ' ') #half character
		s = s.replace('&#xB3;', ' ')
		s = s.replace('&#xB0;', ' ') #degree character
		s = s.replace('  ', ' ')
	s = s.strip()
	return s

class TextBox:
	# constants
	WINDOW = 10147
	CONTROL_LABEL = 1
	CONTROL_TEXTBOX = 5

	def __init__( self, *args, **kwargs):
		# activate the text viewer window
		xbmc.executebuiltin( "ActivateWindow(%d)" % ( self.WINDOW, ) )
		# get window
		self.window = xbmcgui.Window( self.WINDOW )
		# give window time to initialize
		xbmc.sleep( 500 )


	def setControls( self ):
		#get header, text
		heading, text = self.message
		# set heading
		self.window.getControl( self.CONTROL_LABEL ).setLabel( "%s - %s v%s" % ( heading, ADDON_NAME, VERSION) )
		# set text
		self.window.getControl( self.CONTROL_TEXTBOX ).setText( text )

	def show(self, heading, text):
		# set controls

		self.message = heading, text
		self.setControls()

class MPlayer (xbmc.Player):
	def __init__ (self,  *args):
		xbmc.Player.__init__(self)
		pass

	def play(self, url, seekTime=0, metadata={'title': '', 'icon': '', 'thumb': '', 'url': ''}):
		metadata['url'] = url
		#self._seek = seekTime
		#self.metadata=metadata
		#self._tTime=0
		#self._cTime=0
		listitem = xbmcgui.ListItem(metadata['title'], iconImage=metadata['icon'], thumbnailImage=metadata['thumb'], path=metadata['url'])
		listitem.setProperty('IsPlayable', 'true')
		listitem.setPath(metadata['url'])
		xbmcplugin.setResolvedUrl(int(sys.argv[ 1 ]),True,listitem)

	def isplaying(self):
		xbmc.Player.isPlaying(self)

	def onPlayBackStarted(self):
		print 'Now im playing... '
		#xbmc.Player().seekTime(self._seek)

	def onPlayBackEnded(self):
		print "Now imNow imEnded "

	def onPlayBackStopped(self):
		print "Now im Stopped "


	def markWatched(self):
		print "mark watched"	
