import os
import re
import urllib
from htmlentitydefs import name2codepoint
from traceback import print_exc
import time
import cookielib
import xbmc
import xbmcgui
import urllib2
from BeautifulSoup import BeautifulSoup

__useragent__ = "Mozilla/5.0 (Windows; U; Windows NT 5.1; fr; rv:1.9.0.1) Gecko/2008070208 Firefox/3.0.1"

class Browser :
    
    cj = None
    opener = None
    cookiewrong = False
    
    def __init__(self, cookiefile):
        self.cookiefile = cookiefile
        self.cj = cookielib.LWPCookieJar(self.cookiefile)
        if os.path.exists(self.cookiefile):
            self.cj.load()
        self.opener = urllib2.build_opener(urllib2.HTTPCookieProcessor(self.cj))
        
    def login(self, addon, url, removeCookie=False):
        if removeCookie and os.path.exists(self.cookiefile):
            os.remove(self.cookiefile)
            self.cj.load()
        status = False
        data = urllib.urlencode({"query" : "", 'connectionLogin':addon.getSetting('username'), 'connectionPassword':addon.getSetting('password'), 'submit':'Valider'})
        try:
            response = self.opener.open(url, data)
            htmlsource = unicode(response.read(), 'utf-8', 'replace')
            response.close()
            soup = BeautifulSoup(htmlsource)
            metaRefresh = soup.find('meta', attrs={"http-equiv": "Refresh"})
            if metaRefresh is None:
                info("Mangas-TV -> Login failed!")
                status = False
            else :
                info("Mangas-TV -> Login OK!")
                self.cj.save()
                status = True
            if status == True:
                addon.setSetting("prev_username", addon.getSetting('username'))
                addon.setSetting("prev_password", addon.getSetting('password'))
        except:
            ex = 'XBMC.Notification("Server Error:","Please try again.", 3000)'
            xbmc.executebuiltin(ex)
            
        return status
    
    def downloadHTML(self, url):
        self.opener.addheaders = [('User-Agent', __useragent__)]
        try:
            resp = self.opener.open(url)
            htmlsource = resp.read()
            resp.close()
            htmlsource = unicode(htmlsource, 'utf-8', 'replace')
            soup = BeautifulSoup(htmlsource)
            msgPrive = soup.find('div', attrs={ "id" : "barreTop"}).find('a', attrs={ "href": "index.php?module=forumtv&action=forum&mp"})
            if not msgPrive:
                self.cookiewrong = True
            self.cj.save()
            return htmlsource
        except:
            print_exc()
            info("impossible d'ouvrir la page %s" % url)
            return ""

    def downloadFile(self, url, dest):

        def _pbhook(numblocks, blocksize, filesize, url=None, dp=None):
            try:
                percent = min((numblocks * blocksize * 100) / filesize, 100)
                dp.update(percent)
            except:
                percent = 100
                dp.update(percent)
            if dp.iscanceled(): 
                print "DOWNLOAD CANCELLED" # need to get this part working
                raise KeyboardInterrupt
                dp.close()
        
        dp = xbmcgui.DialogProgress()
        dp.create("Mangas-TV.com", "Downloading File", url)
        try:
            urllib.urlretrieve(url, dest, lambda nb, bs, fs, url=url: _pbhook(nb, bs, fs, url, dp))
        except:
            info("KeyboardInterrupt")
            os.remove(dest);
     
 
def debug(logLine):
    if os.environ.has_key("debug.mangastv"):
        print "[Mangas-TV] [DEBUG] %s" % logLine

def info(logline):
    print "[Mangas-TV] [INFO] %s" % logline

def unescapeHTMLchar(fullString):
    match = re.search("&(#\d+|#x[0-9a-fA-F]+|\w+);", fullString)
    while match is not None:
        toReplace = match.group(1)
        repl = unichr(name2codepoint[toReplace])
        fullString = re.sub(match.group(0), repl, fullString)
        match = re.search("&(#\d+|#x[0-9a-fA-F]+|\w+);", fullString)
    return fullString

def isCacheValid(cachefile, max_age=24 * 3600):
    if os.path.exists(cachefile):
        cache_modified_time = os.stat(cachefile).st_mtime
        time_now = time.time()
        if cache_modified_time < time_now - max_age:
            return False
        else:
            return True
    else:
        return False

def is_number(s):
    try:
        float(s)
        return True
    except ValueError:
        return False

def _get_keyboard(default="", heading="", hidden=False):
    """ shows a keyboard and returns a value """
    keyboard = xbmc.Keyboard(default, heading, hidden)
    keyboard.doModal()
    if (keyboard.isConfirmed()):
        return unicode(keyboard.getText(), "utf-8")
    return default
