
import os
import xbmcvfs

import sfile


import ottplanner_utils as utils


def FixPIDs():
    recordings = utils.LoadRecordings()

    for key in recordings:
        recordings[key]['pid'] = 0

    utils.SaveRecordings(recordings)


def CleanRecordings():
    current, dirs, files = sfile.walk(utils.RECORDINGS)
    for dir in dirs:
        dir = os.path.join(current, dir)
        try:    xbmcvfs.rmdir(dir)
        except: pass


def Go():
    FixPIDs()
    CleanRecordings()


Go()
