# -*- coding: utf-8 -*-
#
#      Copyright (C) 2016 SportsAccess.se
#

import datetime
import pytz


def timestampToDate(timestamp):
    utc = pytz.utc
    day_date = datetime.datetime.fromtimestamp(float(timestamp))
    local_tz = pytz.timezone('US/Eastern')
    dt_aware = local_tz.localize(day_date)
    dt_utc_aware = dt_aware.astimezone(utc)
    day_date = dt_utc_aware.replace(tzinfo=None) - dt_utc_aware.utcoffset()
    return day_date.replace(hour=0, minute=0).strftime('%Y-%m-%d')
