import urllib, urllib2, sys, re, urlparse, re, xbmcplugin, xbmcgui, xbmcaddon, datetime, os

base_url = sys.argv[0]
addon_handle = int(sys.argv[1])
args = urlparse.parse_qs(sys.argv[2][1:])
addonid = 'plugin.video.topdocumentaryfilmscom'
addon = xbmcaddon.Addon(id='plugin.video.topdocumentaryfilmscom')


def GetAddonInfo():
    dict = {}
    dict["id"] = addonid
    dict["addon"] = xbmcaddon.Addon(addonid)
    dict["language"] = dict["addon"].getLocalizedString
    dict["version"] = dict["addon"].getAddonInfo("version")
    dict["path"] = dict["addon"].getAddonInfo("path")
    dict["profile"] = xbmc.translatePath(dict["addon"].getAddonInfo('profile'))
    return dict


def TopLevelCategories():
    AddToMenu('[COLOR white] Documentary Categories [/COLOR]', 'url', 9, addon.getAddonInfo('icon'), '', '')
    AddToMenu('[COLOR white] Highest Rated [/COLOR]', 'url', 8, addon.getAddonInfo('icon'), '', '')
    AddToMenu('[COLOR white] Recently Added [/COLOR]', 'url', 5, addon.getAddonInfo('icon'), '', '')
    AddToMenu('[COLOR white] Most Voted [/COLOR]', 'url', 6, addon.getAddonInfo('icon'), '', '')
    AddToMenu('[COLOR white] Most Shared [/COLOR]', 'url', 7, addon.getAddonInfo('icon'), '', '')
    AddToMenu('[COLOR white] By Year [/COLOR]', 'url', 10, addon.getAddonInfo('icon'), '', '')
    AddToMenu('[COLOR white]-[/COLOR] - [COLOR gold]FEATURED[/COLOR] - [COLOR white]-[/COLOR] ', 'url', 0,
              addon.getAddonInfo('icon'), '', '')

    html = OpenURL('http://topdocumentaryfilms.com/')

    main = re.compile('<main role="main" class="grid-2-3">(.+?)</main>', re.DOTALL).findall(html.replace('amp;', ''))

    for m in main:
        gallery = re.compile('<div class="module clear galery">(.+?)</div>', re.DOTALL).findall(m.replace('amp;', ''))

        for modules in gallery:
            url = ''
            name = ''
            gall = re.compile('\n\n(.+?)\n', re.DOTALL).findall(modules.replace('amp;', ''))
            for module in gall:
                imgs = re.compile('http://cdn.topdocumentaryfilms.com/wp-content/uploads/(.+?)"', re.DOTALL).findall(
                    module.replace('amp;', ''))
                for i in imgs:
                    img = "http://cdn.topdocumentaryfilms.com/wp-content/uploads/" + i

                info = re.compile(
                    '<a href="http://topdocumentaryfilms.com/(.+?)/" title="(.+?)">', re.DOTALL).findall(
                    module.replace('amp;', ''))
                for u, n in info:
                    url = u
                    name = '[COLOR white]' + n + '[/COLOR]'

                AddToMenu(name.replace('&#039;', ''), url, 2, img, '', '')

        url = ''
        name = ''

        articles = re.compile('<article class="module">(.+?)</article>', re.DOTALL).findall(m.replace('amp;', ''))

        for article in articles:
            url = ''
            name = ''
            imgs = re.compile('http://cdn.topdocumentaryfilms.com/wp-content/uploads/(.+?)"', re.DOTALL).findall(
                article.replace('amp;', ''))
            for i in imgs:
                img = "http://cdn.topdocumentaryfilms.com/wp-content/uploads/" + i

            info = re.compile('<h2><a href="http://topdocumentaryfilms.com/(.+?)/" title="(.+?)">.+?</a></h2>',
                              re.DOTALL).findall(
                article.replace('amp;', ''))

            for u, n in info:
                url = u
                name = '[COLOR white]' + n + '[/COLOR]'
            if len(url) > 0 and len(name) > 0:
                AddToMenu(name.replace('&#039;', ''), url, 2, img, '', '')


def TopLevelYears():
    x = datetime.datetime.now().year
    while x > 1993:
        AddToMenu('[COLOR white] ' + str(x) + ' [/COLOR]', str(x), 11, addon.getAddonInfo('icon'), '', '')
        x = x - 1


xbmcplugin.setContent(addon_handle, 'movies')
addoninfo = GetAddonInfo()
mode = args.get('mode', None)

dt = re.compile('([0-9]{1,2})[/]([0-9]{1,2})[/]([0-9]{4})')


def AddToMenu(name, url, mode, iconimage, description, subtitles_url):
    u = sys.argv[0] + "?url=" + urllib.quote_plus(url) + "&mode=" + str(mode) + "&name=" + urllib.quote_plus(
        name) + "&iconimage=" + urllib.quote_plus(iconimage) + "&description=" + urllib.quote_plus(
        description) + "&subtitles_url=" + urllib.quote_plus(subtitles_url)

    liz = xbmcgui.ListItem(label=name, label2=description, iconImage="DefaultFolder.png", thumbnailImage=iconimage)

    date_string = "09.22.2015"
    liz.setInfo("video",
                infoLabels={"title": name, "plot": description, "plotoutline": description, "date": date_string})
    if mode == 3:
        liz.setProperty("IsPlayable", "true")
        liz.setProperty("IsFolder", "false")
        ok = xbmcplugin.addDirectoryItem(handle=int(sys.argv[1]), url=u, listitem=liz, isFolder=False)
    else:
        liz.setProperty("IsPlayable", "false")
        liz.setProperty("IsFolder", "true")
        ok = xbmcplugin.addDirectoryItem(handle=int(sys.argv[1]), url=u, listitem=liz, isFolder=True)

    liz.setProperty("Property(Addon.Name)", "Top Documentary Films")
    xbmcplugin.setContent(int(sys.argv[1]), 'movies')
    return True


def OpenURL(url):
    req = urllib2.Request(url)
    req.add_header('User-Agent', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:38.0) Gecko/20100101 Firefox/38.0')
    response = urllib2.urlopen(req)
    html = response.read()
    response.close()
    return html


def PlayVideo(name, url, iconimage, description, subtitles_url):
    liz = xbmcgui.ListItem(name, iconImage='DefaultVideo.png', thumbnailImage=iconimage)
    liz.setInfo(type='Video', infoLabels={'Title': name})
    liz.setProperty("IsPlayable", "true")
    liz.setPath(url)
    if subtitles_url and ADDON.getSetting('subtitles') == 'true':
        subtitles_file = download_subtitles(subtitles_url)
    xbmcplugin.setResolvedUrl(int(sys.argv[1]), True, liz)
    if subtitles_url and ADDON.getSetting('subtitles') == 'true':
        # Successfully started playing something?
        while 1:
            if xbmc.Player().isPlaying():
                break;
            else:
                xbmc.sleep(500)
        xbmc.Player().setSubtitles(subtitles_file)


def ListCategories():
    html = OpenURL('http://topdocumentaryfilms.com/')
    match = re.compile('/category/(.+?)/" >(.+?)</a>', re.DOTALL).findall(html.replace('amp;', ''))
    for url, name in match:
        if len(url) > 50:
            url = "911"
            name = "911"
        AddToMenu('[COLOR white]' + name.replace('&#039;', '') + '[/COLOR]', url, 1, addon.getAddonInfo('icon'), '', '')


def AddCategoryEntry(url):
    name = ''
    img = addon.getAddonInfo('icon')
    html = OpenURL('http://topdocumentaryfilms.com/category/' + url)

    articles = re.compile('<article class="module">(.+?)</article>', re.DOTALL).findall(html.replace('amp;', ''))
    for article in articles:
        name = ''
        url = ''
        imgs = re.compile('<img width="95" height="125" src="(.+?)"', re.DOTALL).findall(article.replace('amp;', ''))
        for i in imgs:
            img = i
        descs = re.compile('<p>(.+?)</p>', re.DOTALL).findall(article.replace('amp;', ''))
        for d in descs:
            desc = d
        names = re.compile(
            '<div><a title="(.+?)" href="http://topdocumentaryfilms.com/.+?/">Watch now &rarr;</a></div>',
            re.DOTALL).findall(article.replace('amp;', ''))
        for n in names:
            name = n
        urls = re.compile('<div><a title=".+?" href="http://topdocumentaryfilms.com/(.+?)/">Watch now &rarr;</a></div>',
                          re.DOTALL).findall(article.replace('amp;', ''))
        for u in urls:
            url = u

        stars = re.compile('<span class="archive_rating"><span class="star_color">.+?</span>(.+?)</span>',
                           re.DOTALL).findall(article.replace("amp;", ''))
        for star in stars:
            rating = star + " star"
        if len(url) > 0 and len(name) > 0:
            AddToMenu('[COLOR white]' + name.replace('&#039;', '') + '[/COLOR]    [COLOR gold]' + rating + '[/COLOR]',
                      url,
                      2, img, desc, '')

    page = re.compile('<div class="pagination module">(.+?)</div>',
                      re.DOTALL).findall(html.replace('amp;', ''))

    for inner_code in page:
        pageno = re.compile('<a href="http://topdocumentaryfilms.com/category/(.+?)/page/(.+?)/">Next</a>',
                            re.DOTALL).findall(inner_code.replace('amp;', ''))

    for pname, purl in pageno:
        if purl == '9/11':
            purl = '911'
        AddToMenu("[COLOR green][B] Next >> [/B][/COLOR]", pname + "/page/" + purl, 1, addon.getAddonInfo('icon'), '',
                  '')


def AddByYear(url):
    name = ''
    img = addon.getAddonInfo('icon')
    html = OpenURL('http://topdocumentaryfilms.com/release/' + url)

    articles = re.compile('<article class="module">(.+?)</article>', re.DOTALL).findall(html.replace('amp;', ''))
    for article in articles:
        name = ''
        img = ''
        imgs = re.compile('<img width="95" height="125" src="(.+?)"', re.DOTALL).findall(article.replace('amp;', ''))
        for i in imgs:
            img = i
        descs = re.compile('<p>(.+?)</p>', re.DOTALL).findall(article.replace('amp;', ''))
        for d in descs:
            desc = d
        names = re.compile(
            '<div><a title="(.+?)" href="http://topdocumentaryfilms.com/.+?/">Watch now &rarr;</a></div>',
            re.DOTALL).findall(article.replace('amp;', ''))
        for n in names:
            name = n
        urls = re.compile('<div><a title=".+?" href="http://topdocumentaryfilms.com/(.+?)/">Watch now &rarr;</a></div>',
                          re.DOTALL).findall(article.replace('amp;', ''))
        for u in urls:
            url = u

        stars = re.compile('<span class="archive_rating"><span class="star_color">.+?</span>(.+?)</span>',
                           re.DOTALL).findall(article.replace("amp;", ''))
        for star in stars:
            rating = star + " star"
        if len(url) > 0 and len(name) > 0:
            AddToMenu('[COLOR white]' + name.replace('&#039;', '') + '[/COLOR]    [COLOR gold]' + rating + '[/COLOR]',
                      url,
                      2, img, desc, '')

    page = re.compile('<div class="pagination module">(.+?)</div>',
                      re.DOTALL).findall(html.replace('amp;', ''))

    for inner_code in page:
        pageno = re.compile('<a href="http://topdocumentaryfilms.com/category/(.+?)/page/(.+?)/">Next</a>',
                            re.DOTALL).findall(inner_code.replace('amp;', ''))

    for pname, purl in pageno:
        if purl == '9/11':
            purl = '911'
        AddToMenu("[COLOR green][B] Next >> [/B][/COLOR]", pname + "/page/" + purl, 1, addon.getAddonInfo('icon'), '',
                  '')


def AddVideoEntry(video, name):
    url = ''
    img = ''
    desc = ''
    html = OpenURL('http://topdocumentaryfilms.com/' + video)

    contents = re.compile('<div class=".+?contentpic">(.+?)</div>', re.DOTALL).findall(html.replace('amp;', ''))
    for content in contents:

        imgs = re.compile('http://cdn.topdocumentaryfilms.com/wp-content/uploads/(.+?)"', re.DOTALL).findall(
            content.replace('amp;', ''))
        for i in imgs:
            img = "http://cdn.topdocumentaryfilms.com/wp-content/uploads/" + i
        desc = re.compile('<p>(.+?)</p>', re.DOTALL).findall(content.replace('amp;', ''))[0]
        desc = re.sub('<[^>]*>', '', desc)
        words = desc.split()
    stars = re.compile('<div class="star">(.+?)</div>', re.DOTALL).findall(html.replace("amp;", ''))
    for star in stars:
        rating = star + " star"

    iconimage = xbmc.translatePath(
        os.path.join('special://home/addons/plugin.video.topdocumentaryfilmscom/resources/media/serveimage.jpg'))

    urls = re.compile('<meta itemprop="embedUrl" content="https://www.youtube.com/embed/(.+?)">',
                      re.DOTALL).findall(html.replace('amp;', ''))
    # full length youtube video
    if len(urls) > 0:
        for u in urls:
            url = 'plugin://plugin.video.youtube/play/?video_id=' + u[0:11]

    # viemo video
    if len(url) < 1:
        # <meta itemprop="embedUrl" content="https://player.vimeo.com/video/124682831" />
        urls = re.compile('<meta itemprop="embedUrl" content="https://player.vimeo.com/video/(.+?)" />',
                          re.DOTALL).findall(html.replace('amp;', ''))
        for u in urls:
            url = "plugin://plugin.video.vimeo/play/?video_id=" + u

    # youtube playlist
    if len(url) < 1:
        # <iframe width="100%" height="325" src="http://www.youtube.com/embed/videoseries?list=PLEDAAA3B8EF7543C4" frameborder="0" allowfullscreen=""></iframe>
        urls = re.compile('http://www.youtube.com/embed/videoseries\?list=(.+?) ', re.DOTALL).findall(
            html.replace('amp;', ''))

        for u in urls:
            url = "plugin://plugin.video.youtube/play/?playlist_id=" + u[0:18]

    if len(url) < 1:
        # //www.youtube.com/embed/videoseries?list=PL_IlIlrxhtPMXcWCd_z_UZ6pn8GYPGGlo&iv_load_policy=3&showinfo=0&autohide=1
        urls = re.compile('list=PL_(.+?)_z_', re.DOTALL).findall(
            html.replace('amp;', ''))
        for u in urls:
            url = "plugin://plugin.video.youtube/play/?playlist_id=" + u

    # full length youtube video
    if len(urls) < 1:
        html = OpenURL('https://startpage.com/do/search?query=' + video + '&cat=web&pl=chrome&language=english')
        vids = re.compile('www.youtube.com/watch\?v=(.+?) ', re.DOTALL).findall(html.replace('amp;', ''))
        for vid in vids:
            url = 'plugin://plugin.video.youtube/play/?video_id=' + vid[0:11]
            break

    AddToMenu(name, url, 3, img, desc, '')

    try:  # trying to add some additional data from the page about the movie
        AddToMenu('[COLOR gold]' + rating + '[/COLOR]', url, 3, iconimage, '', '')
        sentence = ''
        AddToMenu(
            '                          [COLOR white]--- [/COLOR] --- [COLOR green] --- MOVIE SUMMARY --- [/COLOR] --- [COLOR white] ---[/COLOR] ',
            url, 3, addon.getAddonInfo('icon'), '', '')

        for word in words:
            sentence = sentence + " " + word
            if len(sentence) > 58:
                AddToMenu('[COLOR white]' + sentence + '[/COLOR]', url, 3, img, '', '')
                sentence = ''
    except:
        print "Unexpected error:", sys.exc_info()[0]


def AddRecentlyAdded():
    html = OpenURL('http://topdocumentaryfilms.com/')
    match = re.compile('<section class="module">\r\n\t<h3>Recently Added</h3>\r\n\t(.+?)</section>', re.DOTALL).findall(
        html.replace('amp;', ''))
    for inner_code in match:
        entries = re.compile('<a href="http://topdocumentaryfilms.com/(.+?)/" title="(.+?)">',
                             re.DOTALL).findall(inner_code.replace('amp;', ''))
    for url, name in entries:
        AddToMenu('[COLOR white]' + name.replace('&#039;', '') + '[/COLOR]', url, 2, '', '', '')


def AddHighestRated():
    html = OpenURL('http://topdocumentaryfilms.com/')
    match = re.compile('<section class="module">\r\n\t<h3>Highest Rated</h3>\r\n\t(.+?)</section>', re.DOTALL).findall(
        html.replace('amp;', ''))
    for inner_code in match:
        entries = re.compile('<a href="http://topdocumentaryfilms.com/(.+?)/" title="(.+?)">',
                             re.DOTALL).findall(inner_code.replace('amp;', ''))
    for url, name in entries:
        AddToMenu('[COLOR white]' + name.replace('&#039;', '') + '[/COLOR]', url, 2, '', '', '')


def AddMostVoted():
    html = OpenURL('http://topdocumentaryfilms.com/')
    match = re.compile('<section class="module">\r\n\t<h3>Most Voted</h3>\r\n\t(.+?)</section>', re.DOTALL).findall(
        html.replace('amp;', ''))
    for inner_code in match:
        entries = re.compile('<a href="http://topdocumentaryfilms.com/(.+?)/" title="(.+?)">',
                             re.DOTALL).findall(inner_code.replace('amp;', ''))
    for url, name in entries:
        AddToMenu('[COLOR white]' + name.replace('&#039;', '') + '[/COLOR]', url, 2, '', '', '')


def AddMostShared():
    html = OpenURL('http://topdocumentaryfilms.com/')
    match = re.compile('<section class="module">\r\n\t<h3>Most Shared</h3>\r\n\t(.+?)</section>', re.DOTALL).findall(
        html.replace('amp;', ''))
    for inner_code in match:
        entries = re.compile('<a href="http://topdocumentaryfilms.com/(.+?)/" title="(.+?)">',
                             re.DOTALL).findall(inner_code.replace('amp;', ''))
    for url, name in entries:
        AddToMenu('[COLOR white]' + name.replace('&#039;', '') + '[/COLOR]', url, 2, '', '', '')


def get_params():
    param = []
    paramstring = sys.argv[2]
    if len(paramstring) >= 2:
        params = sys.argv[2]
        cleanedparams = params.replace('?', '')
        if (params[len(params) - 1] == '/'):
            params = params[0:len(params) - 2]
        pairsofparams = cleanedparams.split('&')
        param = {}
        for i in range(len(pairsofparams)):
            splitparams = {}
            splitparams = pairsofparams[i].split('=')
            if (len(splitparams)) == 2:
                param[splitparams[0]] = splitparams[1]

    return param


params = get_params()
url = None
name = None
mode = None
iconimage = None
description = None
subtitles_url = None

try:
    url = urllib.unquote_plus(params["url"])
except:
    pass
try:
    name = urllib.unquote_plus(params["name"])
except:
    pass
try:
    iconimage = urllib.unquote_plus(params["iconimage"])
except:
    pass
try:
    mode = int(params["mode"])
except:
    pass
try:
    description = urllib.unquote_plus(params["description"])
except:
    pass
try:
    subtitles_url = urllib.unquote_plus(params["subtitles_url"])
except:
    pass

if mode == None or mode == 0 or url == None or len(url) < 1:
    TopLevelCategories()

elif mode == 1:
    AddCategoryEntry(url)

elif mode == 2:
    AddVideoEntry(url, name)

elif mode == 3:
    PlayVideo(name, url, iconimage, description, subtitles_url)

elif mode == 5:
    AddRecentlyAdded()

elif mode == 6:
    AddMostVoted()

elif mode == 7:
    AddMostShared()

elif mode == 8:
    AddHighestRated()

elif mode == 9:
    ListCategories()

elif mode == 10:
    TopLevelYears()

elif mode == 11:
    AddByYear(url)

xbmcplugin.endOfDirectory(int(sys.argv[1]))
