# -*- coding: utf-8 -*-
# Name:        main.py
# Author:      Mancuniancol
# Created on:  28.01.2017
# Licence:     GPL v.3: http://www.gnu.org/copyleft/gpl.html
from parsers import *


def extract_torrents(html=None):
    """
    Parse the HTML to get Torrents
    :param html: html code of the page
    :type html: str or None
    :return: dict
    """
    if html is not None:
        html = " ".join(html.split())
        html = html.replace('</a></td> </tr> <tr> <td', '</a></td><td').replace('</a></td></tr><tr><td', '</a></td><td')
        dom = Html().feed(html)
        row_search = "dom." + get_setting('row_search')
        name_search = get_setting('name_search')
        magnet_search = get_setting('magnet_search')
        info_hash_search = get_setting('info_hash_search')
        size_search = get_setting('size_search')
        seeds_search = get_setting('seeds_search')
        peers_search = get_setting('peers_search')
        if dom is not None:
            for item in eval(row_search):
                if item is not None:
                    name = eval(name_search)  # name
                    magnet = eval(magnet_search) if len(magnet_search) > 0 else ""  # magnet
                    info_hash = eval(info_hash_search) if len(info_hash_search) > 0 else ""  # size
                    size = eval(size_search) if len(size_search) > 0 else ""  # size
                    seeds = eval(seeds_search) if len(seeds_search) > 0 else ""  # seeds
                    peers = eval(peers_search) if len(peers_search) > 0 else ""  # peers
                    yield (name, info_hash, magnet, size, seeds, peers)  # name, info_hash, magnet, size, seeds, peers


def search(info):
    """
    General Search
    :param info: payload
    :type info: dict or None
    :return: torrents
    """
    Filtering.use_general(info)
    return process(generator=extract_torrents)


def search_movie(info):
    """
    Movie Search
    :param info: payload
    :type info: dict or None
    :return: torrents
    """
    Filtering.use_movie(info)
    return process(generator=extract_torrents)


def search_episode(info):
    """
    Episode Search
    :param info: payload
    :type info: dict or None
    :return: torrents
    """
    if info['absolute_number'] == 0:
        Filtering.use_tv(info)
    else:
        Filtering.use_anime(info)
    return process(generator=extract_torrents)


def search_season(info):
    """
    Season Search
    :param info: payload
    :type info: dict or None
    :return: torrents
    """
    Filtering.use_season(info)
    return process(generator=extract_torrents)

# This registers your module for use
register(search, search_movie, search_episode, search_season)
