# This file es votp2ocp.py
#
# (c) 2004. Javier Bezos. License: LPPL.
#
# This file creates otp/ocp files with special
# characters like \, {, }, replaced by characters
# in the PUA area with fixed catcodes. This
# way, verbatim can be used.
#
# The implemtentation is somewhat naive, but it
# works with the Mem otp files.

import unicodedata, re, sys, os

name = sys.argv[1]

def namechar(m):
    result = '@"%04X' % ord(unicodedata.lookup(m.group(1)))
    return result
#end

def repl(m): # ^ must be the first 
    s = m.group(2).replace('^',  '" @"E007 "')\
                  .replace('\\', '" @"E000 "')\
                  .replace('{',  '" @"E001 "')\
                  .replace('}',  '" @"E002 "')\
                  .replace('$',  '" @"E003 "')\
                  .replace('&',  '" @"E004 "')\
                  .replace('#',  '" @"E006 "')\
                  .replace('_',  '" @"E008 "')
    s = '%s"%s"' % (m.group(1), s)
    s = s.replace(' ""', ' ')
    return s
#end

txt = open(name + '.mtp').read()

res = re.sub('([^@`])"([^"]+)"', repl, txt)
res = re.sub('\[([A-Z][\dA-Z \-]*)\]', namechar, res)

# Hacer una abrevitura de LATIN LETTER, ARABIC LETTER, para
# que se anadan si no esta definido.

open(name + '.otp', 'w').write(res)

os.system('otp2ocp ' + name)

try:
    os.remove('%s.otp' % name)
except:
    pass


