#!/bin/sh
#
# This script writes a .tex file which does the necessary work 
# of converting Adobe Font Metric files for a `normal' font family,
# runs fontinst on it, converts the resulting files,
# and installs them in distribution directories.
#
# (c) Sebastian Rahtz February 6th 1994
#                 March 15th 1994
#                 May 5th 1994
#		  May 8th 1994
# ---------------- fontinst first real release -------
#                 June 7th 1994 (switched to \latinfamily)
#                 November 10th 1994 cleaned up expert font handling
#                 February 1995 cleaned again
#                 March 1995, version for new naming scheme and 8r
#                 (PhB changes 25-6-95)
#----------------------------------------------------------------
# The user has to supply the Berry family name, and (optionally) 
# any special code to run when the family is loaded.
# The output is:
#  - three .fd files (one for T1, one for OT1, and one for 8r)
#  - .tfm and .vf files
#  - a file <family>.map (could be appended to psfonts.map (for dvips))
#  - a file config.<family> (for use with dvips, referencing psfonts.<family>)
#  - a file <famname>.sty package file for trivial use of font family
# Intermediate files are deleted.
#
# Options:
#  -download means that the lines written to psfonts.<family> have "<fontname"
#  -sans  means this is a sanserif font
#  -tt means that this is a typewriter family
#  -out [dir] specifies where the results are to go
#  -lucida  means add special code for Lucida scaling
#  -expert means this is to be set up an expert set
#  -nosty means do NOT produce a .sty file
#
# Parameters:
# $1 The family name, eg ptm.
# $2 Extra FD commands to be executed every time the font is loaded.
#    (\hyphenchar\font=-1 is added automatically for tt fonts)
#
# example for Courier:
# psmetrics -tt pcr 
#
# example for Times:
# make-fam-metric ptm 
#-------------------------------------------------------------
# Provide a usage message to refresh human memories.
if test \( $# -lt 1 \) 
then 
  echo "Usage: [-download] [-sans] [-tt] [-out <dir>] family [fd code]"
   exit 1
fi
#
# where to put the results
#
TEXINPUTS=$S/encoding/tools:
OUTDIR=.
RM=rm
MV=mv
#
# defaults
#
MAP=../tools/fontname.map
EXPERT=
EXTRA=
LUCIDA=
DOWNLOAD=
STYLE="x"
TYPE="rm"
TYPEA="r"
while true; do
	case $1 in
	-download)   shift ; DOWNLOAD=y ;;
    -tt)         shift ; TYPE="tt" ;TYPEA="t" ; EXTRA='\hyphenchar\font=-1' ;;
    -sans)       shift ; TYPE="sf" ;TYPEA="s" ;;
	-out)        shift ; OUTDIR=$1 ; shift ;;
    -expert)     shift ; EXPERT="x"  ;;
	-nosty)      shift ; STYLE=  ;;
	-lucida)     shift ; LUCIDA="y"  ;;
	-*) echo $0: illegal option - $1 1>&2; shift;;
	 *) break;;
	esac
done
#
# work out the family name and an 8 character abbreviation
#
# this results in
# $F   3 character family name
# $VAR remainder
# $FF  family name
# $FFF abbreviated family name
#
FX=$1
F=`expr $1 : '^\(...\).*$'`
VAR=`expr $1 : '^...\(.*\)$'`
FF=`grep FontName ${F}*${VAR}*8a*.afm | sed 's/.*FontName //' | sed 's/
//' | sort | uniq | tail -1`
# FF=`grep FamilyName ${F}*.afm | sed 's/.*FamilyName //' | uniq | head -1`
D='$3'
L='$2'
FFF=`awk  '$1 == "'$FF'" {print $2}' ${MAP}`
# FFF=`echo $FF | tr -d ' ' | sed 's/^ITC//' | sed 's/^Bitstream//' | sed 's/Lucida/Luc/' | tr '[A-Z]' '[a-z]' | sed 's/\(........\).*/\1/'`
if test "${FFF}"x = "x" 
then
  echo cannot find short form for ${FF} in ${MAP}
 exit 1
fi
OUT=${OUTDIR}/${FFF}
FFFF=`echo $FF | sed 's/-[A-Z].*//'`
echo work on $F${EXPERT} [$VAR] / $FF / $FFF /$FFFF  "-->" $OUT
echo '%%%% ==================================================' > $F.fti
echo '%%%% 4allTeX fontinst file (PhB)                       '>> $F.fti
echo '%%%% Use phbfonti.sty instead of fontinst.sty          '>> $F.fti
echo '%%%% =================================================='>> $F.fti
echo '%%%% Installation file for fontinst. Feed this file to '>> $F.fti
echo '%%%% plain TeX (emTeX: add -ms 6000 )                  '>> $F.fti
echo '%%%% Output: .pl files: run pltotf on them             '>> $F.fti
echo '%%%%         .vpl files: run vptovf on them            '>> $F.fti
echo '%%%%         .sty file: for 209/NFSS1 and 2e.          '>> $F.fti
echo '%%%%         .fd files: for LaTeX2e font selection.    '>> $F.fti
echo '%%%% Move .tfm to \\emtex\\tfm.                          '>> $F.fti
echo '%%%% Move .sty to \\emtex\\texinput\\nfss                 '>> $F.fti
echo '%%%% Move .fd  to \\emtex\\latex2e\\nfss                  '>> $F.fti
echo '%%%% Nuke .pl, .mtx and .vpl files afterwards.         '>> $F.fti
echo '%%%% =================================================='>> $F.fti
echo '\\nonstopmode                                          '>> $F.fti
# echo '\input fontinst.sty'                                  >> $F.fti
# echo '\latinfamily{'$F${EXPERT}${VAR}'}{'$EXTRA$2'}'        >> $F.fti
echo '\\input phbfonti.sty                                   '>> $F.fti
echo '\\installgenericstyle{'$FFF'}{'$F'}{}{}{'$TYPE'}{}{    '>> $F.fti
echo '\\install_latin_series{r}{}{m}{r}                      '>> $F.fti
echo '\\install_latin_series{b}{}{b}{b}                      '>> $F.fti
echo '}\\bye                                                 '>> $F.fti
#--------------------------------------------------------
# now run TeX with the fontinst macros. could take a while.
# --------------------------------------------------------
tex $F.fti
# --------------------------------------------------------
# convert the ascii .pl and .vpl files to binary
#--------------------------------------------------------
for i in ${F}*0.pl 
do 
 Z=`basename $i .pl`  
 pltotf $Z.pl $Z.tfm   
done    
for i in ${F}*.vpl 
do 
 Z=`basename $i .vpl` 
 vptovf $Z.vpl $Z.vf $Z.tfm  
done
# #--------------------------------------------------------
# echo make up psfonts map entries
# # ---------------------------------------------------
# if test -f ${FX}.map
# then
#  ${RM} ${FX}.map
# fi
# for i in ${F}*8r*.pl
# do
#  echo mapping $i
#  Y=`basename $i .pl`
#  Z=`echo $Y | sed 's/8r/8a/'`
#  echo "Check for a ${Z}.afm?"
#  if test -f ${Z}.afm
#  then
#   X=`grep FontName ${Z}.afm | sed 's/FontName \([A-z0-9\-]*\).*/\1/'`
#   if test "$DOWNLOAD"x != x
#   then
#    echo ${Y} $X "\"TeXBase1Encoding ReEncodeFont\" <8r.enc <"${Z}.pfb >> ${FX}.map
#   else
#    echo ${Y} $X "\"TeXBase1Encoding ReEncodeFont\" <8r.enc" >> ${FX}.map
#   fi
#  fi
# done
# if test "${EXPERT}"x != "x"
# then
#   for i in ${F}*8x*.pl
#   do
#    Z=`basename $i .pl`
#    echo "Check for a $Z.afm?"
#    if test -f ${Z}.afm
#    then
#     X=`grep FontName ${Z}.afm | sed 's/FontName \([A-z0-9\-]*\).*/\1/'`
#     if test "$DOWNLOAD"x != x
#     then
#      echo ${Z} $X  "<"$Z.pfb >> ${FX}.map
#     else
#      echo ${Z} $X >> ${FX}.map
#     fi
#    fi
#   done
# fi
# #
# #
# # locate the faked oblique files
# for i in `grep "Faking oblique " $$${FFF}.log | awk '{print $4":"$6}' | sort | uniq`
# do
#        OBL=`expr $i : '^\(.*\):.*$'`
#        UP=`expr $i : '^.*:\(.*\)8.*$'`
#        SUFFIX=`expr $i : '^.*:.*\(8.*\)$'`
#     echo Fake oblique ${OBL} from ${UP} "+" ${SUFFIX}
#        if test "${SUFFIX}" = "8x"
#        then
#              EXTRA="\" .167 SlantFont \""
#        else
#         SUFFIX=`echo ${SUFFIX} | sed 's/8r/8a/'`
#         EXTRA="\" .167 SlantFont TeXBase1Encoding ReEncodeFont \" <8r.enc"
#        fi
#        X=`grep FontName ${UP}${SUFFIX}.afm | sed 's/FontName \([A-z0-9\-]*\).*/\1/'`
#        if test "$DOWNLOAD"x != x
#        then
#         echo ${OBL} $X $EXTRA "<${UP}${SUFFIX}.pfb" >> ${FX}.map
#        else
#         echo ${OBL} $X $EXTRA >> ${FX}.map
#        fi
# done
# #
# # dvips config file
# #
# echo "p +${FX}.map" > config.${F}
# #
# # LaTeX2e package
# #
# echo '\def\fileversion{1}' > ${EXPERT}${FFF}.sty
# echo '\def\filedate{'`date +%Y/%m/%d`'}' >> ${EXPERT}${FFF}.sty
# echo '\ProvidesPackage{'${EXPERT}${FFF}'}[\filedate\space\fileversion' >> ${EXPERT}${FFF}.sty
# echo ' \space PSNFSS LaTeX2e package loading '${FF}']' >> ${EXPERT}${FFF}.sty
# echo '\renewcommand{\'${TYPE}'default}{'$F${EXPERT}'}' >> ${EXPERT}${FFF}.sty
# echo '\endinput' >> ${EXPERT}${FFF}.sty
# #
# # special case for Lucida scaling
# #
# if test "$LUCIDA"x != "x"
# then
#  for i in *$1.fd
#  do
#     sed 's/DeclareFontShape/DeclareLucidaFontShape/' $i | \
#     sed 's/^\\DeclareFontFam/\\@ifundefined{DeclareLucidaFontShape}{\%|\\def\\DeclareLucidaFontShape#1#2#3#4#5#6{\%|\\DeclareFontShape{#1}{#2}{#3}{#4}{<->#5}{#6}}}{}|\\DeclareFontFam/' | \
#     sed '/sub /s/Lucida//' | \
#     sed 's/^   <-> //' | tr '|' '\012' > /tmp/fd$$
#     ${MV}  /tmp/fd$$ $i
#  done
# fi
#
# and delete the temporary files
#
${RM} $F*.mtx
${RM} $F*.pl
${RM} $F*.vpl
cat > $F.rme <<ENDOFCAT
%%%% ==================================================
%%%% 4allTeX fontinst package (PhB)                       
%%%% Use correct phbfonti.sty instead of fontinst.sty  
%%%% ==================================================
This set of metric files for the ${FF} font family was
created on `date` by Sebastian Rahtz
using Alan Jeffrey's fontinst program with Phons Bloemen's patches
The file ${F}.fti must be run trough phbfonti.sty, to get:
(provided AFM files of ${F} are available.....)
 + .tfm files for use by TeX in old TeX encoding (eg ptmr.tfm)
        Cork TeX encoding (eg ptmrq.tfm)
 + .vf  (virtual font) files for dvi drivers (same names as above)
 + .tfm files for the _raw_ fonts (unencoded, eg ptmr0.tf) for the vf files
 + .fd  (font description) files for use with LaTeX2e
 + .map which lists the raw font names and their full PostScript names. 
        This can be added to eg the psfonts.map file of dvips to ensure 
        that the driver recognizes the names as those of PostScript fonts
 + .sty LaTeX2e package ${FFF}.sty to use the new font family
        as appropriate for its type (as roman, sans or typewriter font)
 + a dvips config file config.${F} which can be used to tell dvips
   about the new fonts if you do not want to change the default psfonts.map
   (usage: dvips -P${F} to tell dvips about the ${FF} fonts)
ENDOFCAT
# #
# # install the files in subdirectories
# #
# if test ! -d ${OUT}
# then
#    mkdir ${OUT}
#    mkdir ${OUT}/afm
#    mkdir ${OUT}/vf
#    mkdir ${OUT}/tfm
#    mkdir ${OUT}/tex
#    mkdir ${OUT}/dvips
# fi
# #
# # we have generated some intermediate 8a .pl files, which
# # got turned into tfm files. zap them.
# #
# ${RM} *8a*.tfm
# for i in tfm vf
# do
#     ${MV}  *.$i ${OUT}/$i
# done
# #
# # install the fd and sty files
# #
# ${MV}  *.fd ${OUT}/tex
# if test "$STYLE"x != "x"
# then
#   ${MV}  *.sty ${OUT}/tex
# else
#   ${RM} *.sty
# fi
# #
# # afm files
# #
# echo copy AFM files: ${F}*${VAR}8a*.afm
# cp ${F}*${VAR}8a*.afm ${OUT}/afm
# if test "${EXPERT}"x != "x"
# then
#     cp ${F}*${VAR}8x.afm ${OUT}/afm
# fi
# #
# # config and map files
# #
# cat config.${F} >> ${OUT}/dvips/config.${F}
# ${RM}  config.${F}
# cat  ${FX}.map >> ${OUT}/dvips/${FX}.map
# ${RM} ${FX}.map
# cat  ${F}.rme >> ${OUT}/${F}.rme
# ${RM} ${F}.rme
# #
# # now we have to fix the silly OML and OMS files. bleeargh.
# #
# echo make OMS and OML fd files for ${FX}
# #
# cat > $OUT/tex/OMS${FX}.fd <<ENDOFCAT
# \ProvidesFile{OMS${FX}.fd}
# \DeclareFontFamily{OMS}{cmsy}{\skewchar\font'60}
# \DeclareFontShape{OMS}{${FX}}{m}{n}
#    {<-> ssub * cmsy/m/n}{}
# \DeclareFontShape{OMS}{${FX}}{m}{it}
#    {<-> ssub * cmsy/m/n}{}
# \DeclareFontShape{OMS}{${FX}}{m}{sl}
#    {<-> ssub * cmsy/m/n}{}
# \DeclareFontShape{OMS}{${FX}}{m}{sc}
#    {<-> ssub * cmsy/m/n}{}
# \DeclareFontShape{OMS}{${FX}}{b}{n}
#    {<-> ssub * cmsy/b/n}{}
# \DeclareFontShape{OMS}{${FX}}{b}{it}
#    {<-> ssub * cmsy/b/n}{}
# \DeclareFontShape{OMS}{${FX}}{b}{sl}
#    {<-> ssub * cmsy/b/n}{}
# \DeclareFontShape{OMS}{${FX}}{b}{sc}
#    {<-> ssub * cmsy/b/n}{}
# \endinput
# ENDOFCAT
# cat > $OUT/tex/OML${FX}.fd <<ENDOFCAT
# \ProvidesFile{OML${FX}.fd}
# \DeclareFontFamily{OML}{cmm}{\skewchar\font'177}
# \DeclareFontShape{OML}{${FX}}{m}{n}
#    {<-> ssub * cmm/m/it}{}
# \DeclareFontShape{OML}{${FX}}{m}{it}
#    {<-> ssub * cmm/m/it}{}
# \DeclareFontShape{OML}{${FX}}{m}{sl}
#    {<-> ssub * cmm/m/it}{}
# \DeclareFontShape{OML}{${FX}}{m}{sc}
#    {<-> ssub * cmm/m/it}{}
# \DeclareFontShape{OML}{${FX}}{b}{n}
#    {<-> ssub * cmm/b/it}{}
# \DeclareFontShape{OML}{${FX}}{b}{it}
#    {<-> ssub * cmm/b/it}{}
# \DeclareFontShape{OML}{${FX}}{b}{sl}
#    {<-> ssub * cmm/b/it}{}
# \DeclareFontShape{OML}{${FX}}{b}{sc}
#    {<-> ssub * cmm/b/it}{}
# \endinput
# ENDOFCAT





