#define DEBUG

#include "../core/core.h"


//#include "blsat.h"
//#include "admin.h"
//#include "application.h"
#include "cmdlink.h"


//------------------------------------------------------------------------------
//
//------------------------------------------------------------------------------
C_CmdLink::C_CmdLink(handle hLogger) : C_Socket(hLogger)
{
	m_hLog = hLogger;
	m_bLinkOk = false;
}

//------------------------------------------------------------------------------
//
//------------------------------------------------------------------------------
int C_CmdLink::Open()
{
	int iRc = C_Socket::Open(SOCK_STREAM);

	if(!iRc)
	{
		iRc = Connect("vls", "8888");
		printf("iRc: %d\n", iRc);
		if (iRc < 0)
			iRc = GEN_ERR;
	}

	if(!iRc)
	{
		m_bLinkOk = true;
		Log(m_hLog, LOG_NOTE, "Connected to Vls");
		WriteString("LOGIN_REQUEST VlSat VlSat 0.0");
		printf("Login request sent\n");
		if (!m_bLinkOk)
			iRc = GEN_ERR;
	}

	if (!iRc)
	{
		C_String strAnswer = ReadString();
		if (!m_bLinkOk)
			iRc = GEN_ERR;
		else
		{
			printf("Login answer : %s\n", (const char*)strAnswer);
			if (strAnswer == "LOGIN_ANSWER OK")
			{
				Log(m_hLog, LOG_NOTE, "VlSat has loggued in Vls");
				iRc = NO_ERR;
			}
			else
				iRc = GEN_ERR;
		}
	}

	return iRc;
}

//------------------------------------------------------------------------------
//
//------------------------------------------------------------------------------
void C_CmdLink::Close()
{
	m_bLinkOk = false;
	C_Socket::Close();
}

//------------------------------------------------------------------------------
//
//------------------------------------------------------------------------------
bool C_CmdLink::IsLinkOk()
{
	return m_bLinkOk;
}

//------------------------------------------------------------------------------
//
//------------------------------------------------------------------------------
C_String C_CmdLink::ReadString()
{
	ASSERT(m_bLinkOk);

	byte bBuf[2];
	bBuf[1] = 0;
	C_String str;
	int iRc = 0;
	do
	{
		iRc = Read(bBuf, 1);
		if ((bBuf[0] != '\0') && (iRc == 1))
			str += (char*)bBuf;
	} while ((bBuf[0] != 0) && (iRc == 1));
	if (iRc != 1)
	{
		//Link error
		Log(m_hLog, LOG_ERROR, "Link error");
		str = "";
		m_bLinkOk = false;
	}
	printf("ReadString : %s\n", (const char*)str);
	return str;
}

//------------------------------------------------------------------------------
//
//------------------------------------------------------------------------------
void C_CmdLink::WriteString(const C_String& str)
{
	ASSERT(m_bLinkOk);

	printf("WriteString : %s\n", (const char*)str);

	int iRc = Write((const byte*)(const char*)str,
					str.Length() + 1);
	if (iRc != (int)(str.Length() + 1))
	{
		Log(m_hLog, LOG_ERROR, "Unable to write string");
		m_bLinkOk = false;
	}
}
