/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.text;

import java.text.DecimalFormatSymbols;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import org.apache.commons.lang3.AbstractLangTest;
import org.apache.commons.lang3.LangAssertions;
import org.apache.commons.lang3.text.StrBuilder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@Deprecated
class StrBuilderAppendInsertTest
extends AbstractLangTest {
    private static final String SEP = System.lineSeparator();
    private static final Object FOO = new Object(){

        public String toString() {
            return "foo";
        }
    };

    StrBuilderAppendInsertTest() {
    }

    @Test
    void testAppend_Boolean() {
        StrBuilder sb = new StrBuilder();
        sb.append(true);
        Assertions.assertEquals((Object)"true", (Object)sb.toString());
        sb.append(false);
        Assertions.assertEquals((Object)"truefalse", (Object)sb.toString());
        sb.append('!');
        Assertions.assertEquals((Object)"truefalse!", (Object)sb.toString());
    }

    @Test
    void testAppend_CharArray() {
        StrBuilder sb = new StrBuilder();
        sb.setNullText("NULL").append((char[])null);
        Assertions.assertEquals((Object)"NULL", (Object)sb.toString());
        sb = new StrBuilder();
        sb.append(new char[0]);
        Assertions.assertEquals((Object)"", (Object)sb.toString());
        sb.append(new char[]{'f', 'o', 'o'});
        Assertions.assertEquals((Object)"foo", (Object)sb.toString());
    }

    @Test
    void testAppend_CharArray_int_int() {
        StrBuilder sb = new StrBuilder();
        sb.setNullText("NULL").append((char[])null, 0, 1);
        Assertions.assertEquals((Object)"NULL", (Object)sb.toString());
        sb = new StrBuilder();
        sb.append(new char[]{'f', 'o', 'o'}, 0, 3);
        Assertions.assertEquals((Object)"foo", (Object)sb.toString());
        StrBuilder sb1 = sb;
        LangAssertions.assertIndexOutOfBoundsException(() -> sb1.append(new char[]{'b', 'a', 'r'}, -1, 1), "append(char[], -1,) expected IndexOutOfBoundsException");
        LangAssertions.assertIndexOutOfBoundsException(() -> sb1.append(new char[]{'b', 'a', 'r'}, 3, 1), "append(char[], 3,) expected IndexOutOfBoundsException");
        LangAssertions.assertIndexOutOfBoundsException(() -> sb1.append(new char[]{'b', 'a', 'r'}, 1, -1), "append(char[],, -1) expected IndexOutOfBoundsException");
        LangAssertions.assertIndexOutOfBoundsException(() -> sb1.append(new char[]{'b', 'a', 'r'}, 1, 3), "append(char[], 1, 3) expected IndexOutOfBoundsException");
        LangAssertions.assertIndexOutOfBoundsException(() -> sb1.append(new char[]{'b', 'a', 'r'}, -1, 3), "append(char[], -1, 3) expected IndexOutOfBoundsException");
        LangAssertions.assertIndexOutOfBoundsException(() -> sb1.append(new char[]{'b', 'a', 'r'}, 4, 0), "append(char[], 4, 0) expected IndexOutOfBoundsException");
        sb.append(new char[]{'b', 'a', 'r'}, 3, 0);
        Assertions.assertEquals((Object)"foo", (Object)sb.toString());
        sb.append(new char[]{'a', 'b', 'c', 'b', 'a', 'r', 'd', 'e', 'f'}, 3, 3);
        Assertions.assertEquals((Object)"foobar", (Object)sb.toString());
    }

    @Test
    void testAppend_FormattedString() {
        StrBuilder sb = new StrBuilder();
        sb.append("Hi", (Object[])null);
        Assertions.assertEquals((Object)"Hi", (Object)sb.toString());
        sb = new StrBuilder();
        sb.append("Hi", new Object[]{"Alice"});
        Assertions.assertEquals((Object)"Hi", (Object)sb.toString());
        sb = new StrBuilder();
        sb.append("Hi %s", new Object[]{"Alice"});
        Assertions.assertEquals((Object)"Hi Alice", (Object)sb.toString());
        sb = new StrBuilder();
        sb.append("Hi %s %,d", new Object[]{"Alice", 5000});
        char groupingSeparator = DecimalFormatSymbols.getInstance().getGroupingSeparator();
        String expected = "Hi Alice 5" + groupingSeparator + "000";
        Assertions.assertEquals((Object)expected, (Object)sb.toString());
    }

    @Test
    void testAppend_Object() {
        StrBuilder sb = new StrBuilder();
        sb.appendNull();
        Assertions.assertEquals((Object)"", (Object)sb.toString());
        sb.append(null);
        Assertions.assertEquals((Object)"", (Object)sb.toString());
        sb.append(FOO);
        Assertions.assertEquals((Object)"foo", (Object)sb.toString());
        sb.append((StringBuffer)null);
        Assertions.assertEquals((Object)"foo", (Object)sb.toString());
        sb.append(new StringBuffer("baz"));
        Assertions.assertEquals((Object)"foobaz", (Object)sb.toString());
        sb.append(new StrBuilder("yes"));
        Assertions.assertEquals((Object)"foobazyes", (Object)sb.toString());
        sb.append((CharSequence)"Seq");
        Assertions.assertEquals((Object)"foobazyesSeq", (Object)sb.toString());
        sb.append(new StringBuilder("bld"));
        Assertions.assertEquals((Object)"foobazyesSeqbld", (Object)sb.toString());
    }

    @Test
    void testAppend_PrimitiveNumber() {
        StrBuilder sb = new StrBuilder();
        sb.append(0);
        Assertions.assertEquals((Object)"0", (Object)sb.toString());
        sb.append(1L);
        Assertions.assertEquals((Object)"01", (Object)sb.toString());
        sb.append(2.3f);
        Assertions.assertEquals((Object)"012.3", (Object)sb.toString());
        sb.append(4.5);
        Assertions.assertEquals((Object)"012.34.5", (Object)sb.toString());
    }

    @Test
    void testAppend_StrBuilder() {
        StrBuilder sb = new StrBuilder();
        sb.setNullText("NULL").append((StrBuilder)null);
        Assertions.assertEquals((Object)"NULL", (Object)sb.toString());
        sb = new StrBuilder();
        sb.append(new StrBuilder("foo"));
        Assertions.assertEquals((Object)"foo", (Object)sb.toString());
        sb.append(new StrBuilder(""));
        Assertions.assertEquals((Object)"foo", (Object)sb.toString());
        sb.append(new StrBuilder("bar"));
        Assertions.assertEquals((Object)"foobar", (Object)sb.toString());
    }

    @Test
    void testAppend_StrBuilder_int_int() {
        StrBuilder sb = new StrBuilder();
        sb.setNullText("NULL").append((StrBuilder)null, 0, 1);
        Assertions.assertEquals((Object)"NULL", (Object)sb.toString());
        sb = new StrBuilder();
        sb.append(new StrBuilder("foo"), 0, 3);
        Assertions.assertEquals((Object)"foo", (Object)sb.toString());
        StrBuilder sb1 = sb;
        LangAssertions.assertIndexOutOfBoundsException(() -> sb1.append(new StrBuilder("bar"), -1, 1), "append(char[], -1,) expected IndexOutOfBoundsException");
        LangAssertions.assertIndexOutOfBoundsException(() -> sb1.append(new StrBuilder("bar"), 3, 1), "append(char[], 3,) expected IndexOutOfBoundsException");
        LangAssertions.assertIndexOutOfBoundsException(() -> sb1.append(new StrBuilder("bar"), 1, -1), "append(char[],, -1) expected IndexOutOfBoundsException");
        LangAssertions.assertIndexOutOfBoundsException(() -> sb1.append(new StrBuilder("bar"), 1, 3), "append(char[], 1, 3) expected IndexOutOfBoundsException");
        LangAssertions.assertIndexOutOfBoundsException(() -> sb1.append(new StrBuilder("bar"), -1, 3), "append(char[], -1, 3) expected IndexOutOfBoundsException");
        LangAssertions.assertIndexOutOfBoundsException(() -> sb1.append(new StrBuilder("bar"), 4, 0), "append(char[], 4, 0) expected IndexOutOfBoundsException");
        sb.append(new StrBuilder("bar"), 3, 0);
        Assertions.assertEquals((Object)"foo", (Object)sb.toString());
        sb.append(new StrBuilder("abcbardef"), 3, 3);
        Assertions.assertEquals((Object)"foobar", (Object)sb.toString());
    }

    @Test
    void testAppend_String() {
        StrBuilder sb = new StrBuilder();
        sb.setNullText("NULL").append((String)null);
        Assertions.assertEquals((Object)"NULL", (Object)sb.toString());
        sb = new StrBuilder();
        sb.append("foo");
        Assertions.assertEquals((Object)"foo", (Object)sb.toString());
        sb.append("");
        Assertions.assertEquals((Object)"foo", (Object)sb.toString());
        sb.append("bar");
        Assertions.assertEquals((Object)"foobar", (Object)sb.toString());
    }

    @Test
    void testAppend_String_int_int() {
        StrBuilder sb = new StrBuilder();
        sb.setNullText("NULL").append((String)null, 0, 1);
        Assertions.assertEquals((Object)"NULL", (Object)sb.toString());
        sb = new StrBuilder();
        sb.append("foo", 0, 3);
        Assertions.assertEquals((Object)"foo", (Object)sb.toString());
        StrBuilder sb1 = sb;
        LangAssertions.assertIndexOutOfBoundsException(() -> sb1.append("bar", -1, 1), "append(char[], -1,) expected IndexOutOfBoundsException");
        LangAssertions.assertIndexOutOfBoundsException(() -> sb1.append("bar", 3, 1), "append(char[], 3,) expected IndexOutOfBoundsException");
        LangAssertions.assertIndexOutOfBoundsException(() -> sb1.append("bar", 1, -1), "append(char[],, -1) expected IndexOutOfBoundsException");
        LangAssertions.assertIndexOutOfBoundsException(() -> sb1.append("bar", 1, 3), "append(char[], 1, 3) expected IndexOutOfBoundsException");
        LangAssertions.assertIndexOutOfBoundsException(() -> sb1.append("bar", -1, 3), "append(char[], -1, 3) expected IndexOutOfBoundsException");
        LangAssertions.assertIndexOutOfBoundsException(() -> sb1.append("bar", 4, 0), "append(char[], 4, 0) expected IndexOutOfBoundsException");
        sb.append("bar", 3, 0);
        Assertions.assertEquals((Object)"foo", (Object)sb.toString());
        sb.append("abcbardef", 3, 3);
        Assertions.assertEquals((Object)"foobar", (Object)sb.toString());
        sb.append((CharSequence)"abcbardef", 4, 3);
        Assertions.assertEquals((Object)"foobarard", (Object)sb.toString());
    }

    @Test
    void testAppend_StringBuffer() {
        StrBuilder sb = new StrBuilder();
        sb.setNullText("NULL").append((StringBuffer)null);
        Assertions.assertEquals((Object)"NULL", (Object)sb.toString());
        sb = new StrBuilder();
        sb.append(new StringBuffer("foo"));
        Assertions.assertEquals((Object)"foo", (Object)sb.toString());
        sb.append(new StringBuffer(""));
        Assertions.assertEquals((Object)"foo", (Object)sb.toString());
        sb.append(new StringBuffer("bar"));
        Assertions.assertEquals((Object)"foobar", (Object)sb.toString());
    }

    @Test
    void testAppend_StringBuffer_int_int() {
        StrBuilder sb = new StrBuilder();
        sb.setNullText("NULL").append((StringBuffer)null, 0, 1);
        Assertions.assertEquals((Object)"NULL", (Object)sb.toString());
        sb = new StrBuilder();
        sb.append(new StringBuffer("foo"), 0, 3);
        Assertions.assertEquals((Object)"foo", (Object)sb.toString());
        StrBuilder sb1 = sb;
        LangAssertions.assertIndexOutOfBoundsException(() -> sb1.append(new StringBuffer("bar"), -1, 1), "append(char[], -1,) expected IndexOutOfBoundsException");
        LangAssertions.assertIndexOutOfBoundsException(() -> sb1.append(new StringBuffer("bar"), 3, 1), "append(char[], 3,) expected IndexOutOfBoundsException");
        LangAssertions.assertIndexOutOfBoundsException(() -> sb1.append(new StringBuffer("bar"), 1, -1), "append(char[],, -1) expected IndexOutOfBoundsException");
        LangAssertions.assertIndexOutOfBoundsException(() -> sb1.append(new StringBuffer("bar"), 1, 3), "append(char[], 1, 3) expected IndexOutOfBoundsException");
        LangAssertions.assertIndexOutOfBoundsException(() -> sb1.append(new StringBuffer("bar"), -1, 3), "append(char[], -1, 3) expected IndexOutOfBoundsException");
        LangAssertions.assertIndexOutOfBoundsException(() -> sb1.append(new StringBuffer("bar"), 4, 0), "append(char[], 4, 0) expected IndexOutOfBoundsException");
        sb.append(new StringBuffer("bar"), 3, 0);
        Assertions.assertEquals((Object)"foo", (Object)sb.toString());
        sb.append(new StringBuffer("abcbardef"), 3, 3);
        Assertions.assertEquals((Object)"foobar", (Object)sb.toString());
    }

    @Test
    void testAppend_StringBuilder() {
        StrBuilder sb = new StrBuilder();
        sb.setNullText("NULL").append((String)null);
        Assertions.assertEquals((Object)"NULL", (Object)sb.toString());
        sb = new StrBuilder();
        sb.append(new StringBuilder("foo"));
        Assertions.assertEquals((Object)"foo", (Object)sb.toString());
        sb.append(new StringBuilder(""));
        Assertions.assertEquals((Object)"foo", (Object)sb.toString());
        sb.append(new StringBuilder("bar"));
        Assertions.assertEquals((Object)"foobar", (Object)sb.toString());
    }

    @Test
    void testAppend_StringBuilder_int_int() {
        StrBuilder sb = new StrBuilder();
        sb.setNullText("NULL").append((String)null, 0, 1);
        Assertions.assertEquals((Object)"NULL", (Object)sb.toString());
        sb = new StrBuilder();
        sb.append(new StringBuilder("foo"), 0, 3);
        Assertions.assertEquals((Object)"foo", (Object)sb.toString());
        StrBuilder sb1 = sb;
        LangAssertions.assertIndexOutOfBoundsException(() -> sb1.append(new StringBuilder("bar"), -1, 1), "append(StringBuilder, -1,) expected IndexOutOfBoundsException");
        LangAssertions.assertIndexOutOfBoundsException(() -> sb1.append(new StringBuilder("bar"), 3, 1), "append(StringBuilder, 3,) expected IndexOutOfBoundsException");
        LangAssertions.assertIndexOutOfBoundsException(() -> sb1.append(new StringBuilder("bar"), 1, -1), "append(StringBuilder,, -1) expected IndexOutOfBoundsException");
        LangAssertions.assertIndexOutOfBoundsException(() -> sb1.append(new StringBuilder("bar"), 1, 3), "append(StringBuilder, 1, 3) expected IndexOutOfBoundsException");
        LangAssertions.assertIndexOutOfBoundsException(() -> sb1.append(new StringBuilder("bar"), -1, 3), "append(StringBuilder, -1, 3) expected IndexOutOfBoundsException");
        LangAssertions.assertIndexOutOfBoundsException(() -> sb1.append(new StringBuilder("bar"), 4, 0), "append(StringBuilder, 4, 0) expected IndexOutOfBoundsException");
        sb.append(new StringBuilder("bar"), 3, 0);
        Assertions.assertEquals((Object)"foo", (Object)sb.toString());
        sb.append(new StringBuilder("abcbardef"), 3, 3);
        Assertions.assertEquals((Object)"foobar", (Object)sb.toString());
        sb.append(new StringBuilder("abcbardef"), 4, 3);
        Assertions.assertEquals((Object)"foobarard", (Object)sb.toString());
    }

    @Test
    void testAppendAll_Array() {
        StrBuilder sb = new StrBuilder();
        sb.appendAll((Object[])null);
        Assertions.assertEquals((Object)"", (Object)sb.toString());
        sb.clear();
        sb.appendAll(new Object[0]);
        Assertions.assertEquals((Object)"", (Object)sb.toString());
        sb.clear();
        sb.appendAll((Object[])new String[]{"foo", "bar", "baz"});
        Assertions.assertEquals((Object)"foobarbaz", (Object)sb.toString());
        sb.clear();
        sb.appendAll((Object[])new String[]{"foo", "bar", "baz"});
        Assertions.assertEquals((Object)"foobarbaz", (Object)sb.toString());
    }

    @Test
    void testAppendAll_Collection() {
        StrBuilder sb = new StrBuilder();
        sb.appendAll((Iterable)null);
        Assertions.assertEquals((Object)"", (Object)sb.toString());
        sb.clear();
        sb.appendAll((Iterable)Collections.EMPTY_LIST);
        Assertions.assertEquals((Object)"", (Object)sb.toString());
        sb.clear();
        sb.appendAll(Arrays.asList("foo", "bar", "baz"));
        Assertions.assertEquals((Object)"foobarbaz", (Object)sb.toString());
    }

    @Test
    void testAppendAll_Iterator() {
        StrBuilder sb = new StrBuilder();
        sb.appendAll((Iterator)null);
        Assertions.assertEquals((Object)"", (Object)sb.toString());
        sb.clear();
        sb.appendAll(Collections.EMPTY_LIST.iterator());
        Assertions.assertEquals((Object)"", (Object)sb.toString());
        sb.clear();
        sb.appendAll(Arrays.asList("foo", "bar", "baz").iterator());
        Assertions.assertEquals((Object)"foobarbaz", (Object)sb.toString());
    }

    @Test
    void testAppendFixedWidthPadLeft() {
        StrBuilder sb = new StrBuilder();
        sb.appendFixedWidthPadLeft((Object)"foo", -1, '-');
        Assertions.assertEquals((Object)"", (Object)sb.toString());
        sb.clear();
        sb.appendFixedWidthPadLeft((Object)"foo", 0, '-');
        Assertions.assertEquals((Object)"", (Object)sb.toString());
        sb.clear();
        sb.appendFixedWidthPadLeft((Object)"foo", 1, '-');
        Assertions.assertEquals((Object)"o", (Object)sb.toString());
        sb.clear();
        sb.appendFixedWidthPadLeft((Object)"foo", 2, '-');
        Assertions.assertEquals((Object)"oo", (Object)sb.toString());
        sb.clear();
        sb.appendFixedWidthPadLeft((Object)"foo", 3, '-');
        Assertions.assertEquals((Object)"foo", (Object)sb.toString());
        sb.clear();
        sb.appendFixedWidthPadLeft((Object)"foo", 4, '-');
        Assertions.assertEquals((Object)"-foo", (Object)sb.toString());
        sb.clear();
        sb.appendFixedWidthPadLeft((Object)"foo", 10, '-');
        Assertions.assertEquals((int)10, (int)sb.length());
        Assertions.assertEquals((Object)"-------foo", (Object)sb.toString());
        sb.clear();
        sb.setNullText("null");
        sb.appendFixedWidthPadLeft(null, 5, '-');
        Assertions.assertEquals((Object)"-null", (Object)sb.toString());
    }

    @Test
    void testAppendFixedWidthPadLeft_int() {
        StrBuilder sb = new StrBuilder();
        sb.appendFixedWidthPadLeft(123, -1, '-');
        Assertions.assertEquals((Object)"", (Object)sb.toString());
        sb.clear();
        sb.appendFixedWidthPadLeft(123, 0, '-');
        Assertions.assertEquals((Object)"", (Object)sb.toString());
        sb.clear();
        sb.appendFixedWidthPadLeft(123, 1, '-');
        Assertions.assertEquals((Object)"3", (Object)sb.toString());
        sb.clear();
        sb.appendFixedWidthPadLeft(123, 2, '-');
        Assertions.assertEquals((Object)"23", (Object)sb.toString());
        sb.clear();
        sb.appendFixedWidthPadLeft(123, 3, '-');
        Assertions.assertEquals((Object)"123", (Object)sb.toString());
        sb.clear();
        sb.appendFixedWidthPadLeft(123, 4, '-');
        Assertions.assertEquals((Object)"-123", (Object)sb.toString());
        sb.clear();
        sb.appendFixedWidthPadLeft(123, 10, '-');
        Assertions.assertEquals((int)10, (int)sb.length());
        Assertions.assertEquals((Object)"-------123", (Object)sb.toString());
    }

    @Test
    void testAppendFixedWidthPadRight() {
        StrBuilder sb = new StrBuilder();
        sb.appendFixedWidthPadRight((Object)"foo", -1, '-');
        Assertions.assertEquals((Object)"", (Object)sb.toString());
        sb.clear();
        sb.appendFixedWidthPadRight((Object)"foo", 0, '-');
        Assertions.assertEquals((Object)"", (Object)sb.toString());
        sb.clear();
        sb.appendFixedWidthPadRight((Object)"foo", 1, '-');
        Assertions.assertEquals((Object)"f", (Object)sb.toString());
        sb.clear();
        sb.appendFixedWidthPadRight((Object)"foo", 2, '-');
        Assertions.assertEquals((Object)"fo", (Object)sb.toString());
        sb.clear();
        sb.appendFixedWidthPadRight((Object)"foo", 3, '-');
        Assertions.assertEquals((Object)"foo", (Object)sb.toString());
        sb.clear();
        sb.appendFixedWidthPadRight((Object)"foo", 4, '-');
        Assertions.assertEquals((Object)"foo-", (Object)sb.toString());
        sb.clear();
        sb.appendFixedWidthPadRight((Object)"foo", 10, '-');
        Assertions.assertEquals((int)10, (int)sb.length());
        Assertions.assertEquals((Object)"foo-------", (Object)sb.toString());
        sb.clear();
        sb.setNullText("null");
        sb.appendFixedWidthPadRight(null, 5, '-');
        Assertions.assertEquals((Object)"null-", (Object)sb.toString());
    }

    @Test
    void testAppendFixedWidthPadRight_int() {
        StrBuilder sb = new StrBuilder();
        sb.appendFixedWidthPadRight(123, -1, '-');
        Assertions.assertEquals((Object)"", (Object)sb.toString());
        sb.clear();
        sb.appendFixedWidthPadRight(123, 0, '-');
        Assertions.assertEquals((Object)"", (Object)sb.toString());
        sb.clear();
        sb.appendFixedWidthPadRight(123, 1, '-');
        Assertions.assertEquals((Object)"1", (Object)sb.toString());
        sb.clear();
        sb.appendFixedWidthPadRight(123, 2, '-');
        Assertions.assertEquals((Object)"12", (Object)sb.toString());
        sb.clear();
        sb.appendFixedWidthPadRight(123, 3, '-');
        Assertions.assertEquals((Object)"123", (Object)sb.toString());
        sb.clear();
        sb.appendFixedWidthPadRight(123, 4, '-');
        Assertions.assertEquals((Object)"123-", (Object)sb.toString());
        sb.clear();
        sb.appendFixedWidthPadRight(123, 10, '-');
        Assertions.assertEquals((int)10, (int)sb.length());
        Assertions.assertEquals((Object)"123-------", (Object)sb.toString());
    }

    @Test
    void testAppendln_Boolean() {
        StrBuilder sb = new StrBuilder();
        sb.appendln(true);
        Assertions.assertEquals((Object)("true" + SEP), (Object)sb.toString());
        sb.clear();
        sb.appendln(false);
        Assertions.assertEquals((Object)("false" + SEP), (Object)sb.toString());
    }

    @Test
    void testAppendln_CharArray() {
        final int[] count = new int[2];
        StrBuilder sb = new StrBuilder(this){
            private static final long serialVersionUID = 1L;
            final /* synthetic */ StrBuilderAppendInsertTest this$0;
            {
                this.this$0 = this$0;
            }

            public StrBuilder append(char[] str) {
                count[0] = count[0] + 1;
                return super.append(str);
            }

            public StrBuilder appendNewLine() {
                count[1] = count[1] + 1;
                return super.appendNewLine();
            }
        };
        sb.appendln("foo".toCharArray());
        Assertions.assertEquals((Object)("foo" + SEP), (Object)sb.toString());
        Assertions.assertEquals((int)1, (int)count[0]);
        Assertions.assertEquals((int)1, (int)count[1]);
    }

    @Test
    void testAppendln_CharArray_int_int() {
        final int[] count = new int[2];
        StrBuilder sb = new StrBuilder(this){
            private static final long serialVersionUID = 1L;
            final /* synthetic */ StrBuilderAppendInsertTest this$0;
            {
                this.this$0 = this$0;
            }

            public StrBuilder append(char[] str, int startIndex, int length) {
                count[0] = count[0] + 1;
                return super.append(str, startIndex, length);
            }

            public StrBuilder appendNewLine() {
                count[1] = count[1] + 1;
                return super.appendNewLine();
            }
        };
        sb.appendln("foo".toCharArray(), 0, 3);
        Assertions.assertEquals((Object)("foo" + SEP), (Object)sb.toString());
        Assertions.assertEquals((int)1, (int)count[0]);
        Assertions.assertEquals((int)1, (int)count[1]);
    }

    @Test
    void testAppendln_FormattedString() {
        final int[] count = new int[2];
        StrBuilder sb = new StrBuilder(this){
            private static final long serialVersionUID = 1L;
            final /* synthetic */ StrBuilderAppendInsertTest this$0;
            {
                this.this$0 = this$0;
            }

            public StrBuilder append(String str) {
                count[0] = count[0] + 1;
                return super.append(str);
            }

            public StrBuilder appendNewLine() {
                count[1] = count[1] + 1;
                return super.appendNewLine();
            }
        };
        sb.appendln("Hello %s", new Object[]{"Alice"});
        Assertions.assertEquals((Object)("Hello Alice" + SEP), (Object)sb.toString());
        Assertions.assertEquals((int)2, (int)count[0]);
        Assertions.assertEquals((int)1, (int)count[1]);
    }

    @Test
    void testAppendln_Object() {
        StrBuilder sb = new StrBuilder();
        sb.appendln(null);
        Assertions.assertEquals((Object)("" + SEP), (Object)sb.toString());
        sb.appendln(FOO);
        Assertions.assertEquals((Object)(SEP + "foo" + SEP), (Object)sb.toString());
        sb.appendln((Object)6);
        Assertions.assertEquals((Object)(SEP + "foo" + SEP + "6" + SEP), (Object)sb.toString());
    }

    @Test
    void testAppendln_PrimitiveNumber() {
        StrBuilder sb = new StrBuilder();
        sb.appendln(0);
        Assertions.assertEquals((Object)("0" + SEP), (Object)sb.toString());
        sb.clear();
        sb.appendln(1L);
        Assertions.assertEquals((Object)("1" + SEP), (Object)sb.toString());
        sb.clear();
        sb.appendln(2.3f);
        Assertions.assertEquals((Object)("2.3" + SEP), (Object)sb.toString());
        sb.clear();
        sb.appendln(4.5);
        Assertions.assertEquals((Object)("4.5" + SEP), (Object)sb.toString());
    }

    @Test
    void testAppendln_StrBuilder() {
        final int[] count = new int[2];
        StrBuilder sb = new StrBuilder(this){
            private static final long serialVersionUID = 1L;
            final /* synthetic */ StrBuilderAppendInsertTest this$0;
            {
                this.this$0 = this$0;
            }

            public StrBuilder append(StrBuilder str) {
                count[0] = count[0] + 1;
                return super.append(str);
            }

            public StrBuilder appendNewLine() {
                count[1] = count[1] + 1;
                return super.appendNewLine();
            }
        };
        sb.appendln(new StrBuilder("foo"));
        Assertions.assertEquals((Object)("foo" + SEP), (Object)sb.toString());
        Assertions.assertEquals((int)1, (int)count[0]);
        Assertions.assertEquals((int)1, (int)count[1]);
    }

    @Test
    void testAppendln_StrBuilder_int_int() {
        final int[] count = new int[2];
        StrBuilder sb = new StrBuilder(this){
            private static final long serialVersionUID = 1L;
            final /* synthetic */ StrBuilderAppendInsertTest this$0;
            {
                this.this$0 = this$0;
            }

            public StrBuilder append(StrBuilder str, int startIndex, int length) {
                count[0] = count[0] + 1;
                return super.append(str, startIndex, length);
            }

            public StrBuilder appendNewLine() {
                count[1] = count[1] + 1;
                return super.appendNewLine();
            }
        };
        sb.appendln(new StrBuilder("foo"), 0, 3);
        Assertions.assertEquals((Object)("foo" + SEP), (Object)sb.toString());
        Assertions.assertEquals((int)1, (int)count[0]);
        Assertions.assertEquals((int)1, (int)count[1]);
    }

    @Test
    void testAppendln_String() {
        final int[] count = new int[2];
        StrBuilder sb = new StrBuilder(this){
            private static final long serialVersionUID = 1L;
            final /* synthetic */ StrBuilderAppendInsertTest this$0;
            {
                this.this$0 = this$0;
            }

            public StrBuilder append(String str) {
                count[0] = count[0] + 1;
                return super.append(str);
            }

            public StrBuilder appendNewLine() {
                count[1] = count[1] + 1;
                return super.appendNewLine();
            }
        };
        sb.appendln("foo");
        Assertions.assertEquals((Object)("foo" + SEP), (Object)sb.toString());
        Assertions.assertEquals((int)2, (int)count[0]);
        Assertions.assertEquals((int)1, (int)count[1]);
    }

    @Test
    void testAppendln_String_int_int() {
        final int[] count = new int[2];
        StrBuilder sb = new StrBuilder(this){
            private static final long serialVersionUID = 1L;
            final /* synthetic */ StrBuilderAppendInsertTest this$0;
            {
                this.this$0 = this$0;
            }

            public StrBuilder append(String str, int startIndex, int length) {
                count[0] = count[0] + 1;
                return super.append(str, startIndex, length);
            }

            public StrBuilder appendNewLine() {
                count[1] = count[1] + 1;
                return super.appendNewLine();
            }
        };
        sb.appendln("foo", 0, 3);
        Assertions.assertEquals((Object)("foo" + SEP), (Object)sb.toString());
        Assertions.assertEquals((int)1, (int)count[0]);
        Assertions.assertEquals((int)1, (int)count[1]);
    }

    @Test
    void testAppendln_StringBuffer() {
        final int[] count = new int[2];
        StrBuilder sb = new StrBuilder(this){
            private static final long serialVersionUID = 1L;
            final /* synthetic */ StrBuilderAppendInsertTest this$0;
            {
                this.this$0 = this$0;
            }

            public StrBuilder append(StringBuffer str) {
                count[0] = count[0] + 1;
                return super.append(str);
            }

            public StrBuilder appendNewLine() {
                count[1] = count[1] + 1;
                return super.appendNewLine();
            }
        };
        sb.appendln(new StringBuffer("foo"));
        Assertions.assertEquals((Object)("foo" + SEP), (Object)sb.toString());
        Assertions.assertEquals((int)1, (int)count[0]);
        Assertions.assertEquals((int)1, (int)count[1]);
    }

    @Test
    void testAppendln_StringBuffer_int_int() {
        final int[] count = new int[2];
        StrBuilder sb = new StrBuilder(this){
            private static final long serialVersionUID = 1L;
            final /* synthetic */ StrBuilderAppendInsertTest this$0;
            {
                this.this$0 = this$0;
            }

            public StrBuilder append(StringBuffer str, int startIndex, int length) {
                count[0] = count[0] + 1;
                return super.append(str, startIndex, length);
            }

            public StrBuilder appendNewLine() {
                count[1] = count[1] + 1;
                return super.appendNewLine();
            }
        };
        sb.appendln(new StringBuffer("foo"), 0, 3);
        Assertions.assertEquals((Object)("foo" + SEP), (Object)sb.toString());
        Assertions.assertEquals((int)1, (int)count[0]);
        Assertions.assertEquals((int)1, (int)count[1]);
    }

    @Test
    void testAppendln_StringBuilder() {
        final int[] count = new int[2];
        StrBuilder sb = new StrBuilder(this){
            private static final long serialVersionUID = 1L;
            final /* synthetic */ StrBuilderAppendInsertTest this$0;
            {
                this.this$0 = this$0;
            }

            public StrBuilder append(StringBuilder str) {
                count[0] = count[0] + 1;
                return super.append(str);
            }

            public StrBuilder appendNewLine() {
                count[1] = count[1] + 1;
                return super.appendNewLine();
            }
        };
        sb.appendln(new StringBuilder("foo"));
        Assertions.assertEquals((Object)("foo" + SEP), (Object)sb.toString());
        Assertions.assertEquals((int)1, (int)count[0]);
        Assertions.assertEquals((int)1, (int)count[1]);
    }

    @Test
    void testAppendln_StringBuilder_int_int() {
        final int[] count = new int[2];
        StrBuilder sb = new StrBuilder(this){
            private static final long serialVersionUID = 1L;
            final /* synthetic */ StrBuilderAppendInsertTest this$0;
            {
                this.this$0 = this$0;
            }

            public StrBuilder append(StringBuilder str, int startIndex, int length) {
                count[0] = count[0] + 1;
                return super.append(str, startIndex, length);
            }

            public StrBuilder appendNewLine() {
                count[1] = count[1] + 1;
                return super.appendNewLine();
            }
        };
        sb.appendln(new StringBuilder("foo"), 0, 3);
        Assertions.assertEquals((Object)("foo" + SEP), (Object)sb.toString());
        Assertions.assertEquals((int)1, (int)count[0]);
        Assertions.assertEquals((int)1, (int)count[1]);
    }

    @Test
    void testAppendNewLine() {
        StrBuilder sb = new StrBuilder("---");
        sb.appendNewLine().append("+++");
        Assertions.assertEquals((Object)("---" + SEP + "+++"), (Object)sb.toString());
        sb = new StrBuilder("---");
        sb.setNewLineText("#").appendNewLine().setNewLineText(null).appendNewLine();
        Assertions.assertEquals((Object)("---#" + SEP), (Object)sb.toString());
    }

    @Test
    void testAppendPadding() {
        StrBuilder sb = new StrBuilder();
        sb.append("foo");
        Assertions.assertEquals((Object)"foo", (Object)sb.toString());
        sb.appendPadding(-1, '-');
        Assertions.assertEquals((Object)"foo", (Object)sb.toString());
        sb.appendPadding(0, '-');
        Assertions.assertEquals((Object)"foo", (Object)sb.toString());
        sb.appendPadding(1, '-');
        Assertions.assertEquals((Object)"foo-", (Object)sb.toString());
        sb.appendPadding(16, '-');
        Assertions.assertEquals((int)20, (int)sb.length());
        Assertions.assertEquals((Object)"foo-----------------", (Object)sb.toString());
    }

    @Test
    void testAppendSeparator_char() {
        StrBuilder sb = new StrBuilder();
        sb.appendSeparator(',');
        Assertions.assertEquals((Object)"", (Object)sb.toString());
        sb.append("foo");
        Assertions.assertEquals((Object)"foo", (Object)sb.toString());
        sb.appendSeparator(',');
        Assertions.assertEquals((Object)"foo,", (Object)sb.toString());
    }

    @Test
    void testAppendSeparator_char_char() {
        StrBuilder sb = new StrBuilder();
        int startSeparator = 58;
        int standardSeparator = 44;
        String foo = "foo";
        sb.appendSeparator(',', ':');
        Assertions.assertEquals((Object)String.valueOf(':'), (Object)sb.toString());
        sb.append("foo");
        Assertions.assertEquals((Object)":foo", (Object)sb.toString());
        sb.appendSeparator(',', ':');
        Assertions.assertEquals((Object)":foo,", (Object)sb.toString());
    }

    @Test
    void testAppendSeparator_char_int() {
        StrBuilder sb = new StrBuilder();
        sb.appendSeparator(',', 0);
        Assertions.assertEquals((Object)"", (Object)sb.toString());
        sb.append("foo");
        Assertions.assertEquals((Object)"foo", (Object)sb.toString());
        sb.appendSeparator(',', 1);
        Assertions.assertEquals((Object)"foo,", (Object)sb.toString());
        sb.appendSeparator(',', -1);
        Assertions.assertEquals((Object)"foo,", (Object)sb.toString());
    }

    @Test
    void testAppendSeparator_String() {
        StrBuilder sb = new StrBuilder();
        sb.appendSeparator(",");
        Assertions.assertEquals((Object)"", (Object)sb.toString());
        sb.append("foo");
        Assertions.assertEquals((Object)"foo", (Object)sb.toString());
        sb.appendSeparator(",");
        Assertions.assertEquals((Object)"foo,", (Object)sb.toString());
    }

    @Test
    void testAppendSeparator_String_int() {
        StrBuilder sb = new StrBuilder();
        sb.appendSeparator(",", 0);
        Assertions.assertEquals((Object)"", (Object)sb.toString());
        sb.append("foo");
        Assertions.assertEquals((Object)"foo", (Object)sb.toString());
        sb.appendSeparator(",", 1);
        Assertions.assertEquals((Object)"foo,", (Object)sb.toString());
        sb.appendSeparator(",", -1);
        Assertions.assertEquals((Object)"foo,", (Object)sb.toString());
    }

    @Test
    void testAppendSeparator_String_String() {
        StrBuilder sb = new StrBuilder();
        String startSeparator = "order by ";
        String standardSeparator = ",";
        String foo = "foo";
        sb.appendSeparator(null, null);
        Assertions.assertEquals((Object)"", (Object)sb.toString());
        sb.appendSeparator(",", null);
        Assertions.assertEquals((Object)"", (Object)sb.toString());
        sb.appendSeparator(",", "order by ");
        Assertions.assertEquals((Object)"order by ", (Object)sb.toString());
        sb.appendSeparator(null, null);
        Assertions.assertEquals((Object)"order by ", (Object)sb.toString());
        sb.appendSeparator(null, "order by ");
        Assertions.assertEquals((Object)"order by ", (Object)sb.toString());
        sb.append("foo");
        Assertions.assertEquals((Object)"order by foo", (Object)sb.toString());
        sb.appendSeparator(",", "order by ");
        Assertions.assertEquals((Object)"order by foo,", (Object)sb.toString());
    }

    @Test
    void testAppendWithNullText() {
        StrBuilder sb = new StrBuilder();
        sb.setNullText("NULL");
        Assertions.assertEquals((Object)"", (Object)sb.toString());
        sb.appendNull();
        Assertions.assertEquals((Object)"NULL", (Object)sb.toString());
        sb.append(null);
        Assertions.assertEquals((Object)"NULLNULL", (Object)sb.toString());
        sb.append(FOO);
        Assertions.assertEquals((Object)"NULLNULLfoo", (Object)sb.toString());
        sb.append((String)null);
        Assertions.assertEquals((Object)"NULLNULLfooNULL", (Object)sb.toString());
        sb.append("");
        Assertions.assertEquals((Object)"NULLNULLfooNULL", (Object)sb.toString());
        sb.append("bar");
        Assertions.assertEquals((Object)"NULLNULLfooNULLbar", (Object)sb.toString());
        sb.append((StringBuffer)null);
        Assertions.assertEquals((Object)"NULLNULLfooNULLbarNULL", (Object)sb.toString());
        sb.append(new StringBuffer("baz"));
        Assertions.assertEquals((Object)"NULLNULLfooNULLbarNULLbaz", (Object)sb.toString());
    }

    @Test
    void testAppendWithSeparators_Array() {
        StrBuilder sb = new StrBuilder();
        sb.appendWithSeparators((Object[])null, ",");
        Assertions.assertEquals((Object)"", (Object)sb.toString());
        sb.clear();
        sb.appendWithSeparators(new Object[0], ",");
        Assertions.assertEquals((Object)"", (Object)sb.toString());
        sb.clear();
        sb.appendWithSeparators(new Object[]{"foo", "bar", "baz"}, ",");
        Assertions.assertEquals((Object)"foo,bar,baz", (Object)sb.toString());
        sb.clear();
        sb.appendWithSeparators(new Object[]{"foo", "bar", "baz"}, null);
        Assertions.assertEquals((Object)"foobarbaz", (Object)sb.toString());
        sb.clear();
        sb.appendWithSeparators(new Object[]{"foo", null, "baz"}, ",");
        Assertions.assertEquals((Object)"foo,,baz", (Object)sb.toString());
    }

    @Test
    void testAppendWithSeparators_Collection() {
        StrBuilder sb = new StrBuilder();
        sb.appendWithSeparators((Iterable)null, ",");
        Assertions.assertEquals((Object)"", (Object)sb.toString());
        sb.clear();
        sb.appendWithSeparators((Iterable)Collections.EMPTY_LIST, ",");
        Assertions.assertEquals((Object)"", (Object)sb.toString());
        sb.clear();
        sb.appendWithSeparators(Arrays.asList("foo", "bar", "baz"), ",");
        Assertions.assertEquals((Object)"foo,bar,baz", (Object)sb.toString());
        sb.clear();
        sb.appendWithSeparators(Arrays.asList("foo", "bar", "baz"), null);
        Assertions.assertEquals((Object)"foobarbaz", (Object)sb.toString());
        sb.clear();
        sb.appendWithSeparators(Arrays.asList("foo", null, "baz"), ",");
        Assertions.assertEquals((Object)"foo,,baz", (Object)sb.toString());
    }

    @Test
    void testAppendWithSeparators_Iterator() {
        StrBuilder sb = new StrBuilder();
        sb.appendWithSeparators((Iterator)null, ",");
        Assertions.assertEquals((Object)"", (Object)sb.toString());
        sb.clear();
        sb.appendWithSeparators(Collections.EMPTY_LIST.iterator(), ",");
        Assertions.assertEquals((Object)"", (Object)sb.toString());
        sb.clear();
        sb.appendWithSeparators(Arrays.asList("foo", "bar", "baz").iterator(), ",");
        Assertions.assertEquals((Object)"foo,bar,baz", (Object)sb.toString());
        sb.clear();
        sb.appendWithSeparators(Arrays.asList("foo", "bar", "baz").iterator(), null);
        Assertions.assertEquals((Object)"foobarbaz", (Object)sb.toString());
        sb.clear();
        sb.appendWithSeparators(Arrays.asList("foo", null, "baz").iterator(), ",");
        Assertions.assertEquals((Object)"foo,,baz", (Object)sb.toString());
    }

    @Test
    void testAppendWithSeparatorsWithNullText() {
        StrBuilder sb = new StrBuilder();
        sb.setNullText("null");
        sb.appendWithSeparators(new Object[]{"foo", null, "baz"}, ",");
        Assertions.assertEquals((Object)"foo,null,baz", (Object)sb.toString());
        sb.clear();
        sb.appendWithSeparators(Arrays.asList("foo", null, "baz"), ",");
        Assertions.assertEquals((Object)"foo,null,baz", (Object)sb.toString());
    }

    @Test
    void testInsert() {
        StrBuilder sb = new StrBuilder();
        sb.append("barbaz");
        Assertions.assertEquals((Object)"barbaz", (Object)sb.toString());
        LangAssertions.assertIndexOutOfBoundsException(() -> sb.insert(-1, FOO), "insert(-1, Object) expected StringIndexOutOfBoundsException");
        LangAssertions.assertIndexOutOfBoundsException(() -> sb.insert(7, FOO), "insert(7, Object) expected StringIndexOutOfBoundsException");
        sb.insert(0, null);
        Assertions.assertEquals((Object)"barbaz", (Object)sb.toString());
        sb.insert(0, FOO);
        Assertions.assertEquals((Object)"foobarbaz", (Object)sb.toString());
        sb.clear();
        sb.append("barbaz");
        Assertions.assertEquals((Object)"barbaz", (Object)sb.toString());
        LangAssertions.assertIndexOutOfBoundsException(() -> sb.insert(-1, "foo"), "insert(-1, String) expected StringIndexOutOfBoundsException");
        LangAssertions.assertIndexOutOfBoundsException(() -> sb.insert(7, "foo"), "insert(7, String) expected StringIndexOutOfBoundsException");
        sb.insert(0, (String)null);
        Assertions.assertEquals((Object)"barbaz", (Object)sb.toString());
        sb.insert(0, "foo");
        Assertions.assertEquals((Object)"foobarbaz", (Object)sb.toString());
        sb.clear();
        sb.append("barbaz");
        Assertions.assertEquals((Object)"barbaz", (Object)sb.toString());
        LangAssertions.assertIndexOutOfBoundsException(() -> sb.insert(-1, new char[]{'f', 'o', 'o'}), "insert(-1, char[]) expected StringIndexOutOfBoundsException");
        LangAssertions.assertIndexOutOfBoundsException(() -> sb.insert(7, new char[]{'f', 'o', 'o'}), "insert(7, char[]) expected StringIndexOutOfBoundsException");
        sb.insert(0, (char[])null);
        Assertions.assertEquals((Object)"barbaz", (Object)sb.toString());
        sb.insert(0, new char[0]);
        Assertions.assertEquals((Object)"barbaz", (Object)sb.toString());
        sb.insert(0, new char[]{'f', 'o', 'o'});
        Assertions.assertEquals((Object)"foobarbaz", (Object)sb.toString());
        sb.clear();
        sb.append("barbaz");
        Assertions.assertEquals((Object)"barbaz", (Object)sb.toString());
        LangAssertions.assertIndexOutOfBoundsException(() -> sb.insert(-1, new char[]{'a', 'b', 'c', 'f', 'o', 'o', 'd', 'e', 'f'}, 3, 3), "insert(-1, char[], 3, 3) expected StringIndexOutOfBoundsException");
        LangAssertions.assertIndexOutOfBoundsException(() -> sb.insert(7, new char[]{'a', 'b', 'c', 'f', 'o', 'o', 'd', 'e', 'f'}, 3, 3), "insert(7, char[], 3, 3) expected StringIndexOutOfBoundsException");
        sb.insert(0, null, 0, 0);
        Assertions.assertEquals((Object)"barbaz", (Object)sb.toString());
        sb.insert(0, new char[0], 0, 0);
        Assertions.assertEquals((Object)"barbaz", (Object)sb.toString());
        LangAssertions.assertIndexOutOfBoundsException(() -> sb.insert(0, new char[]{'a', 'b', 'c', 'f', 'o', 'o', 'd', 'e', 'f'}, -1, 3), "insert(0, char[], -1, 3) expected StringIndexOutOfBoundsException");
        LangAssertions.assertIndexOutOfBoundsException(() -> sb.insert(0, new char[]{'a', 'b', 'c', 'f', 'o', 'o', 'd', 'e', 'f'}, 10, 3), "insert(0, char[], 10, 3) expected StringIndexOutOfBoundsException");
        LangAssertions.assertIndexOutOfBoundsException(() -> sb.insert(0, new char[]{'a', 'b', 'c', 'f', 'o', 'o', 'd', 'e', 'f'}, 0, -1), "insert(0, char[], 0, -1) expected StringIndexOutOfBoundsException");
        LangAssertions.assertIndexOutOfBoundsException(() -> sb.insert(0, new char[]{'a', 'b', 'c', 'f', 'o', 'o', 'd', 'e', 'f'}, 0, 10), "insert(0, char[], 0, 10) expected StringIndexOutOfBoundsException");
        sb.insert(0, new char[]{'a', 'b', 'c', 'f', 'o', 'o', 'd', 'e', 'f'}, 0, 0);
        Assertions.assertEquals((Object)"barbaz", (Object)sb.toString());
        sb.insert(0, new char[]{'a', 'b', 'c', 'f', 'o', 'o', 'd', 'e', 'f'}, 3, 3);
        Assertions.assertEquals((Object)"foobarbaz", (Object)sb.toString());
        sb.clear();
        sb.append("barbaz");
        Assertions.assertEquals((Object)"barbaz", (Object)sb.toString());
        LangAssertions.assertIndexOutOfBoundsException(() -> sb.insert(-1, true), "insert(-1, boolean) expected StringIndexOutOfBoundsException");
        LangAssertions.assertIndexOutOfBoundsException(() -> sb.insert(7, true), "insert(7, boolean) expected StringIndexOutOfBoundsException");
        sb.insert(0, true);
        Assertions.assertEquals((Object)"truebarbaz", (Object)sb.toString());
        sb.insert(0, false);
        Assertions.assertEquals((Object)"falsetruebarbaz", (Object)sb.toString());
        sb.clear();
        sb.append("barbaz");
        Assertions.assertEquals((Object)"barbaz", (Object)sb.toString());
        LangAssertions.assertIndexOutOfBoundsException(() -> sb.insert(-1, '!'), "insert(-1, char) expected StringIndexOutOfBoundsException");
        LangAssertions.assertIndexOutOfBoundsException(() -> sb.insert(7, '!'), "insert(7, char) expected StringIndexOutOfBoundsException");
        sb.insert(0, '!');
        Assertions.assertEquals((Object)"!barbaz", (Object)sb.toString());
        sb.clear();
        sb.append("barbaz");
        Assertions.assertEquals((Object)"barbaz", (Object)sb.toString());
        LangAssertions.assertIndexOutOfBoundsException(() -> sb.insert(-1, 0), "insert(-1, int) expected StringIndexOutOfBoundsException");
        LangAssertions.assertIndexOutOfBoundsException(() -> sb.insert(7, 0), "insert(7, int) expected StringIndexOutOfBoundsException");
        sb.insert(0, '0');
        Assertions.assertEquals((Object)"0barbaz", (Object)sb.toString());
        sb.clear();
        sb.append("barbaz");
        Assertions.assertEquals((Object)"barbaz", (Object)sb.toString());
        LangAssertions.assertIndexOutOfBoundsException(() -> sb.insert(-1, 1L), "insert(-1, long) expected StringIndexOutOfBoundsException");
        LangAssertions.assertIndexOutOfBoundsException(() -> sb.insert(7, 1L), "insert(7, long) expected StringIndexOutOfBoundsException");
        sb.insert(0, 1L);
        Assertions.assertEquals((Object)"1barbaz", (Object)sb.toString());
        sb.clear();
        sb.append("barbaz");
        Assertions.assertEquals((Object)"barbaz", (Object)sb.toString());
        LangAssertions.assertIndexOutOfBoundsException(() -> sb.insert(-1, 2.3f), "insert(-1, float) expected StringIndexOutOfBoundsException");
        LangAssertions.assertIndexOutOfBoundsException(() -> sb.insert(7, 2.3f), "insert(7, float) expected StringIndexOutOfBoundsException");
        sb.insert(0, 2.3f);
        Assertions.assertEquals((Object)"2.3barbaz", (Object)sb.toString());
        sb.clear();
        sb.append("barbaz");
        Assertions.assertEquals((Object)"barbaz", (Object)sb.toString());
        LangAssertions.assertIndexOutOfBoundsException(() -> sb.insert(-1, 4.5), "insert(-1, double) expected StringIndexOutOfBoundsException");
        LangAssertions.assertIndexOutOfBoundsException(() -> sb.insert(7, 4.5), "insert(7, double) expected StringIndexOutOfBoundsException");
        sb.insert(0, 4.5);
        Assertions.assertEquals((Object)"4.5barbaz", (Object)sb.toString());
    }

    @Test
    void testInsertWithNullText() {
        StrBuilder sb = new StrBuilder();
        sb.setNullText("null");
        sb.append("barbaz");
        Assertions.assertEquals((Object)"barbaz", (Object)sb.toString());
        LangAssertions.assertIndexOutOfBoundsException(() -> sb.insert(-1, FOO), "insert(-1, Object) expected StringIndexOutOfBoundsException");
        LangAssertions.assertIndexOutOfBoundsException(() -> sb.insert(7, FOO), "insert(7, Object) expected StringIndexOutOfBoundsException");
        sb.insert(0, null);
        Assertions.assertEquals((Object)"nullbarbaz", (Object)sb.toString());
        sb.insert(0, FOO);
        Assertions.assertEquals((Object)"foonullbarbaz", (Object)sb.toString());
        sb.clear();
        sb.append("barbaz");
        Assertions.assertEquals((Object)"barbaz", (Object)sb.toString());
        LangAssertions.assertIndexOutOfBoundsException(() -> sb.insert(-1, "foo"), "insert(-1, String) expected StringIndexOutOfBoundsException");
        LangAssertions.assertIndexOutOfBoundsException(() -> sb.insert(7, "foo"), "insert(7, String) expected StringIndexOutOfBoundsException");
        sb.insert(0, (String)null);
        Assertions.assertEquals((Object)"nullbarbaz", (Object)sb.toString());
        sb.insert(0, "foo");
        Assertions.assertEquals((Object)"foonullbarbaz", (Object)sb.toString());
        sb.insert(0, (char[])null);
        Assertions.assertEquals((Object)"nullfoonullbarbaz", (Object)sb.toString());
        sb.insert(0, null, 0, 0);
        Assertions.assertEquals((Object)"nullnullfoonullbarbaz", (Object)sb.toString());
    }

    @Test
    void testLang299() {
        StrBuilder sb = new StrBuilder(1);
        sb.appendFixedWidthPadRight((Object)"foo", 1, '-');
        Assertions.assertEquals((Object)"f", (Object)sb.toString());
    }
}

